/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.dsl.DataSetListFlat;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefDataSetListFlat;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dsl/lazy"})
public class DataSetListLazyLoadingController {
    @Autowired
    protected JpaDataSetListService dataSetListService;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}"})
    @AuditAction(auditAction="Get information about dataset lists: {{#dataSetListId}}")
    @Operation(summary="Returns information about the selected DSL.")
    public DataSetListFlat getDataSetListFlat(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.dataSetListService.getDataSetListFlat(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#dataSetListId,'READ')")
    @GetMapping(value={"/{dataSetListId}/ReferenceByPath/{attributePath}"})
    @AuditAction(auditAction="Get information about referenced dataset lists by attr path")
    @Operation(summary="Returns information about the selected DSL.")
    public RefDataSetListFlat getReferencedDataSetList(@PathVariable(value="dataSetListId") UUID dataSetListId, @PathVariable(value="attributePath") String attributePath, @PageableDefault(size=15) Pageable pageable, @RequestBody(required=false) List<UUID> dataSetIds) {
        String[] split = attributePath.split("@");
        return this.dataSetListService.getReferencedDataSetListFlat(dataSetListId, UUID.fromString(split[split.length - 1]), attributePath.replaceAll("@", ","), dataSetIds, pageable);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(), 'READ')")
    @GetMapping(value={"/{dataSetListId}/ReferenceByPath/rows/{attributePath}"})
    @AuditAction(auditAction="Get information about referenced dataset lists by attr path")
    @Operation(summary="Returns information about the selected DSL.")
    public RefDataSetListFlat getReferencedDataSetListRows(@PathVariable(value="dataSetListId") UUID dataSetListId, @PathVariable(value="attributePath") String attributePath, @PageableDefault(size=15) Pageable pageable, @RequestBody(required=false) List<UUID> dataSetIds) {
        String[] split = attributePath.split("@");
        return this.dataSetListService.getReferencedDataSetListFlatRows(dataSetListId, UUID.fromString(split[split.length - 1]), attributePath.replaceAll("@", ","), dataSetIds, pageable);
    }
}

