/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.ws.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.qubership.atp.dataset.service.ws.event.Event;
import org.springframework.web.socket.WebSocketSession;

public class EventHandler {
    private static final Map<String, HashMap<String, WebSocketSession>> SOCKET_MAP = new ConcurrentHashMap<String, HashMap<String, WebSocketSession>>();
    private static final Map<String, HashMap<String, String>> sessionHandler = new ConcurrentHashMap<String, HashMap<String, String>>();

    public void add(Event event, WebSocketSession webSocket) {
        SOCKET_MAP.computeIfAbsent(event.getDataSetListId(), key -> new HashMap()).put(event.getSessionId(), webSocket);
        sessionHandler.computeIfAbsent(event.getDataSetListId(), key -> new HashMap()).put(event.getSessionId(), webSocket.getLocalAddress().getHostName());
    }

    public Collection<WebSocketSession> getWebSockets(Event event) {
        Map socketMap = SOCKET_MAP.get(event.getDataSetListId());
        if (socketMap == null) {
            return Collections.emptyList();
        }
        return socketMap.values();
    }

    public void remove(Event event) {
        this.removeFromMap(event, SOCKET_MAP);
        this.removeFromMap(event, sessionHandler);
    }

    public void remove(WebSocketSession webSocket) {
        Pair<String, String> dsPath = this.getDsPath(webSocket);
        String dslId = dsPath.getFirst();
        String sessionId = dsPath.getSecond();
        this.removeFromMap(dslId, sessionId, SOCKET_MAP);
        this.removeFromMap(dslId, sessionId, sessionHandler);
    }

    private <U> void removeFromMap(Event event, Map<String, HashMap<String, U>> map) {
        this.removeFromMap(event.getDataSetListId(), event.getSessionId(), map);
    }

    private <U> void removeFromMap(String dslId, String sessionId, Map<String, HashMap<String, U>> map) {
        Map subMap = map.get(dslId);
        if (subMap == null) {
            return;
        }
        subMap.remove(sessionId);
    }

    public Pair<String, String> getDsPath(WebSocketSession socket) {
        Pair<String, String> pair = new Pair<String, String>();
        Optional<Map.Entry> optional = SOCKET_MAP.entrySet().stream().filter(entry -> {
            Optional<Map.Entry> first = ((HashMap)entry.getValue()).entrySet().stream().filter(socketEntry -> socketEntry.getValue() == socket).findFirst();
            first.ifPresent(record -> pair.setSecond((String)record.getKey()));
            return first.isPresent();
        }).findFirst();
        optional.ifPresent(stringHashMapEntry -> pair.setFirst((String)stringHashMapEntry.getKey()));
        return pair;
    }

    public Collection<String> getHosts(String sessionId, String dsl) {
        HashMap<String, String> dslMap = sessionHandler.get(dsl);
        if (dslMap.isEmpty()) {
            return Collections.emptyList();
        }
        return dslMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(sessionId)).map(entry -> (String)entry.getKey() + ',' + (String)entry.getValue()).collect(Collectors.toList());
    }
}

