/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.model.domain.AttributeKeySnapshot;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ListValueSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;
import org.qubership.atp.dataset.versioning.model.ui.OverlapUiNode;
import org.qubership.atp.dataset.versioning.model.ui.ParameterUiModel;

@Value
public class AttributeUiModel {
    private UUID id;
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<ParameterUiModel> parameters = new LinkedList<ParameterUiModel>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<AttributeUiModel> attributes = new LinkedList<AttributeUiModel>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<ListValueSnapshot> listValues = new LinkedList<ListValueSnapshot>();
    private AttributeTypeName type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UUID dataSetListReference;

    public AttributeUiModel(AttributeSnapshot snapshot, List<AttributeKeySnapshot> overlaps, ModelsProvider modelsProvider) {
        this.id = snapshot.getId();
        this.name = snapshot.getName();
        this.type = snapshot.getType();
        this.dataSetListReference = snapshot.getDataSetListReference();
        for (ParameterSnapshot parameter : snapshot.getParameters()) {
            this.parameters.add(new ParameterUiModel(parameter, modelsProvider, false));
        }
        List<OverlapUiNode> nodes = OverlapUiNode.getNodes(overlaps, modelsProvider);
        for (OverlapUiNode node : nodes) {
            if (!node.getAttributeId().equals(this.id)) continue;
            for (OverlapUiNode childNode : node.getNodes().values()) {
                this.attributes.add(new AttributeUiModel(childNode, modelsProvider));
            }
            for (AttributeKeySnapshot attributeKeySnapshot : node.getOverlapsList()) {
                this.addAttributeIfNotExists(this.attributes, attributeKeySnapshot, modelsProvider);
            }
        }
    }

    private void addAttributeIfNotExists(List<AttributeUiModel> attributes, AttributeKeySnapshot overlap, ModelsProvider modelsProvider) {
        AttributeUiModel attribute = this.getAttributeById(overlap.getAttributeId());
        if (attribute == null) {
            attributes.add(new AttributeUiModel(overlap, modelsProvider));
        } else {
            attribute.parameters.add(new ParameterUiModel(overlap.getParameter(), modelsProvider, true));
        }
    }

    private AttributeUiModel getAttributeById(UUID attributeId) {
        for (AttributeUiModel attribute : this.attributes) {
            if (!attribute.getId().equals(attributeId)) continue;
            return attribute;
        }
        return null;
    }

    public AttributeUiModel(OverlapUiNode node, ModelsProvider modelsProvider) {
        this.id = node.getAttributeId();
        this.name = node.getName();
        this.type = AttributeTypeName.DSL;
        for (OverlapUiNode childNode : node.getNodes().values()) {
            this.attributes.add(new AttributeUiModel(childNode, modelsProvider));
        }
        for (AttributeKeySnapshot attributeKeySnapshot : node.getOverlapsList()) {
            this.addAttributeIfNotExists(this.attributes, attributeKeySnapshot, modelsProvider);
        }
    }

    public AttributeUiModel(AttributeKeySnapshot overlap, ModelsProvider modelsProvider) {
        this.id = overlap.getAttributeId();
        this.name = overlap.getAttributeName();
        this.type = AttributeTypeName.DSL;
        this.parameters.add(new ParameterUiModel(overlap.getParameter(), modelsProvider, true));
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ParameterUiModel> getParameters() {
        return this.parameters;
    }

    public List<AttributeUiModel> getAttributes() {
        return this.attributes;
    }

    public List<ListValueSnapshot> getListValues() {
        return this.listValues;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public UUID getDataSetListReference() {
        return this.dataSetListReference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeUiModel)) {
            return false;
        }
        AttributeUiModel other = (AttributeUiModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ParameterUiModel> this$parameters = this.getParameters();
        List<ParameterUiModel> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<AttributeUiModel> this$attributes = this.getAttributes();
        List<AttributeUiModel> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<ListValueSnapshot> this$listValues = this.getListValues();
        List<ListValueSnapshot> other$listValues = other.getListValues();
        if (this$listValues == null ? other$listValues != null : !((Object)this$listValues).equals(other$listValues)) {
            return false;
        }
        AttributeTypeName this$type = this.getType();
        AttributeTypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        UUID this$dataSetListReference = this.getDataSetListReference();
        UUID other$dataSetListReference = other.getDataSetListReference();
        return !(this$dataSetListReference == null ? other$dataSetListReference != null : !((Object)this$dataSetListReference).equals(other$dataSetListReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeUiModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ParameterUiModel> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<AttributeUiModel> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<ListValueSnapshot> $listValues = this.getListValues();
        result = result * 59 + ($listValues == null ? 43 : ((Object)$listValues).hashCode());
        AttributeTypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        UUID $dataSetListReference = this.getDataSetListReference();
        result = result * 59 + ($dataSetListReference == null ? 43 : ((Object)$dataSetListReference).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeUiModel(id=" + this.getId() + ", name=" + this.getName() + ", parameters=" + this.getParameters() + ", attributes=" + this.getAttributes() + ", listValues=" + this.getListValues() + ", type=" + (Object)((Object)this.getType()) + ", dataSetListReference=" + this.getDataSetListReference() + ")";
    }
}

