/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class CreateOverlapProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(CreateOverlapProcessor.class);
    @Autowired
    ModelsProvider modelsProvider;

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ParameterComparable> newOverlappedParameters = CreateOverlapProcessor.findOverlappedParametersByChangeType(diff, NewObject.class);
        return !newOverlappedParameters.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        boolean isDsNameIsEmpty = actualEntity.getDataSets().isEmpty();
        ParameterComparable overlappedParameter = CreateOverlapProcessor.findOverlappedParametersByChangeType(diff, NewObject.class).get(0);
        String dataSetName = isDsNameIsEmpty ? "*NotFoundNameDS*" : CreateOverlapProcessor.getDataSetById(actualEntity, overlappedParameter.getDataSet()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setDataSet(dataSetName);
        if (!isDsNameIsEmpty) {
            String value = overlappedParameter.getValue().toString();
            historyItem.setChangeSummary(ChangeSummary.OVERRIDE_CREATE.toString());
            historyItem.setAttribute(overlappedParameter.getAttributeName());
            historyItem.setNewValue(this.getValuePretty(value, overlappedParameter.getType(), this.modelsProvider));
            log.trace("Diff processed by NewOverlappedParameterChangeProcessor");
        }
        return historyItem;
    }
}

