/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import au.com.dius.pact.provider.junit5.PactVerificationContext;
import au.com.dius.pact.provider.junit5.PactVerificationInvocationContextProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import au.com.dius.pact.provider.junitsupport.State;
import au.com.dius.pact.provider.junitsupport.loader.PactUrl;
import au.com.dius.pact.provider.spring.junit5.MockMvcTestTarget;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListImportService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListCheckService;
import org.qubership.atp.dataset.service.jpa.impl.MetricsService;
import org.qubership.atp.dataset.service.rest.facade.AttachmentControllerFacade;
import org.qubership.atp.dataset.service.rest.server.AttachmentController;
import org.qubership.atp.dataset.service.rest.server.DataSetListController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;

@Isolated
@au.com.dius.pact.provider.junitsupport.Provider(value="atp-datasets")
@PactUrl(urls={"src/test/resources/pacts/atp-orchestrator-atp-datasets.json"})
@AutoConfigureMockMvc(addFilters=false, webDriverEnabled=false)
@WebMvcTest(controllers={DataSetListController.class, AttachmentController.class})
@ContextConfiguration(classes={TestApp.class})
@EnableAutoConfiguration
@Import(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, DataSetListController.class, AttachmentController.class})
public class DatasetsAndOrchestratorContractTest {
    private static final Logger log = LoggerFactory.getLogger(DatasetsAndOrchestratorContractTest.class);
    @Autowired
    private MockMvc mockMvc;
    @MockBean
    private AttachmentControllerFacade attachmentControllerFacade;
    @MockBean
    private MetricsService metricsService;
    @MockBean
    private ConcurrentModificationService concurrentModificationService;
    @MockBean
    private DataSetListService dslService;
    @MockBean
    private DataSetListCheckService dataSetListCheckService;
    @MockBean
    private JpaDataSetListService jpaDataSetListService;
    @MockBean
    private AttributeService attributeService;
    @MockBean
    private Provider<UserInfo> userInfoProvider;
    @MockBean
    private DatasetListExportService datasetListExportService;
    @MockBean
    private DatasetListImportService importService;
    @MockBean
    private ParameterService parameterService;
    @MockBean
    private JpaParameterService jpaParameterService;
    @MockBean
    private GridFsService gridFsService;
    @MockBean
    private DataSetService dataSetService;

    public void beforeAll() throws DataSetServiceException {
        ArrayList<DatasetResponse> resultList = new ArrayList<DatasetResponse>();
        DatasetResponse datasetResponse = new DatasetResponse(UUID.randomUUID(), "dsName", UUID.randomUUID(), "dslName");
        resultList.add(datasetResponse);
        UUID id = UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01");
        ByteArrayInputStream inputStream = new ByteArrayInputStream("blabla".getBytes());
        Optional<ByteArrayInputStream> optional = Optional.ofNullable(inputStream);
        FileData fileData = new FileData();
        fileData.setContentType("multipart/form-data");
        fileData.setFileName("name");
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename("name", StandardCharsets.UTF_8).build();
        InputStreamResource inputStreamResource = new InputStreamResource((InputStream)inputStream);
        ResponseEntity re = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)fileData.getContentType())).header("Content-Disposition", new String[]{contentDisposition.toString()})).body((Object)inputStreamResource);
        Mockito.when((Object)this.dslService.getListOfDsIdsAndNameAndDslId((List)ArgumentMatchers.any())).thenReturn(resultList);
        Mockito.when((Object)this.gridFsService.get(id)).thenReturn(optional);
        Mockito.when((Object)this.gridFsService.getFileInfo(id)).thenReturn((Object)fileData);
        Mockito.when((Object)this.attachmentControllerFacade.getAttachmentByParameterId((UUID)ArgumentMatchers.any())).thenReturn((Object)re);
    }

    @TestTemplate
    @ExtendWith(value={PactVerificationInvocationContextProvider.class})
    void pactVerificationTestTemplate(PactVerificationContext context) {
        context.verifyInteraction();
    }

    @BeforeEach
    void before(PactVerificationContext context) throws Exception {
        this.beforeAll();
        context.setTarget((TestTarget)new MockMvcTestTarget(this.mockMvc));
    }

    @State(value={"all ok"})
    public void allPass() {
    }

    @Configuration
    public static class TestApp {
    }
}

