/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.ei.model.DataSetList;
import org.qubership.atp.dataset.ei.model.IdEntity;
import org.qubership.atp.dataset.ei.service.DataSetListImporter;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaVisibilityAreaService;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetListImporterTest {
    private ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private DataSetListImporter dataSetListImporter;
    @Mock
    private JpaDataSetListService dslService;
    @Mock
    private JpaVisibilityAreaService vaService;
    private DuplicateNameChecker duplicateNameChecker;
    @Mock
    private EntityManagerController entityManagerController;
    private ExportImportData importData;

    @BeforeEach
    public void setUp() throws Exception {
        this.duplicateNameChecker = new DuplicateNameChecker();
        this.objectLoaderFromDiskService = new ObjectLoaderFromDiskService();
        this.dataSetListImporter = new DataSetListImporter(this.objectLoaderFromDiskService, this.dslService, this.vaService, this.duplicateNameChecker, this.entityManagerController);
        this.importData = new ExportImportData(null, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
    }

    @Test
    public void importDataSetLists_createNewVa() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206208", new String[0]);
        Mockito.when((Object)this.vaService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        List result = this.dataSetListImporter.importDataSetLists(workDir, this.importData);
        Assertions.assertTrue((boolean)result.contains(UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")));
        ((JpaVisibilityAreaService)Mockito.verify((Object)this.vaService, (VerificationMode)Mockito.times((int)1))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (String)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)1))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (String)ArgumentMatchers.eq((Object)"export test simple"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)0))).save((org.qubership.atp.dataset.service.jpa.delegates.DataSetList)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetLists_vaExistsDoNotCreateIt() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206208", new String[0]);
        Mockito.when((Object)this.vaService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((VisibilityArea)Mockito.mock(VisibilityArea.class)));
        List result = this.dataSetListImporter.importDataSetLists(workDir, this.importData);
        Assertions.assertTrue((boolean)result.contains(UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")));
        ((JpaVisibilityAreaService)Mockito.verify((Object)this.vaService, (VerificationMode)Mockito.times((int)0))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (String)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)1))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (String)ArgumentMatchers.eq((Object)"export test simple"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)0))).save((org.qubership.atp.dataset.service.jpa.delegates.DataSetList)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetLists_1() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206208", new String[0]);
        Mockito.when((Object)this.vaService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((VisibilityArea)Mockito.mock(VisibilityArea.class)));
        Mockito.when((Object)this.dslService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((org.qubership.atp.dataset.service.jpa.delegates.DataSetList)Mockito.mock(org.qubership.atp.dataset.service.jpa.delegates.DataSetList.class)));
        List result = this.dataSetListImporter.importDataSetLists(workDir, this.importData);
        Assertions.assertTrue((boolean)result.contains(UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")));
        ((JpaVisibilityAreaService)Mockito.verify((Object)this.vaService, (VerificationMode)Mockito.times((int)0))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (String)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)0))).replicate((UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (String)ArgumentMatchers.eq((Object)"export test simple"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("9f052227-79d7-4f3f-bd55-aeb2efbcb103")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75")), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Timestamp)ArgumentMatchers.any());
        ((JpaDataSetListService)Mockito.verify((Object)this.dslService, (VerificationMode)Mockito.times((int)1))).save((org.qubership.atp.dataset.service.jpa.delegates.DataSetList)ArgumentMatchers.any());
    }

    @Test
    public void checkAndCorrectName_noDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetList object = new DataSetList();
        object.setName(name);
        object.setId(id);
        this.dataSetListImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetList object = new DataSetList();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setVisibilityArea(parentId);
        DataSetList entity = new DataSetList();
        entity.setName(name);
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetListImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameButWithOtherNameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetList object = new DataSetList();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setVisibilityArea(parentId);
        DataSetList entity = new DataSetList();
        entity.setName("Object Name 2");
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetListImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_twoDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetList object = new DataSetList();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setVisibilityArea(parentId);
        DataSetList entity = new DataSetList();
        entity.setName(name);
        entity.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        DataSetList entity2 = new DataSetList();
        entity2.setName(name + " Copy");
        entity2.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity2);
        DataSetList entity3 = new DataSetList();
        entity3.setName(name + " Copy _1");
        entity3.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity3);
        this.dataSetListImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)(name + " Copy _2"));
    }
}

