/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.ChangeType;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;

public class MultiplyTestData
implements Supplier<VisibilityArea> {
    public static final String TEST_NAME = "Account: B2B, Subscription: Pro Start";
    public static final String TEST_ER = "{  \"Account\" : {    \"AccountNum\" : \"B2B1\",    \"TaxInclusiveBoo\" : \"FALSE\"  },  \"Subscription\" : {    \"ProductId\" : \"10002\",    \"TariffId\" : \"10036\"  }}";
    public static final List<String> DS_NAMES = Lists.newArrayList((Object[])new String[]{"Account: Residential, Subscription: BASE Check 25", "Account: Residential, Subscription: Pro Start", "Account: Residential, Subscription: BASE 30", "Account: B2B, Subscription: BASE Check 25", "Account: B2B, Subscription: Pro Start", "Account: B2B, Subscription: BASE 30"});
    public static final List<String> ACCOUNT_NAMES = Lists.newArrayList((Object[])new String[]{"Residential", "B2B"});
    public static final List<String> SUBSCRIPTION_NAMES = Lists.newArrayList((Object[])new String[]{"BASE Check 25", "Pro Start", "BASE 30"});
    public static final String DS_NAME_W_PLACEHOLDERS = "Account: ${Account}, Subscription: ${Subscription}";
    public final VisibilityArea va;
    public final DataSetList accounts;
    public final DataSet resCA;
    public final Parameter resAccNum;
    public final Attribute accNum;
    public final Parameter resTax;
    public final Attribute tax;
    public final DataSet b2bCA;
    public final Parameter b2bAccNum;
    public final Parameter b2bTax;
    public final DataSetList subscriptions;
    public final DataSet baseCheck;
    public final Parameter baseCheckProductId;
    public final Attribute productId;
    public final Parameter baseCheckTariffId;
    public final Attribute tariffId;
    public final DataSet proStart;
    public final Parameter proStartProductId;
    public final Parameter proStartTariffId;
    public final DataSet base;
    public final Parameter baseProductId;
    public final Parameter baseTariffId;
    public final DataSetList requested;
    public final DataSet mix;
    public final Parameter mixAccount;
    public final Parameter mixSubscription;
    public final String expectedJson;

    public MultiplyTestData(CreationFacade create) {
        this.va = create.va("va");
        this.accounts = create.dsl(this.va, "Account");
        this.resCA = create.ds(this.accounts, ACCOUNT_NAMES.get(0));
        this.resAccNum = create.textParam(this.resCA, "AccountNum", "RES#RANDOMBETWEEN(100000000,999999999)");
        this.accNum = this.resAccNum.getAttribute();
        this.resTax = create.listParam(this.resCA, "TaxInclusiveBoo", "TRUE", new String[]{"TRUE", "FALSE"});
        this.tax = this.resTax.getAttribute();
        this.b2bCA = create.ds(this.accounts, ACCOUNT_NAMES.get(1));
        this.b2bAccNum = create.textParam(this.b2bCA, this.accNum, "B2B#RANDOMBETWEEN(1,1)");
        this.b2bTax = create.listParam(this.b2bCA, this.tax, "FALSE");
        this.subscriptions = create.dsl(this.va, "Subscription");
        this.baseCheck = create.ds(this.subscriptions, SUBSCRIPTION_NAMES.get(0));
        this.baseCheckProductId = create.textParam(this.baseCheck, "ProductId", "649");
        this.productId = this.baseCheckProductId.getAttribute();
        this.baseCheckTariffId = create.textParam(this.baseCheck, "TariffId", "1210");
        this.tariffId = this.baseCheckTariffId.getAttribute();
        this.proStart = create.ds(this.subscriptions, SUBSCRIPTION_NAMES.get(1));
        this.proStartProductId = create.textParam(this.proStart, this.productId, "10002");
        this.proStartTariffId = create.textParam(this.proStart, this.tariffId, "10036");
        this.base = create.ds(this.subscriptions, SUBSCRIPTION_NAMES.get(2));
        this.baseProductId = create.textParam(this.base, this.productId, "649");
        this.baseTariffId = create.textParam(this.base, this.tariffId, "1203");
        this.requested = create.dsl(this.va, "Requested");
        this.mix = create.ds(this.requested, DS_NAME_W_PLACEHOLDERS);
        this.mixAccount = create.schangeParam(this.mix, "Account", this.accounts, ChangeType.MULTIPLY, new UUID[]{this.resCA.getId(), this.b2bCA.getId()});
        this.mixSubscription = create.schangeParam(this.mix, "Subscription", this.subscriptions, ChangeType.MULTIPLY, new UUID[]{this.baseCheck.getId(), this.proStart.getId(), this.base.getId()});
        this.expectedJson = "{    \"id\": \"" + this.mix.getDataSetList().getId() + "\",    \"name\": \"Requested\",    \"dataSets\": [{            \"id\": \"" + this.mix.getId() + "\",            \"name\": \"Account: ${Account}, Subscription: ${Subscription}\",            \"locked\": false        }    ],    \"attributes\": [{            \"id\": \"" + this.mixAccount.getAttribute().getId() + "\",            \"name\": \"Account\",            \"type\": \"CHANGE\",            \"dataSetListReference\": \"" + this.accounts.getId() + "\",            \"parameters\": [{                    \"dataSet\": \"" + this.mix.getId() + "\",                    \"value\": " + String.format("          \"MULTIPLY %s %s\"", this.resCA.getId(), this.b2bCA.getId()) + "                    ,                    \"overlap\": false                }            ]        }, {            \"id\": \"" + this.mixSubscription.getAttribute().getId() + "\",            \"name\": \"Subscription\",            \"type\": \"CHANGE\",            \"dataSetListReference\": \"" + this.subscriptions.getId() + "\",            \"parameters\": [{                    \"dataSet\": \"" + this.mix.getId() + "\",                    \"value\": " + String.format("          \"MULTIPLY %s %s %s\"", this.baseCheck.getId(), this.proStart.getId(), this.base.getId()) + "                    ,                    \"overlap\": false                }            ]        }    ]}";
    }

    @Override
    public VisibilityArea get() {
        return this.va;
    }
}

