/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.BeforeClass;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefDataSetListAttribute;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefDataSetListFlat;
import org.qubership.atp.dataset.service.jpa.service.AbstractJpaTest;
import org.qubership.atp.dataset.service.rest.server.CopyDataSetListsResponse;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Disabled
@SpringBootTest
@ContextConfiguration(classes={TestConfiguration.class})
@ExtendWith(value={SpringExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class JpaDataSetListServiceImplTest
extends AbstractJpaTest {
    private static Map<UUID, String> datasetListsMap = new HashMap<UUID, String>();
    private UUID visibilityAreaId = UUID.fromString("b703c594-e214-49cc-bda7-4eb51311ddb1");

    @BeforeClass
    public static void generateData() {
        datasetListsMap.put(UUID.fromString("39d0e387-1150-4344-a061-4b81a6a571df"), "Test DataSetList 1");
        datasetListsMap.put(UUID.fromString("da430230-6c37-42ee-8b6c-f855e6024eed"), "Test DataSetList 2");
        datasetListsMap.put(UUID.fromString("c5e341f7-8c6e-437b-9af0-850710dffd83"), "Test DataSetList 3");
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void copyDataSetLists_withPrevNamePattern() {
        List<PrevNamePatternTestCase> testCases = Arrays.asList(new PrevNamePatternTestCase("DS Release 23.1", "Release 23.1", "Release 23.2", "DS Release 23.2"), new PrevNamePatternTestCase("DS Release 23.1 DS", "Release 23.1", "Release 23.2", "DS Release 23.2 DS"), new PrevNamePatternTestCase("Release 23.1 DS", "Release 23.1", "Release 23.2", "Release 23.2 DS"), new PrevNamePatternTestCase("DS Release 23.1 Release 23.1 test", "Release 23.1", "Release 23.2", "DS Release 23.2 Release 23.2 test"), new PrevNamePatternTestCase("DS Release 23.1", "Release 23.1", null, "DS Copy"), new PrevNamePatternTestCase("DS Release 23.3", "Release 23.1", "Release 23.2", "DS Release 23.3 Release 23.2"));
        HashMap<String, DataSetList> createdDslMap = new HashMap<String, DataSetList>();
        for (PrevNamePatternTestCase testCase : testCases) {
            DataSetList createdDataSetList;
            if (createdDslMap.containsKey(testCase.getInitialDslName())) {
                createdDataSetList = (DataSetList)createdDslMap.get(testCase.getInitialDslName());
            } else {
                createdDataSetList = this.dataSetListService.create(testCase.getInitialDslName(), this.visibilityAreaId);
                createdDslMap.put(testCase.getInitialDslName(), createdDataSetList);
            }
            List copyResponse = this.dataSetListService.copyDataSetLists(Collections.singletonList(createdDataSetList.getId()), true, null, testCase.getPostfix(), testCase.getPrevNamePattern(), null);
            for (CopyDataSetListsResponse response : copyResponse) {
                DataSetList copiedDatasetList = this.dataSetListService.getById(response.getCopyId());
                Assertions.assertEquals((Object)testCase.getExpectedName(), (Object)copiedDatasetList.getName());
            }
        }
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void copyDataSetLists_withoutPostfix() {
        List result = this.dataSetListService.copyDataSetLists(new ArrayList<UUID>(datasetListsMap.keySet()), true, null, null);
        for (CopyDataSetListsResponse response : result) {
            DataSetList copiedDatasetList = this.dataSetListService.getById(response.getCopyId());
            Assertions.assertEquals((Object)(datasetListsMap.get(response.getOriginalId()) + " Copy"), (Object)copiedDatasetList.getName());
        }
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void copyDataSetLists_withPostfix() {
        String postfix = "test";
        List result = this.dataSetListService.copyDataSetLists(new ArrayList<UUID>(datasetListsMap.keySet()), true, postfix, null);
        for (CopyDataSetListsResponse response : result) {
            DataSetList copiedDatasetList = this.dataSetListService.getById(response.getCopyId());
            Assertions.assertEquals((Object)(datasetListsMap.get(response.getOriginalId()) + " " + postfix), (Object)copiedDatasetList.getName());
        }
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void copyDataSetLists_copiedDataSetListNameAlreadyExists() {
        this.dataSetListService.copyDataSetLists(new ArrayList<UUID>(datasetListsMap.keySet()), true, null, null);
        List result = this.dataSetListService.copyDataSetLists(new ArrayList<UUID>(datasetListsMap.keySet()), true, null, null);
        for (CopyDataSetListsResponse response : result) {
            DataSetList copiedDatasetList = this.dataSetListService.getById(response.getCopyId());
            Assertions.assertEquals((Object)(datasetListsMap.get(response.getOriginalId()) + " Copy Copy"), (Object)copiedDatasetList.getName());
        }
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void getReferencedDataSetListFlat_maxPageSize() {
        UUID dslId = UUID.fromString("39d0e387-1150-4344-a061-4b81a6a571df");
        UUID dslAttrId = UUID.fromString("686026e5-26d8-4feb-9b11-c56eb9f72e0d");
        PageRequest pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        RefDataSetListFlat res = this.dataSetListService.getReferencedDataSetListFlat(dslId, dslAttrId, "686026e5-26d8-4feb-9b11-c56eb9f72e0d", null, (Pageable)pageable);
        Assertions.assertEquals((int)4, (int)res.getAttributes().size());
        Assertions.assertEquals((int)2, (int)((RefDataSetListAttribute)res.getAttributes().get(0)).getParameters().size());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void getReferencedDataSetListFlat_minPageSize() {
        UUID dslId = UUID.fromString("39d0e387-1150-4344-a061-4b81a6a571df");
        UUID dslAttrId = UUID.fromString("686026e5-26d8-4feb-9b11-c56eb9f72e0d");
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        RefDataSetListFlat res = this.dataSetListService.getReferencedDataSetListFlat(dslId, dslAttrId, "686026e5-26d8-4feb-9b11-c56eb9f72e0d", null, (Pageable)pageable);
        Assertions.assertEquals((int)4, (int)res.getAttributes().size());
        Assertions.assertEquals((int)1, (int)((RefDataSetListAttribute)res.getAttributes().get(0)).getParameters().size());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_data_set_list_service_lmpl_test/jpaDataSetListImplTest.sql"})
    public void copyDataSetLists_withSagaSessionId() {
        UUID sagaSessionId = UUID.randomUUID();
        List result = this.dataSetListService.copyDataSetLists(new ArrayList<UUID>(datasetListsMap.keySet()), true, null, null, null, sagaSessionId);
        for (CopyDataSetListsResponse response : result) {
            DataSetList copiedDatasetList = this.dataSetListService.getById(response.getCopyId());
            Assertions.assertEquals((Object)(datasetListsMap.get(response.getOriginalId()) + " Copy Copy"), (Object)copiedDatasetList.getName());
            Assertions.assertEquals((Object)sagaSessionId, (Object)copiedDatasetList.getSagaSessionId());
        }
    }

    private static class PrevNamePatternTestCase {
        private String initialDslName;
        private String prevNamePattern;
        private String postfix;
        private String expectedName;

        public String getInitialDslName() {
            return this.initialDslName;
        }

        public String getPrevNamePattern() {
            return this.prevNamePattern;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String getExpectedName() {
            return this.expectedName;
        }

        public void setInitialDslName(String initialDslName) {
            this.initialDslName = initialDslName;
        }

        public void setPrevNamePattern(String prevNamePattern) {
            this.prevNamePattern = prevNamePattern;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }

        public void setExpectedName(String expectedName) {
            this.expectedName = expectedName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrevNamePatternTestCase)) {
                return false;
            }
            PrevNamePatternTestCase other = (PrevNamePatternTestCase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$initialDslName = this.getInitialDslName();
            String other$initialDslName = other.getInitialDslName();
            if (this$initialDslName == null ? other$initialDslName != null : !this$initialDslName.equals(other$initialDslName)) {
                return false;
            }
            String this$prevNamePattern = this.getPrevNamePattern();
            String other$prevNamePattern = other.getPrevNamePattern();
            if (this$prevNamePattern == null ? other$prevNamePattern != null : !this$prevNamePattern.equals(other$prevNamePattern)) {
                return false;
            }
            String this$postfix = this.getPostfix();
            String other$postfix = other.getPostfix();
            if (this$postfix == null ? other$postfix != null : !this$postfix.equals(other$postfix)) {
                return false;
            }
            String this$expectedName = this.getExpectedName();
            String other$expectedName = other.getExpectedName();
            return !(this$expectedName == null ? other$expectedName != null : !this$expectedName.equals(other$expectedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrevNamePatternTestCase;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $initialDslName = this.getInitialDslName();
            result = result * 59 + ($initialDslName == null ? 43 : $initialDslName.hashCode());
            String $prevNamePattern = this.getPrevNamePattern();
            result = result * 59 + ($prevNamePattern == null ? 43 : $prevNamePattern.hashCode());
            String $postfix = this.getPostfix();
            result = result * 59 + ($postfix == null ? 43 : $postfix.hashCode());
            String $expectedName = this.getExpectedName();
            result = result * 59 + ($expectedName == null ? 43 : $expectedName.hashCode());
            return result;
        }

        public String toString() {
            return "JpaDataSetListServiceImplTest.PrevNamePatternTestCase(initialDslName=" + this.getInitialDslName() + ", prevNamePattern=" + this.getPrevNamePattern() + ", postfix=" + this.getPostfix() + ", expectedName=" + this.getExpectedName() + ")";
        }

        public PrevNamePatternTestCase(String initialDslName, String prevNamePattern, String postfix, String expectedName) {
            this.initialDslName = initialDslName;
            this.prevNamePattern = prevNamePattern;
            this.postfix = postfix;
            this.expectedName = expectedName;
        }
    }
}

