/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@EnableSchedulerLock(defaultLockAtMostFor="10m", defaultLockAtLeastFor="10m")
public class SchedulerConfig {
    private static final String UTC_TIMEZONE = "UTC";

    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        JdbcTemplateLockProvider.Configuration configuration = JdbcTemplateLockProvider.Configuration.builder().withJdbcTemplate(new JdbcTemplate(dataSource)).withTimeZone(TimeZone.getTimeZone(UTC_TIMEZONE)).build();
        return new JdbcTemplateLockProvider(configuration);
    }
}

