/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.utils;

import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.utils.Utils;

public class Proxies {
    public static <T extends Identified, IdT> T withId(@Nonnull Class<T> type, @Nonnull IdT id, @Nonnull Function<IdT, ? extends T> sourceFunc) {
        return (T)((Identified)Reflection.newProxy(type, new IdBasedCachingH(type, id, sourceFunc)));
    }

    public static <T> List<T> list(@Nonnull Supplier<List<T>> sup) {
        return Proxies.base(List.class, sup);
    }

    public static <T> T base(@Nonnull Class<T> type, @Nonnull Supplier<? extends T> sup) {
        return (T)Reflection.newProxy(type, new CachingH(type, sup));
    }

    @NotThreadSafe
    private static class IdBasedCachingH<T extends Identified, IdT>
    implements InvocationHandler {
        private final Class<T> type;
        private final IdT id;
        private final Function<IdT, ? extends T> sourceFunc;
        private boolean initialized;
        private T cachedValue;

        private IdBasedCachingH(@Nonnull Class<T> type, @Nonnull IdT id, @Nonnull Function<IdT, ? extends T> sourceFunc) {
            this.type = type;
            this.id = id;
            this.sourceFunc = sourceFunc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (this.initialized) {
                return method.invoke(this.cachedValue, args);
            }
            switch (methodName = method.getName()) {
                case "equals": {
                    Object target = args[0];
                    return proxy == target || Utils.isEqual(this.type, this.id, target);
                }
                case "hashCode": {
                    return Objects.hashCode(this.id);
                }
                case "getId": {
                    return this.id;
                }
            }
            this.cachedValue = (Identified)Preconditions.checkNotNull((Object)((Identified)this.sourceFunc.apply(this.id)), (String)"[%s] with id [%s] is not provided by [%s]", this.type, this.id, this.sourceFunc);
            this.initialized = true;
            return method.invoke(this.cachedValue, args);
        }

        public String toString() {
            return String.format("[%s with id: %s]", this.type.getSimpleName(), this.id);
        }
    }

    @NotThreadSafe
    private static class CachingH<T>
    implements InvocationHandler {
        private final Class<T> type;
        private final Supplier<? extends T> sup;
        private boolean initialized;
        private T cachedValue;

        private CachingH(@Nonnull Class<T> type, @Nonnull Supplier<? extends T> sup) {
            this.type = type;
            this.sup = sup;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.initialized) {
                return method.invoke(this.cachedValue, args);
            }
            this.cachedValue = Preconditions.checkNotNull(this.sup.get(), (String)"[%s] is not provided by [%s]", this.type, this.sup);
            this.initialized = true;
            return method.invoke(this.cachedValue, args);
        }
    }
}

