/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import clover.com.google.common.collect.Lists;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.ei.model.DataSetList;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaVisibilityAreaService;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetListImporter {
    private static final Logger log = LoggerFactory.getLogger(DataSetListImporter.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final JpaDataSetListService dslService;
    private final JpaVisibilityAreaService vaService;
    private final DuplicateNameChecker duplicateNameChecker;
    private final EntityManagerController entityManagerController;

    public List<UUID> importDataSetLists(Path workDir, ExportImportData importData) throws IOException {
        log.info("start importDataSetLists(workDir: {})", (Object)workDir);
        ArrayList<UUID> dslImportedIds = new ArrayList<UUID>();
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        log.debug("importDataSetLists list: {}", (Object)list);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                try {
                    dslImportedIds.add(this.importDataSetList((UUID)id, (Path)list.get(id), importData));
                }
                catch (RuntimeException e) {
                    log.error("Cannot import dataset list {}", id, (Object)e);
                    throw e;
                }
            });
            this.entityManagerController.flushAndClear();
            log.info("Chunk with size {} completed. Total size {}.", (Object)chunk.size(), (Object)list.size());
        }
        log.info("end importDataSetLists(list: {})", (Object)list);
        return dslImportedIds;
    }

    private UUID importDataSetList(UUID id, Path path, ExportImportData importData) {
        DataSetList object;
        log.debug("importDataSetLists start import id: {}", (Object)id);
        if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
            HashMap map = new HashMap(importData.getReplacementMap());
            object = (DataSetList)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetList.class, map);
        } else {
            object = (DataSetList)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetList.class);
        }
        log.debug("Import object: {} in path: {}", (Object)object, (Object)path);
        if (object == null) {
            String message = String.format("Cannot load file by path %s", path.toString());
            log.error(message);
            throw new RuntimeException(message);
        }
        UUID vaId = object.getVisibilityArea();
        this.createVisibilityAreaIfAbsent(vaId);
        org.qubership.atp.dataset.service.jpa.delegates.DataSetList dataSetList = this.dslService.getById(object.getId());
        if (dataSetList == null) {
            object.setSourceId(id);
            this.createWithCheckName(object);
        } else {
            this.updateWithCheckName(dataSetList, object);
        }
        this.duplicateNameChecker.addToCache(object.getVisibilityArea(), object);
        return object.getId();
    }

    public List<UUID> getDslIds(Path workDir) {
        return new ArrayList<UUID>(this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class).keySet());
    }

    private void updateWithCheckName(org.qubership.atp.dataset.service.jpa.delegates.DataSetList dataSetList, DataSetList object) {
        this.checkAndCorrectName(object);
        dataSetList.setName(object.getName());
        dataSetList.setVisibilityArea(object.getVisibilityArea());
        log.debug("[ImportDataSetList][save] import object: {} datasetList: {} ", (Object)object, (Object)dataSetList);
        this.dslService.save(dataSetList);
    }

    private void createWithCheckName(DataSetList object) {
        this.checkAndCorrectName(object);
        try {
            this.dslService.replicate(object.getId(), object.getName(), object.getVisibilityArea(), object.getSourceId(), object.getCreatedBy(), object.getCreatedWhen(), object.getModifiedBy(), object.getModifiedWhen());
        }
        catch (DataSetServiceException e) {
            String message = String.format("Cannot create new data set list by import object %s", object);
            log.error(message);
            throw new ExportException(message, (Throwable)e);
        }
    }

    public void checkAndCorrectName(DataSetList object) {
        this.initCache(object.getVisibilityArea());
        this.duplicateNameChecker.checkAndCorrectName(object.getVisibilityArea(), object);
    }

    private boolean isNameUsed(DataSetList object, UUID visibilityAreaId) {
        this.initCache(visibilityAreaId);
        return this.duplicateNameChecker.isNameUsed(visibilityAreaId, object);
    }

    private void initCache(UUID visibilityAreaId) {
        if (!this.duplicateNameChecker.isInitialized(DataSetList.class, visibilityAreaId)) {
            HashMultimap initMap = HashMultimap.create();
            this.dslService.getByVisibilityAreaId(visibilityAreaId).forEach(arg_0 -> DataSetListImporter.lambda$initCache$1((Multimap)initMap, arg_0));
            this.duplicateNameChecker.init(DataSetList.class, visibilityAreaId, (Multimap<String, UUID>)initMap);
        }
    }

    private void createVisibilityAreaIfAbsent(UUID vaId) {
        try {
            VisibilityArea visibilityArea = this.vaService.getById(vaId);
            if (visibilityArea == null) {
                log.info("waitForCreatingOfVisibilityAreaOrCreateNewByTimeout visibilityArea: {}", (Object)visibilityArea);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
                this.vaService.replicate(vaId, "Exported VA " + simpleDateFormat.format(new Date()));
            }
        }
        catch (DataSetServiceException e) {
            String message = String.format("Cannot create Visibility Area %s", vaId);
            throw new ExportException(message, (Throwable)e);
        }
    }

    public List<String> validateDataSetLists(Path workDir, Map<UUID, UUID> repMap, boolean isInterProjectImport) {
        HashSet result = new HashSet();
        Map list = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        for (List chunk : Lists.partition(new ArrayList(list.keySet()), (int)1000)) {
            chunk.forEach(id -> this.validateDataSetLists((UUID)id, (Path)list.get(id), repMap, isInterProjectImport, result));
        }
        return new ArrayList<String>(result);
    }

    private void validateDataSetLists(UUID id, Path path, Map<UUID, UUID> repMap, boolean isInterProjectImport, Set<String> result) {
        log.debug("validateDataSetLists start import id: {}", (Object)id);
        DataSetList object = isInterProjectImport ? (DataSetList)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, DataSetList.class, repMap) : (DataSetList)this.objectLoaderFromDiskService.loadFileAsObject(path, DataSetList.class);
        log.debug("validate object: {}", (Object)object);
        if (object == null) {
            log.error("Cannot load file by path {}", (Object)path.toString());
            result.add("Some file cannot be loaded from import archive.");
            return;
        }
        if (this.isNameUsed(object, object.getVisibilityArea())) {
            result.add(String.format("Data Set List with name '%s' already exists in the project. Imported one will be renamed to '%s Copy'.", object.getName(), object.getName()));
        }
    }

    public void fillRepMapWithSourceTargetValues(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        for (List chunk : Lists.partition(new ArrayList(objectsToImport.keySet()), (int)1000)) {
            chunk.forEach(id -> {
                if (!replacementMap.containsKey(id)) {
                    DataSetList object = (DataSetList)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), DataSetList.class);
                    List<org.qubership.atp.dataset.service.jpa.delegates.DataSetList> existingObject = this.dslService.getBySourceIdAndVisibilityAreaId((UUID)id, (UUID)replacementMap.get(object.getVisibilityArea()));
                    if (CollectionUtils.isEmpty(existingObject)) {
                        replacementMap.put((UUID)id, (UUID)null);
                    } else {
                        replacementMap.put((UUID)id, existingObject.get(0).getId());
                    }
                }
            });
        }
    }

    public void clearDuplicateNamesCache() {
        this.duplicateNameChecker.clearCache();
    }

    public DataSetListImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, JpaDataSetListService dslService, JpaVisibilityAreaService vaService, DuplicateNameChecker duplicateNameChecker, EntityManagerController entityManagerController) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.dslService = dslService;
        this.vaService = vaService;
        this.duplicateNameChecker = duplicateNameChecker;
        this.entityManagerController = entityManagerController;
    }

    private static /* synthetic */ void lambda$initCache$1(Multimap initMap, org.qubership.atp.dataset.service.jpa.delegates.DataSetList entity) {
        initMap.put((Object)entity.getName(), (Object)entity.getId());
    }
}

