/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.service;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.qubership.atp.dataset.exception.attribute.AttributeExportException;
import org.qubership.atp.dataset.exception.attribute.AttributeImportException;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeTypeConverterEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSetListImportExportFactory {
    private static final Logger log = LoggerFactory.getLogger(DataSetListImportExportFactory.class);
    private final List<AttributeImportConverter> importConvertorsList;
    private final List<AttributeExportConverter> exportConvertorsList;
    private Map<Class<? extends AttributeImportConverter>, ? extends AttributeImportConverter> importConvertorsMap;
    private Map<Class<? extends AttributeExportConverter>, ? extends AttributeExportConverter> exportConvertorsMap;

    @PostConstruct
    private void initImportConverterMap() {
        this.importConvertorsMap = this.importConvertorsList.stream().collect(Collectors.toMap((Function<AttributeImportConverter, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/qubership/atp/dataset/service/direct/importexport/converters/AttributeImportConverter;)Ljava/lang/Class;)(), Function.identity()));
        this.exportConvertorsMap = this.exportConvertorsList.stream().collect(Collectors.toMap((Function<AttributeExportConverter, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/qubership/atp/dataset/service/direct/importexport/converters/AttributeExportConverter;)Ljava/lang/Class;)(), Function.identity()));
    }

    public AttributeImportConverter getAttributeImportConverter(String typeName) {
        Class<? extends AttributeImportConverter> importConverterClazz = AttributeTypeConverterEnum.getImportConverterClazzByName(typeName);
        AttributeImportConverter attributeImportConverter = this.importConvertorsMap.get(importConverterClazz);
        if (Objects.isNull(attributeImportConverter)) {
            log.error("Cannot found  attribute import convertor implementation by type name: " + typeName);
            throw new AttributeImportException();
        }
        return attributeImportConverter;
    }

    public AttributeExportConverter getAttributeExportConverter(String typeName) {
        Class<? extends AttributeExportConverter> exportConverterClazz = AttributeTypeConverterEnum.getExportConverterClazzByName(typeName);
        AttributeExportConverter attributeExportConverter = this.exportConvertorsMap.get(exportConverterClazz);
        if (Objects.isNull(attributeExportConverter)) {
            log.error("Cannot found Attribute export convertor implementation by type: " + typeName);
            throw new AttributeExportException();
        }
        return attributeExportConverter;
    }

    public DataSetListImportExportFactory(List<AttributeImportConverter> importConvertorsList, List<AttributeExportConverter> exportConvertorsList, Map<Class<? extends AttributeImportConverter>, ? extends AttributeImportConverter> importConvertorsMap, Map<Class<? extends AttributeExportConverter>, ? extends AttributeExportConverter> exportConvertorsMap) {
        this.importConvertorsList = importConvertorsList;
        this.exportConvertorsList = exportConvertorsList;
        this.importConvertorsMap = importConvertorsMap;
        this.exportConvertorsMap = exportConvertorsMap;
    }
}

