/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.service;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.EnumUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.qubership.atp.dataset.exception.excel.ExcelExportNotExistDatasetListlException;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeTypeConverterEnum;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasetListExportService {
    private static final Logger log = LoggerFactory.getLogger(DatasetListExportService.class);
    private static final String ATTRIBUTE_NAME_COLUMN = "Attribute";
    private static final String ATTRIBUTE_TYPE_COLUMN = "Type";
    private static final String EXCEL_EXT = ".xlsx";
    private static final String OUT_OF_SCOPE = "OOS";
    private static final int START_ROW_INDEX = 0;
    public static final String DEFAULT_PASSWORD_MASK = "********";
    public static final String REFERENCE_DELIMITER = "->";
    public static final int ATTRIBUTE_NAME_COLUMN_INDEX = 0;
    public static final int ATTRIBUTE_TYPE_COLUMN_INDEX = 1;
    public static final int SHIFT_PARAMETER_COLUMN_INDEX = 2;
    public static int nextRowIndex;
    private final DataSetListService dslService;
    private final DataSetListImportExportFactory factory;

    public File exportDataSetList(UUID datasetListId) {
        log.info("Start main process exporting Excel file, and start process building a tree DSL from the DB, datasetListId = '{}'", (Object)datasetListId);
        UiManDataSetList dslData = this.dslService.getAsTree(datasetListId, false);
        log.info("Finish process building a tree DSL from the DB");
        if (Objects.isNull(dslData)) {
            throw new ExcelExportNotExistDatasetListlException(datasetListId);
        }
        return this.convertDataToExcelFile(dslData);
    }

    /*
     * Exception decompiling
     */
    public File convertDataToExcelFile(UiManDataSetList dslData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void formExcelHeaderRow(SXSSFWorkbook workbook, SXSSFRow row, List<String> columns) {
        CellStyle headerStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        headerStyle.setFont(font);
        for (int i = 0; i < columns.size(); ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(columns.get(i));
            cell.setCellStyle(headerStyle);
        }
    }

    private SXSSFRow createNewRowAndSetAttrNameAndType(SXSSFSheet sheet, String attrName, String attrType) {
        SXSSFRow row = sheet.createRow(nextRowIndex++);
        row.createCell(0).setCellValue(attrName);
        row.createCell(1).setCellValue(attrType);
        return row;
    }

    public static String getAttributeType(UiManAttribute attribute) {
        String attrType = OUT_OF_SCOPE;
        String type = attribute.getType().getName();
        if (EnumUtils.isValidEnum(AttributeTypeConverterEnum.class, (String)type)) {
            attrType = AttributeTypeConverterEnum.valueOf(type).getName();
        }
        return attrType;
    }

    private void mapAttributeToRow(SXSSFSheet sheet, String attrName, String attrType, Set<UUID> datasetIds, UiManAttribute attribute) {
        if (!OUT_OF_SCOPE.equals(attrType)) {
            SXSSFRow row = this.createNewRowAndSetAttrNameAndType(sheet, attrName, attrType);
            AttributeExportConverter exportConverter = this.factory.getAttributeExportConverter(attrType);
            exportConverter.mapAttributeToRow(row, datasetIds, attribute);
        }
    }

    private void mapAttributeReferencesToRow(SXSSFSheet sheet, Set<UUID> datasetIds, UiManAttribute attribute, String attrName) {
        List<UiManAttribute> dslAttributesList = attribute.getAttributes();
        for (UiManAttribute attrItem : dslAttributesList) {
            String attrItemName = String.format("%s %s %s", attrName, REFERENCE_DELIMITER, attrItem.getName());
            String attrType = DatasetListExportService.getAttributeType(attrItem);
            this.mapAttributeToRow(sheet, attrItemName, attrType, datasetIds, attrItem);
            if (!AttributeTypeConverterEnum.DSL.getName().equals(attrType)) continue;
            this.mapAttributeReferencesToRow(sheet, datasetIds, attrItem, attrItemName);
        }
    }

    public DatasetListExportService(DataSetListService dslService, DataSetListImportExportFactory factory) {
        this.dslService = dslService;
        this.factory = factory;
    }

    private /* synthetic */ void lambda$convertDataToExcelFile$1(SXSSFSheet sheet, Map dataSetMap, UiManAttribute attrItem) {
        String attrName = attrItem.getName();
        String attrType = DatasetListExportService.getAttributeType(attrItem);
        this.mapAttributeToRow(sheet, attrName, attrType, dataSetMap.keySet(), attrItem);
        if (AttributeTypeConverterEnum.DSL.getName().equals(attrType)) {
            this.mapAttributeReferencesToRow(sheet, dataSetMap.keySet(), attrItem, attrName);
        }
    }

    private static /* synthetic */ void lambda$convertDataToExcelFile$0(Map dataSetMap, UiManDataSet dataSet) {
        dataSetMap.put(dataSet.getId(), dataSet.getName());
    }
}

