/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.LabelEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.db.jpa.entities.TestPlanEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.exception.file.FileDsCopyException;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundToCopyException;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.copy.AttributeCopyData;
import org.qubership.atp.dataset.service.jpa.model.copy.DataSetListCopyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class DataSetList
extends AbstractObjectWrapper<DataSetListEntity> {
    private static final Logger log = LoggerFactory.getLogger(DataSetList.class);

    public DataSetList(DataSetListEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((DataSetListEntity)this.entity).getId();
    }

    public String getName() {
        return ((DataSetListEntity)this.entity).getName();
    }

    public VisibilityArea getVisibilityArea() {
        return modelsProvider.getVisibilityArea(((DataSetListEntity)this.entity).getVisibilityArea());
    }

    public TestPlanEntity getTestPlan() {
        return ((DataSetListEntity)this.entity).getTestPlan();
    }

    public List<AttributeKey> getAttributeKeys() {
        LinkedList<AttributeKey> result = new LinkedList<AttributeKey>();
        String nativeQuery = "select * from attribute_key where datasetlist_id = :dsl_id";
        entityManager.createNativeQuery(nativeQuery, AttributeKeyEntity.class).setParameter("dsl_id", (Object)this.getId()).getResultList().forEach(o -> result.add(new AttributeKey((AttributeKeyEntity)o)));
        return result;
    }

    public List<Parameter> getOverLapParameters() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        String nativeQuery = "select p.* from attribute_key ak, parameter p where ak.datasetlist_id = :dsl_id and p.attribute_id = ak.id";
        entityManager.createNativeQuery(nativeQuery, ParameterEntity.class).setParameter("dsl_id", (Object)this.getId()).getResultList().forEach(o -> result.add(new Parameter((ParameterEntity)o)));
        return result;
    }

    public Map<AttributeKey, Parameter> getOverLapParametersMapping() {
        HashMap<AttributeKey, Parameter> result = new HashMap<AttributeKey, Parameter>();
        List<AttributeKey> attributeKeys = this.getAttributeKeys();
        List<Parameter> overLapParameters = this.getOverLapParameters();
        for (AttributeKey attributeKey : attributeKeys) {
            for (Parameter parameter : overLapParameters) {
                if (!parameter.getAttributeId().equals(attributeKey.getId())) continue;
                result.put(attributeKey, parameter);
            }
        }
        return result;
    }

    public List<AttributeKey> getAttributeKeysByDataSet(UUID dataSetId) {
        LinkedList<AttributeKey> result = new LinkedList<AttributeKey>();
        String nativeQuery = "select * from attribute_key where datasetlist_id = :dsl_id and dataset_id = :ds_id";
        entityManager.createNativeQuery(nativeQuery, AttributeKeyEntity.class).setParameter("dsl_id", (Object)this.getId()).setParameter("ds_id", (Object)dataSetId).getResultList().forEach(o -> result.add(new AttributeKey((AttributeKeyEntity)o)));
        return result;
    }

    public List<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        ((DataSetListEntity)this.entity).getAttributes().forEach(attributeEntity -> result.add(modelsProvider.getAttribute((AbstractUuidBasedEntity)attributeEntity)));
        return result;
    }

    public Integer getAttributesCount() {
        String nativeQuery = "select count(1) from attribute where datasetlist_id = :dsl_id";
        return ((BigInteger)entityManager.createNativeQuery(nativeQuery).setParameter("dsl_id", (Object)this.getId()).getSingleResult()).intValue();
    }

    public Attribute getAttributeById(UUID id) {
        String nativeQuery = "select * from attribute where datasetlist_id = :dsl_id and id = :attr_id";
        List resultList = entityManager.createNativeQuery(nativeQuery, AttributeEntity.class).setParameter("dsl_id", (Object)this.getId()).setParameter("attr_id", (Object)id).getResultList();
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        return modelsProvider.getAttribute((AbstractUuidBasedEntity)resultList.iterator().next());
    }

    public List<Integer> getDataSetsColumns(List<UUID> dataSetIds) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        String nativeQuery = "select num from (Select id, row_number() over(ORDER BY ordering) num from Dataset ds where ds.datasetlist_id = :list_id order by ordering) ds_ordered where id in (:ds_ids)";
        List queryResult = entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).setParameter("ds_ids", dataSetIds).getResultList();
        queryResult.forEach(bigInteger -> result.add(bigInteger.intValue() - 1));
        return result;
    }

    public Integer getDataSetColumnByName(String dataSetName) {
        String nativeQuery = "select num from (Select name, row_number() over(ORDER BY ordering) num from Dataset ds where ds.datasetlist_id = :list_id order by ordering) ds_ordered where name = :ds_name";
        return ((BigInteger)entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).setParameter("ds_name", (Object)dataSetName).getSingleResult()).intValue() - 1;
    }

    public Integer getDataSetColumnById(UUID dataSetId) {
        String nativeQuery = "select num from (Select id, row_number() over(ORDER BY ordering) num from Dataset ds where ds.datasetlist_id = :list_id order by ordering) ds_ordered where id = :ds_id";
        return ((BigInteger)entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).setParameter("ds_id", (Object)dataSetId).getSingleResult()).intValue() - 1;
    }

    public List<Integer> getDataSetColumnsByIds(List<UUID> dataSetIds) {
        String nativeQuery = "select num from (Select id, row_number() over(ORDER BY ordering) num from Dataset ds where ds.datasetlist_id = :list_id order by ordering) ds_ordered where id in :ds_ids";
        List untypedResult = entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).setParameter("ds_ids", dataSetIds).getResultList();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object o : untypedResult) {
            result.add(((BigInteger)o).intValue() - 1);
        }
        return result;
    }

    public List<DataSet> getDataSets() {
        LinkedList<DataSet> result = new LinkedList<DataSet>();
        for (DataSetEntity dataSet : ((DataSetListEntity)this.entity).getDataSets()) {
            result.add(modelsProvider.getDataSet(dataSet));
        }
        return result;
    }

    public DataSet getDataSetByColumn(int columnNumber) {
        String nativeQuery = "select * from (Select *, row_number() over(ORDER BY ordering) num from Dataset ds where ds.datasetlist_id = :list_id order by ordering) ds_ordered where num  = :row_num";
        DataSetEntity result = (DataSetEntity)entityManager.createNativeQuery(nativeQuery, DataSetEntity.class).setParameter("list_id", (Object)this.getId()).setParameter("row_num", (Object)(columnNumber + 1)).getSingleResult();
        return modelsProvider.getDataSet(result);
    }

    public DataSet getDataSetByName(String dataSetName) {
        String nativeQuery = "select * from dataSet where datasetlist_id = :dsl_id and name = :ds_name";
        DataSetEntity result = (DataSetEntity)entityManager.createNativeQuery(nativeQuery, DataSetEntity.class).setParameter("dsl_id", (Object)this.getId()).setParameter("ds_name", (Object)dataSetName).getSingleResult();
        return modelsProvider.getDataSet(result);
    }

    public DataSet getDataSetById(UUID dataSetId) {
        String nativeQuery = "select * from dataSet where datasetlist_id = :dsl_id and id = :ds_id";
        DataSetEntity result = (DataSetEntity)entityManager.createNativeQuery(nativeQuery, DataSetEntity.class).setParameter("dsl_id", (Object)this.getId()).setParameter("ds_id", (Object)dataSetId).getSingleResult();
        return modelsProvider.getDataSet(result);
    }

    public Integer getDataSetsCount() {
        String nativeQuery = "select count(1) from dataset where datasetlist_id = :list_id";
        return ((BigInteger)entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).getSingleResult()).intValue();
    }

    public List<LabelEntity> getLabels() {
        return ((DataSetListEntity)this.entity).getLabels();
    }

    public List<Attribute> getAttributesByTypes(List<AttributeTypeName> attributeTypeNames) {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        for (AttributeEntity attribute : ((DataSetListEntity)this.entity).getAttributes()) {
            AttributeTypeName type = AttributeTypeName.getTypeById(attribute.getAttributeTypeId());
            if (!attributeTypeNames.contains((Object)type)) continue;
            result.add(modelsProvider.getAttribute(attribute));
        }
        return result;
    }

    public Page<AttributeEntity> getAttributesByTypesPageable(UUID uuid, List<AttributeTypeName> attributeTypeNames, Pageable pageable) {
        return modelsProvider.getAttributesPageableByDslId(uuid, attributeTypeNames, pageable);
    }

    public List<Attribute> getAttributesOfPage(Page<AttributeEntity> entities, List<AttributeTypeName> attributeTypeNames) {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        for (AttributeEntity attribute : entities.toList()) {
            AttributeTypeName type = AttributeTypeName.getTypeById(attribute.getAttributeTypeId());
            if (!attributeTypeNames.contains((Object)type)) continue;
            result.add(modelsProvider.getAttribute(attribute));
        }
        return result;
    }

    public List<DataSetList> getDependencies() {
        List<Attribute> referenceAttributes = this.getAttributesByTypes(Collections.singletonList(AttributeTypeName.DSL));
        LinkedHashSet<UUID> dependedDataSetLists = new LinkedHashSet<UUID>();
        for (Attribute attribute : referenceAttributes) {
            UUID typeDataSetListId = attribute.getTypeDataSetListId();
            if (typeDataSetListId == null) continue;
            dependedDataSetLists.add(typeDataSetListId);
        }
        LinkedList<DataSetList> result = new LinkedList<DataSetList>();
        for (UUID dependedDataSetList : dependedDataSetLists) {
            result.add(modelsProvider.getDataSetListById(dependedDataSetList));
        }
        return result;
    }

    public void setDataSetListAttributes(List<AttributeEntity> entityList) {
        ((DataSetListEntity)this.entity).setAttributes(entityList);
    }

    public List<Attribute> getDataSetListReferences() {
        return this.getAttributesByTypes(Collections.singletonList(AttributeTypeName.DSL));
    }

    public DataSet createDataSet(String name) {
        return this.createDataSet(name, this.getLastDataSetsOrderNumber() + 1L);
    }

    public DataSet createDataSet(String name, long order) {
        DataSetEntity dataSetEntity = new DataSetEntity();
        dataSetEntity.setName(name);
        dataSetEntity.setDataSetList((DataSetListEntity)this.entity);
        dataSetEntity.setOrdering(order);
        this.save(dataSetEntity);
        return modelsProvider.getDataSet(dataSetEntity);
    }

    public DataSet insertDataSet(UUID id, String name) {
        DataSetEntity dataSetEntity = new DataSetEntity();
        dataSetEntity.setName(name);
        dataSetEntity.setDataSetList((DataSetListEntity)this.entity);
        dataSetEntity.setOrdering(this.getLastDataSetsOrderNumber() + 1L);
        this.insert(dataSetEntity, id);
        return modelsProvider.getDataSet(dataSetEntity);
    }

    @Override
    public void beforeRemove() {
        List<AttributeKey> attributeKeys = this.getAttributeKeys();
        for (AttributeKey attributeKey : attributeKeys) {
            attributeKey.remove();
        }
        List<DataSet> dataSets = this.getDataSets();
        for (DataSet dataSet : dataSets) {
            dataSet.remove();
        }
        List<Attribute> list = this.getAttributes();
        for (Attribute attribute : list) {
            attribute.remove();
        }
    }

    public Attribute createAttribute(String name, AttributeTypeName type) {
        return this.createAttribute(name, type, this.getLastAttributeOrderNumber() + 1);
    }

    public Attribute createAttribute(String name, AttributeTypeName type, Integer ordering) {
        AttributeEntity attributeEntity = new AttributeEntity();
        attributeEntity.setName(name);
        attributeEntity.setDataSetList((DataSetListEntity)this.entity);
        attributeEntity.setAttributeTypeId(type.getId());
        attributeEntity.setOrdering(ordering);
        this.save(attributeEntity);
        ((DataSetListEntity)this.entity).getAttributes().add(attributeEntity);
        log.debug("createAttribute() - new attributeEntity id: {}, name: {}", (Object)attributeEntity.getId(), (Object)name);
        return modelsProvider.getAttribute(attributeEntity);
    }

    public Attribute insertAttribute(UUID id, String name, AttributeTypeName type, int ordering) {
        AttributeEntity attributeEntity = new AttributeEntity();
        attributeEntity.setId(id);
        attributeEntity.setName(name);
        attributeEntity.setDataSetList((DataSetListEntity)this.entity);
        attributeEntity.setAttributeTypeId(type.getId());
        attributeEntity.setOrdering(ordering);
        this.insert(attributeEntity, id);
        ((DataSetListEntity)this.entity).getAttributes().add(attributeEntity);
        return modelsProvider.getAttribute(attributeEntity);
    }

    public int getLastAttributeOrderNumber() {
        String nativeQuery = "select COALESCE(max(ordering), 1) max_order_number  from attribute  where datasetlist_id = :list_id";
        return (Integer)entityManager.createNativeQuery(nativeQuery).setParameter("list_id", (Object)this.getId()).getSingleResult();
    }

    public long getLastDataSetsOrderNumber() {
        String nativeQuery = "select max(ordering) max_order_number from dataset where datasetlist_id = ?";
        BigInteger result = (BigInteger)entityManager.createNativeQuery(nativeQuery).setParameter(1, (Object)this.getId()).getSingleResult();
        return result != null ? result.longValue() : 0L;
    }

    public void setName(String name) {
        ((DataSetListEntity)this.entity).setName(name);
    }

    public void setVisibilityArea(UUID visibilityAreaId) {
        VisibilityArea visibilityArea = modelsProvider.getVisibilityAreaById(visibilityAreaId);
        if (visibilityArea == null) {
            throw new Error("Can't find Visibility Area by id " + visibilityAreaId);
        }
        ((DataSetListEntity)this.entity).setVisibilityArea((VisibilityAreaEntity)visibilityArea.getEntity());
    }

    public DataSetListCopyData duplicate(@Nullable String postfix, String prevNamePattern, @Nullable UUID sagaSessionId) {
        String copyPostfix = StringUtils.isEmpty((String)postfix) ? "Copy" : postfix;
        String copyName = this.getNextCopyName(copyPostfix, prevNamePattern);
        return this.copy(((DataSetListEntity)this.entity).getVisibilityArea(), copyName, sagaSessionId);
    }

    private DataSetListCopyData copy(VisibilityAreaEntity visibilityArea, String name, @Nullable UUID sagaSessionId) {
        DataSetListEntity dataSetListCopy = new DataSetListEntity();
        Timestamp dslCopyTime = Timestamp.from(Instant.now());
        dataSetListCopy.setVisibilityArea(visibilityArea);
        dataSetListCopy.setName(name);
        dataSetListCopy.setCreatedWhen(dslCopyTime);
        dataSetListCopy.setModifiedWhen(dslCopyTime);
        dataSetListCopy.setSagaSessionId(sagaSessionId);
        this.save(dataSetListCopy);
        DataSetList dataSetList = modelsProvider.getDataSetList(dataSetListCopy);
        DataSetListCopyData dataSetListCopyData = new DataSetListCopyData(dataSetList);
        Map<UUID, AttributeCopyData> attributesMap = this.copyAttributesTo(dataSetList);
        dataSetListCopyData.setAttributesMap(attributesMap);
        Map<UUID, UUID> dataSetsMap = this.copyDataSetsTo(dataSetList, attributesMap);
        dataSetListCopyData.setDataSetsMap(dataSetsMap);
        this.copyOverlapsToListNoPathUpdate(dataSetListCopyData);
        return dataSetListCopyData;
    }

    private void copyOverlapsToListNoPathUpdate(DataSetListCopyData dataSetListCopyData) {
        DataSetList dataSetListCopy = dataSetListCopyData.getDataSetListCopy();
        log.info("Start copy overlaps keys for Dataset List with id {} and name {}", (Object)dataSetListCopy.getId(), (Object)dataSetListCopy.getName());
        Map<UUID, UUID> dataSetsMap = dataSetListCopyData.getDataSetsMap();
        Map<UUID, AttributeCopyData> attributesMap = dataSetListCopyData.getAttributesMap();
        for (AttributeKey attributeKey : this.getAttributeKeys()) {
            AttributeCopyData attributeCopyData = attributesMap.get(attributeKey.getAttribute().getId());
            Attribute newAttribute = attributeCopyData != null ? attributeCopyData.getAttributeCopy() : attributeKey.getAttribute();
            List<UUID> path = attributeKey.getPath();
            UUID newDataSetId = dataSetsMap.get(attributeKey.getDataSet().getId());
            DataSet newDataSet = modelsProvider.getDataSetById(newDataSetId);
            Parameter newOverlap = newDataSet.createOverlap(newAttribute.getId(), path);
            log.debug("CreateOverlap - newAttributeId: {},  oldAttributeKey: {}, newAttributeKey: {}", new Object[]{newAttribute.getId(), attributeKey.getId(), newOverlap.getAttributeKey().getId()});
            Parameter oldOverlap = attributeKey.getParameter();
            switch (newAttribute.getAttributeType()) {
                case CHANGE: 
                case ENCRYPTED: 
                case TEXT: {
                    newOverlap.setStringValue(oldOverlap.getStringValue());
                    break;
                }
                case LIST: {
                    if (oldOverlap == null || oldOverlap.getListValue() == null) break;
                    newOverlap.setListValueId(oldOverlap.getListValue().getId());
                    break;
                }
                case FILE: {
                    try {
                        gridFsService.copy(oldOverlap.getId(), newOverlap.getId(), true);
                    }
                    catch (IllegalStateException | FileDsCopyException | FileDsNotFoundToCopyException e) {
                        log.error("File " + oldOverlap.getId() + " not found. Continue copying.", (Throwable)e);
                    }
                    break;
                }
                case DSL: {
                    UUID originalDataSetReference = oldOverlap.getDataSetReferenceId();
                    UUID newDataSetReferenceId = dataSetsMap.get(originalDataSetReference);
                    if (newDataSetReferenceId != null) {
                        newOverlap.setDataSetReferenceId(newDataSetReferenceId);
                        break;
                    }
                    newOverlap.setDataSetReferenceId(originalDataSetReference);
                    break;
                }
            }
        }
        log.info("Finish copy overlaps keys for Dataset List with id {} and name {}", (Object)dataSetListCopy.getId(), (Object)dataSetListCopy.getName());
    }

    private List<UUID> getUpdatedPath(List<UUID> oldPath, Map<UUID, AttributeCopyData> attributesMap) {
        LinkedList<UUID> newPath = new LinkedList<UUID>();
        boolean chainBroken = false;
        for (UUID oldPathStep : oldPath) {
            if (chainBroken) {
                newPath.add(oldPathStep);
                continue;
            }
            AttributeCopyData attributeCopyData = attributesMap.get(oldPathStep);
            if (attributeCopyData != null) {
                newPath.add(attributeCopyData.getCopyId());
                continue;
            }
            chainBroken = true;
            newPath.add(oldPathStep);
        }
        return newPath;
    }

    private Map<UUID, AttributeCopyData> copyAttributesTo(DataSetList anotherDataSetList) {
        LinkedHashMap<UUID, AttributeCopyData> originalToCopy = new LinkedHashMap<UUID, AttributeCopyData>();
        for (Attribute attribute : this.getAttributes()) {
            Attribute copyAttribute = anotherDataSetList.createAttribute(attribute.getName(), attribute.getAttributeType(), attribute.getOrdering());
            copyAttribute.setTypeDataSetListId(attribute.getTypeDataSetListId());
            copyAttribute.setOrdering(attribute.getOrdering());
            Map<UUID, UUID> listValuesMap = attribute.copyListValuesTo(copyAttribute);
            originalToCopy.put(attribute.getId(), new AttributeCopyData(copyAttribute, listValuesMap));
        }
        log.debug("copyAttributesTo() - " + originalToCopy.entrySet());
        return originalToCopy;
    }

    private Map<UUID, UUID> copyDataSetsTo(DataSetList anotherDataSetList, Map<UUID, AttributeCopyData> attributesMap) {
        LinkedHashMap<UUID, UUID> dataSetMap = new LinkedHashMap<UUID, UUID>();
        List<DataSet> dataSets = this.getDataSets();
        for (DataSet dataSet : dataSets) {
            DataSet copyDataSet = anotherDataSetList.createDataSet(dataSet.getName(), ((DataSetEntity)dataSet.getEntity()).getOrdering());
            dataSet.copyParametersTo(copyDataSet, attributesMap);
            dataSetMap.put(dataSet.getId(), copyDataSet.getId());
        }
        return dataSetMap;
    }

    private String getNextCopyName(String postfix, String prevNamePattern) {
        HashSet<String> dataSetListNames = new HashSet<String>(this.getVisibilityArea().getDataSetListsNames());
        String name = this.getName();
        String newName = !StringUtils.isEmpty((String)prevNamePattern) && name.contains(prevNamePattern) ? name.replaceAll(prevNamePattern, postfix) : String.format("%s %s", name, postfix);
        while (dataSetListNames.contains(newName)) {
            newName = String.format("%s %s", newName, "Copy");
        }
        return newName;
    }

    public void updateDslReferences(Map<UUID, DataSetListCopyData> copiesData, Map<UUID, UUID> dataSetsMap) {
        long startTime = System.currentTimeMillis();
        List<Attribute> referencedAttributes = this.getAttributesByTypes(Collections.singletonList(AttributeTypeName.DSL));
        for (Attribute referencedAttribute : referencedAttributes) {
            DataSetListCopyData copyData = copiesData.get(referencedAttribute.getTypeDataSetListId());
            if (copyData == null) continue;
            referencedAttribute.setTypeDataSetListId(copyData.getCopyId());
            for (Parameter referencedParameter : referencedAttribute.getParameters()) {
                UUID newId = dataSetsMap.get(referencedParameter.getDataSetReferenceId());
                referencedParameter.setDataSetReferenceId(newId);
            }
        }
        long duration = (System.currentTimeMillis() - startTime) / 1000L;
        log.debug("UpdateDslReferences, time sec: {}", (Object)duration);
    }

    public void updateOverlaps(Map<UUID, DataSetListCopyData> copiesData) {
        LinkedHashMap<UUID, AttributeCopyData> allAttributesMap = new LinkedHashMap<UUID, AttributeCopyData>();
        LinkedHashMap<UUID, UUID> allDataSetsMap = new LinkedHashMap<UUID, UUID>();
        long startTime = System.currentTimeMillis();
        try {
            for (DataSetListCopyData values : copiesData.values()) {
                allAttributesMap.putAll(values.getAttributesMap());
                allDataSetsMap.putAll(values.getDataSetsMap());
            }
            List<AttributeKey> attributeKeys = this.getAttributeKeys();
            int count = 0;
            for (AttributeKey attributeKey : attributeKeys) {
                UUID dataSetReferenceId;
                UUID newReferencedDataset;
                Parameter parameter;
                AttributeCopyData attributeCopyData;
                UUID lastNew;
                List<UUID> oldPath = attributeKey.getPath();
                List<UUID> newPath = this.getUpdatedPath(oldPath, allAttributesMap);
                attributeKey.setKey(StringUtils.join(newPath, (String)"_"));
                UUID lastOld = oldPath.get(oldPath.size() - 1);
                if (lastOld == (lastNew = newPath.get(newPath.size() - 1)) || (attributeCopyData = (AttributeCopyData)allAttributesMap.get(attributeKey.getAttribute().getId())) == null) continue;
                ++count;
                attributeKey.setAttribute(attributeCopyData.getCopyId());
                if (!attributeKey.getAttributeType().equals((Object)AttributeTypeName.DSL) || (parameter = attributeKey.getParameter()) == null || (newReferencedDataset = (UUID)allDataSetsMap.get(dataSetReferenceId = parameter.getDataSetReferenceId())) == null) continue;
                parameter.setDataSetReferenceId(newReferencedDataset);
            }
            long duration = (System.currentTimeMillis() - startTime) / 1000L;
            log.info("finish update overlaps - getAttributeKeys() - dsl_id: {}, attributeKeys.size(): {}, total count attrKey: {}, time sec: {}", new Object[]{this.getId(), attributeKeys.size(), count, duration});
        }
        catch (Throwable e) {
            log.error("Update overlaps - dsl_id: {}", (Object)this.getId(), (Object)e);
        }
    }

    public void setModifiedBy(UUID id) {
        ((DataSetListEntity)this.entity).setModifiedBy(id);
        this.save(this.entity);
    }

    public void setModifiedWhen(Timestamp timestamp) {
        ((DataSetListEntity)this.entity).setModifiedWhen(timestamp);
        this.save(this.entity);
    }

    public Parameter insertOverlap(UUID dataSetId, UUID attributeKeyId, UUID attributeId, List<UUID> path, UUID parameterId) {
        DataSet dataSet = this.getDataSetById(dataSetId);
        AttributeKeyEntity attributeKeyEntity = new AttributeKeyEntity();
        attributeKeyEntity.setDataSetList((DataSetListEntity)this.entity);
        attributeKeyEntity.setDataSet((DataSetEntity)dataSet.getEntity());
        attributeKeyEntity.setAttribute((AttributeEntity)modelsProvider.getAttributeById(attributeId).getEntity());
        attributeKeyEntity.setKey(StringUtils.join(path, (String)"_"));
        this.insert(attributeKeyEntity, attributeKeyId);
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setId(parameterId);
        parameterEntity.setAttribute(attributeKeyEntity);
        parameterEntity.setDataSet((DataSetEntity)dataSet.getEntity());
        this.insert(parameterEntity, parameterId);
        return modelsProvider.getParameter(parameterEntity);
    }

    public Timestamp getModifiedWhen() {
        return ((DataSetListEntity)this.entity).getModifiedWhen();
    }

    public UUID getSagaSessionId() {
        return ((DataSetListEntity)this.entity).getSagaSessionId();
    }
}

