/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaListValueRepository;
import org.qubership.atp.dataset.ei.model.AttributeKeyIdsDbUpdate;
import org.qubership.atp.dataset.exception.attribute.AttributeExistsException;
import org.qubership.atp.dataset.exception.attribute.AttributeNotFoundException;
import org.qubership.atp.dataset.exception.attribute.AttributePositionException;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListCheckService;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaAttributeServiceImpl
implements JpaAttributeService {
    private static final Logger log = LoggerFactory.getLogger(JpaAttributeServiceImpl.class);
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected JpaListValueRepository listValueRepository;
    @Autowired
    protected DataSetListCheckService checkService;
    @Autowired
    protected DataSetListSnapshotService dataSetListSnapshotService;
    @Autowired
    protected DateAuditorService dateAuditorService;
    private final Map<UUID, AttributeKeyIdsDbUpdate> foundedAttributeKeyIdAndDatasetIdUpdate = new HashMap<UUID, AttributeKeyIdsDbUpdate>();

    @Override
    @Transactional
    public Attribute create(String name, AttributeTypeName type, UUID dataSetListId) {
        Attribute attribute = this.createWithoutCommitting(name, type, dataSetListId);
        this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        return attribute;
    }

    @Override
    @Transactional(rollbackFor={AttributeExistsException.class})
    @CacheEvict(value={"ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE_OS"}, key="#dataSetListId")
    public Attribute create(String name, AttributeTypeName type, UUID dataSetListId, UUID typeDataSetListId, List<String> listValues) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        for (Attribute attribute : dataSetList.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            log.error("Attribute with name '" + name + "' already exists");
            throw new AttributeExistsException(name);
        }
        Attribute attribute = dataSetList.createAttribute(name, type);
        if (type == AttributeTypeName.CHANGE) {
            attribute.setTypeDataSetListId(typeDataSetListId);
        }
        if (type == AttributeTypeName.DSL) {
            attribute.setTypeDataSetListId(typeDataSetListId);
            this.checkService.checkOnCyclesThrowException(dataSetList);
        }
        if (type == AttributeTypeName.LIST) {
            for (String listValue : listValues) {
                attribute.createListValue(listValue);
            }
        }
        this.dateAuditorService.updateModifiedFields(dataSetListId);
        this.dataSetListSnapshotService.commitEntity(dataSetListId);
        return attribute;
    }

    @Override
    @Transactional
    public Attribute createWithoutCommitting(String name, AttributeTypeName type, UUID dataSetListId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        Attribute attribute = dataSetList.createAttribute(name, type);
        return attribute;
    }

    @Override
    @Transactional
    public ListValue createListValueWithoutCommitting(String text, UUID attributeId) {
        return this.modelsProvider.getAttributeById(attributeId).createListValue(text);
    }

    @Override
    @Transactional
    public Attribute replicate(UUID id, String name, AttributeTypeName type, UUID dataSetListId, UUID sourceId) throws DataSetServiceException {
        return this.modelsProvider.replicateAttribute(id, name, type, dataSetListId, sourceId);
    }

    @Override
    @Transactional
    public void remove(UUID id) {
        Attribute attribute = this.modelsProvider.getAttributeById(id);
        if (attribute != null) {
            attribute.remove();
        }
    }

    @Override
    @Transactional
    public void save(AbstractObjectWrapper attribute) {
        attribute.save();
    }

    @Override
    @Transactional
    public void removeAttributeKey(UUID id) {
        AttributeKey attributeKey = this.modelsProvider.getAttributeKeyById(id);
        if (attributeKey != null) {
            attributeKey.remove();
        }
    }

    @Override
    @Transactional
    public AttributeKey replicateAttributeKey(UUID id, String key, UUID attribute, UUID dataSet, UUID dataSetList, UUID sourceId) throws DataSetServiceException {
        return this.modelsProvider.replicateAttributeKey(id, key, attribute, dataSet, dataSetList, sourceId);
    }

    @Override
    public Attribute getById(UUID id) {
        return this.modelsProvider.getAttributeById(id);
    }

    @Override
    public AttributeKey getAttributeKeyById(UUID id) {
        return this.modelsProvider.getAttributeKeyById(id);
    }

    @Override
    public List<AttributeKey> getAttributeKeysByDatasetListId(UUID datasetListId) {
        return this.modelsProvider.getByDataSetListId(datasetListId);
    }

    @Override
    public void removeListValuesByAttributeId(UUID id) {
        List<ListValueEntity> lists = this.listValueRepository.getByAttributeId(id);
        this.listValueRepository.deleteAll(lists);
    }

    @Override
    @Transactional
    public ListValue getListValueById(UUID id) {
        Optional value = this.listValueRepository.findById(id);
        return value.map(listValueEntity -> this.modelsProvider.getListValue((AbstractUuidBasedEntity)listValueEntity)).orElse(null);
    }

    @Override
    public ListValue getListValueByAttributeIdAndValue(UUID attributeId, String value) {
        return this.modelsProvider.getByAttributeIdAndText(attributeId, value);
    }

    @Override
    public List<ListValue> getListValuesByAttributeId(UUID attributeId) {
        return this.modelsProvider.getListValuesByAttributeId(attributeId);
    }

    @Override
    public List<Attribute> getByNameAndDataSetListId(String name, UUID dataSetListId) {
        return this.modelsProvider.getAttributeByNameAndDataSetListId(name, dataSetListId);
    }

    @Override
    public List<Attribute> getByDataSetListId(UUID dataSetListId) {
        return this.modelsProvider.getAttributeByDataSetListId(dataSetListId);
    }

    @Override
    public List<Attribute> getByDataSetListIdIn(Collection<UUID> dataSetListIds) {
        return this.modelsProvider.getAttributesByDataSetListIdIn(dataSetListIds);
    }

    @Override
    public List<Attribute> getBySourceIdAndDataSetListId(UUID sourceId, UUID dataSetListId) {
        return this.modelsProvider.getAttributeBySourceAndDataSetListId(sourceId, dataSetListId);
    }

    @Override
    public List<AttributeKey> getAttrKeyBySourceIdAndDataSetListId(UUID sourceId, UUID dataSetListId) {
        return this.modelsProvider.getAttributeKeyBySourceAndDataSetListId(sourceId, dataSetListId);
    }

    @Override
    public AttributeKey getAttributeKeyByKeyAndDataSetListIdAndDataSetIdAndAttributeId(String key, UUID dataSetListId, UUID datasetId, UUID attributeId) {
        return this.modelsProvider.getAttributeKeyByKeyAndDataSetListIdAndDataSetIdAndAttributeId(key, dataSetListId, datasetId, attributeId);
    }

    @Override
    public List<ListValue> getListValueBySourceIdAndAttrId(UUID sourceId, UUID attributeId) {
        return this.modelsProvider.getListValueBySourceIdAndAttrId(sourceId, attributeId);
    }

    @Override
    @Transactional
    public void setPosition(UUID attributeId, Integer position) {
        if (position == null || position < 0) {
            log.error("Attribute '" + attributeId + "' position can't be null or negative");
            throw new AttributePositionException();
        }
        Attribute attributeToMove = this.modelsProvider.getAttributeById(attributeId);
        if (attributeToMove == null) {
            log.error("Attribute '" + attributeId + "' not found");
            throw new AttributeNotFoundException();
        }
        DataSetList dataSetList = attributeToMove.getDataSetList();
        List<Attribute> attributes = dataSetList.getAttributes();
        if (position > attributes.size() - 1) {
            log.error("Position out of range [0-" + (attributes.size() - 1) + "]");
            throw new AttributePositionException();
        }
        attributes.remove(attributeToMove);
        attributes.add(position, attributeToMove);
        int orderCounter = 0;
        for (Attribute attribute : attributes) {
            attribute.setOrdering(orderCounter);
            ++orderCounter;
        }
    }

    @Override
    @Transactional
    public ListValue createListValue(String text, UUID attributeId) {
        Attribute attribute = this.modelsProvider.getAttributeById(attributeId);
        ListValue listValue = attribute.createListValue(text);
        this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        return listValue;
    }

    @Override
    @Transactional
    public ListValue replicateListValue(UUID id, String text, UUID attributeId, UUID sourceId) throws DataSetServiceException {
        return this.modelsProvider.replicateListValue(id, text, attributeId, sourceId);
    }

    @Override
    @Transactional
    public void setReferencedDataSetList(UUID attributeId, UUID dataSetListId) {
        Attribute attribute = this.modelsProvider.getAttributeById(attributeId);
        attribute.setTypeDataSetListId(dataSetListId);
    }

    @Override
    public Map<UUID, AttributeKeyIdsDbUpdate> getFoundedAttributeKeyIdAndDatasetIdUpdate() {
        return this.foundedAttributeKeyIdAndDatasetIdUpdate;
    }

    @Override
    @Nullable
    public UUID mergeListValuesAndGetListValueReference(UUID sourceAttrId, UUID targetAttrId, @Nullable ListValueEntity sourceListValue) {
        log.debug("mergeListValuesAndGetListValueReference (sourceAttrId: {}, targetAttrId: {}, sourceListValue: {})", new Object[]{sourceAttrId, targetAttrId, sourceListValue});
        this.mergeListValues(sourceAttrId, targetAttrId);
        if (Objects.nonNull(sourceListValue)) {
            return this.getListValueByAttributeIdAndValue(targetAttrId, sourceListValue.getText()).getId();
        }
        return null;
    }

    @Override
    @Transactional
    public void mergeListValues(UUID sourceAttributeId, UUID targetAttributeId) {
        log.debug("mergeListValues (sourceAttrId: {}, targetAttrId: {})", (Object)sourceAttributeId, (Object)targetAttributeId);
        List<ListValue> sourceValues = this.getListValuesByAttributeId(sourceAttributeId);
        Map targetValues = this.getListValuesByAttributeId(targetAttributeId).stream().collect(Collectors.toMap(ListValue::getText, Function.identity()));
        for (ListValue sourceValue : sourceValues) {
            if (targetValues.containsKey(sourceValue.getText())) continue;
            log.info("Add new value \"{}\" to attribute (id: {})", (Object)sourceValue.getText(), (Object)targetAttributeId);
            this.createListValueWithoutCommitting(sourceValue.getText(), targetAttributeId);
        }
    }
}

