/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dsllazyload.dsl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class ParameterFlat {
    @JsonIgnore
    private UUID id;
    private UUID dataSet;
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String valueRef;
    private boolean overlap = false;
    @JsonIgnore
    private DataSetParameterProvider parameterProvider;
    @JsonIgnore
    private AttributeTypeName attributeType;
    @JsonIgnore
    private ParameterPositionContext positionContext;

    public ParameterFlat(Attribute attribute, Parameter parameter, int column, DataSetParameterProvider parameterProvider) {
        this.id = parameter.getId();
        this.dataSet = parameter.getDataSet().getId();
        this.attributeType = attribute.getAttributeType();
        if (this.attributeType == AttributeTypeName.DSL) {
            UUID dataSetReferenceId = parameter.getDataSetReferenceId();
            this.valueRef = dataSetReferenceId == null ? null : parameter.getDataSetReferenceId().toString();
            this.dataSet = parameter.getDataSetId();
        }
        this.value = parameter.getParameterValueByType();
        this.parameterProvider = parameterProvider;
        this.positionContext = new ParameterPositionContext(Collections.emptyList(), column, this.dataSet, attribute.getOrdering().longValue(), attribute.getId());
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getValue() {
        if (this.attributeType != AttributeTypeName.DSL) {
            AbstractParameter dataSetParameterResolved = this.parameterProvider.getDataSetParameterResolved(null, this.id, this.attributeType, false, null, this.positionContext);
            this.value = dataSetParameterResolved.getValue();
        }
        return this.value;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getDataSet() {
        return this.dataSet;
    }

    public String getValueRef() {
        return this.valueRef;
    }

    public boolean isOverlap() {
        return this.overlap;
    }

    public DataSetParameterProvider getParameterProvider() {
        return this.parameterProvider;
    }

    public AttributeTypeName getAttributeType() {
        return this.attributeType;
    }

    public ParameterPositionContext getPositionContext() {
        return this.positionContext;
    }

    @JsonIgnore
    public void setId(UUID id) {
        this.id = id;
    }

    public void setDataSet(UUID dataSet) {
        this.dataSet = dataSet;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueRef(String valueRef) {
        this.valueRef = valueRef;
    }

    public void setOverlap(boolean overlap) {
        this.overlap = overlap;
    }

    @JsonIgnore
    public void setParameterProvider(DataSetParameterProvider parameterProvider) {
        this.parameterProvider = parameterProvider;
    }

    @JsonIgnore
    public void setAttributeType(AttributeTypeName attributeType) {
        this.attributeType = attributeType;
    }

    @JsonIgnore
    public void setPositionContext(ParameterPositionContext positionContext) {
        this.positionContext = positionContext;
    }
}

