/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import org.qubership.atp.dataset.db.DBConfig;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersionController {
    private DBConfig dbConfig;

    @Autowired
    public VersionController(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/version"})
    @AuditAction(auditAction="Get current version")
    @Operation(summary="gets current version")
    public String version() {
        String serviceVersion = this.getClass().getPackage().getImplementationVersion();
        String infoString = "DataSet Version: " + (serviceVersion == null ? "UNKNOWN" : serviceVersion) + "\n";
        String dbInfo = this.dbConfig.getDriverClassName();
        infoString = infoString + "DB Info: " + dbInfo;
        return infoString;
    }
}

