/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.UUID;
import joptsimple.internal.Strings;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;

@Value
public class ParameterUiModel {
    private UUID dataSet;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object valueRef;
    private boolean isOverlap;

    public ParameterUiModel(ParameterSnapshot snapShot, ModelsProvider modelsProvider, boolean isOverlap) {
        this.dataSet = snapShot.getDataSetId();
        if (!Strings.isNullOrEmpty((String)snapShot.getText())) {
            this.value = snapShot.getValuePretty(modelsProvider);
        } else if (snapShot.getListValueId() != null) {
            this.value = snapShot.getListValueName();
        } else if (snapShot.getFileData() != null) {
            this.value = snapShot.getFileData().getFileName();
        }
        if (snapShot.getDataSetReference() != null) {
            this.valueRef = snapShot.getDataSetReference();
        }
        this.isOverlap = isOverlap;
    }

    public UUID getDataSet() {
        return this.dataSet;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueRef() {
        return this.valueRef;
    }

    public boolean isOverlap() {
        return this.isOverlap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterUiModel)) {
            return false;
        }
        ParameterUiModel other = (ParameterUiModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOverlap() != other.isOverlap()) {
            return false;
        }
        UUID this$dataSet = this.getDataSet();
        UUID other$dataSet = other.getDataSet();
        if (this$dataSet == null ? other$dataSet != null : !((Object)this$dataSet).equals(other$dataSet)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Object this$valueRef = this.getValueRef();
        Object other$valueRef = other.getValueRef();
        return !(this$valueRef == null ? other$valueRef != null : !this$valueRef.equals(other$valueRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterUiModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverlap() ? 79 : 97);
        UUID $dataSet = this.getDataSet();
        result = result * 59 + ($dataSet == null ? 43 : ((Object)$dataSet).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Object $valueRef = this.getValueRef();
        result = result * 59 + ($valueRef == null ? 43 : $valueRef.hashCode());
        return result;
    }

    public String toString() {
        return "ParameterUiModel(dataSet=" + this.getDataSet() + ", value=" + this.getValue() + ", valueRef=" + this.getValueRef() + ", isOverlap=" + this.isOverlap() + ")";
    }
}

