/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class AttributeRepositoryTest
extends AbstractTest {
    private static final long DEFAULT_TIME_FOR_CREATE_ATTR = 1576741274989L;
    private static final long DEFAULT_TIME_FOR_UPDATE_ATTR = 1576741383850L;
    private Attribute attribute1;
    private Attribute attribute2;
    private Attribute attribute3;
    private VisibilityArea visibilityArea;
    private DataSetList testDsl;
    @Autowired
    private AttributeRepository repo;

    @BeforeEach
    public void setUp() {
        this.visibilityArea = this.visibilityAreaService.create("TestVA");
        this.testDsl = this.dataSetListService.create(this.visibilityArea.getId(), "TestDsl", null);
        DataSet dataSet = this.dataSetService.create(this.testDsl.getId(), "ds1");
        this.attribute1 = this.attributeService.create(this.testDsl.getId(), Integer.valueOf(1576741244), "TestAttr1", AttributeType.TEXT, null, null);
        this.attribute2 = this.attributeService.create(this.testDsl.getId(), Integer.valueOf(1576741254), "TestAttr2", AttributeType.TEXT, null, null);
        this.attribute3 = this.attributeService.create(this.testDsl.getId(), Integer.valueOf(1576741264), "TestAttr3", AttributeType.TEXT, null, null);
        Parameter parameter1 = this.parameterService.create(dataSet.getId(), this.attribute1.getId(), "1", null, null);
        Parameter parameter2 = this.parameterService.create(dataSet.getId(), this.attribute2.getId(), "2", null, null);
        Parameter parameter = this.parameterService.create(dataSet.getId(), this.attribute3.getId(), "3", null, null);
    }

    @Test
    public void updateOrdering_ShouldBeValid() {
        List<Pair<UUID, Integer>> attributesOrdering = this.generatePairs();
        List attributesBefore = this.dataSetListService.getAsTree(this.testDsl.getId(), false).getAttributes();
        this.repo.updateOrdering(attributesOrdering);
        List attributesAfter = this.dataSetListService.getAsTree(this.testDsl.getId(), false).getAttributes();
        Assertions.assertNotEquals((Object)attributesBefore, (Object)attributesAfter, (String)"The new ordering is different from the old");
        Assertions.assertEquals((Object)this.attribute1.getId(), (Object)((UiManAttribute)attributesAfter.get(2)).getId(), (String)"Third element of new list of attr-s is TestAttr1");
        Assertions.assertEquals((Object)this.attribute3.getId(), (Object)((UiManAttribute)attributesAfter.get(1)).getId(), (String)"Second element of new list of attr-s is TestAttr3");
        Assertions.assertEquals((Object)this.attribute2.getId(), (Object)((UiManAttribute)attributesAfter.get(0)).getId(), (String)"First element of new list of attr-s is TestAttr2");
    }

    private List<Pair<UUID, Integer>> generatePairs() {
        Pair pair1 = new Pair();
        pair1.setFirst((Object)this.attribute1.getId());
        pair1.setSecond((Object)1576741413);
        Pair pair2 = new Pair();
        pair2.setFirst((Object)this.attribute2.getId());
        pair2.setSecond((Object)1576741393);
        Pair pair3 = new Pair();
        pair3.setFirst((Object)this.attribute3.getId());
        pair3.setSecond((Object)1576741403);
        return Arrays.asList(pair1, pair2, pair3);
    }

    @After
    public void tearDown() throws Exception {
        this.visibilityAreaService.delete(this.visibilityArea.getId());
    }
}

