/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.ei.model.DataSet;
import org.qubership.atp.dataset.ei.model.IdEntity;
import org.qubership.atp.dataset.ei.service.DataSetsImporter;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetsImporterTest {
    private static final Logger log = LoggerFactory.getLogger(DataSetsImporterTest.class);
    private ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private DataSetsImporter dataSetsImporter;
    @Mock
    private JpaDataSetService dsService;
    @Mock
    private JpaDataSetListService dslService;
    private DuplicateNameChecker duplicateNameChecker;
    @Mock
    private EntityManagerController entityManagerController;
    @Mock
    private ClearCacheService clearCacheService;
    private ExportImportData importData;

    @BeforeEach
    public void setUp() {
        this.duplicateNameChecker = new DuplicateNameChecker();
        this.objectLoaderFromDiskService = new ObjectLoaderFromDiskService();
        this.dataSetsImporter = new DataSetsImporter(this.objectLoaderFromDiskService, this.dsService, this.dslService, this.duplicateNameChecker, this.entityManagerController, this.clearCacheService);
        DataSetList dslMock = (DataSetList)Mockito.mock(DataSetList.class);
        long orderCount = 0L;
        Mockito.when((Object)dslMock.getLastDataSetsOrderNumber()).thenReturn((Object)orderCount++);
        Mockito.when((Object)this.dslService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)dslMock);
        this.importData = new ExportImportData(null, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
    }

    @Test
    public void importDataSets() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        this.dataSetsImporter.importDataSets(workDir, this.importData);
        ((JpaDataSetService)Mockito.verify((Object)this.dsService, (VerificationMode)Mockito.times((int)2))).replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any());
    }

    @Test
    public void importDataSets_2() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.dsService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((org.qubership.atp.dataset.service.jpa.delegates.DataSet)Mockito.mock(org.qubership.atp.dataset.service.jpa.delegates.DataSet.class)));
        this.dataSetsImporter.importDataSets(workDir, this.importData);
        ((JpaDataSetService)Mockito.verify((Object)this.dsService, (VerificationMode)Mockito.times((int)0))).replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any());
        ((JpaDataSetService)Mockito.verify((Object)this.dsService, (VerificationMode)Mockito.times((int)2))).save((org.qubership.atp.dataset.service.jpa.delegates.DataSet)ArgumentMatchers.any());
    }

    @Test
    public void checkAndCorrectName_noDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSet object = new DataSet();
        object.setName(name);
        object.setId(id);
        this.dataSetsImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSet object = new DataSet();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSet entity = new DataSet();
        entity.setName(name);
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetsImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameButWithOtherNameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSet object = new DataSet();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSet entity = new DataSet();
        entity.setName("Object Name 2");
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetsImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_twoDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSet object = new DataSet();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSet entity = new DataSet();
        entity.setName(name);
        entity.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        DataSet entity2 = new DataSet();
        entity2.setName(name + " Copy");
        entity2.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity2);
        DataSet entity3 = new DataSet();
        entity3.setName(name + " Copy _1");
        entity3.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity3);
        this.dataSetsImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)(name + " Copy _2"));
    }
}

