/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.parser;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.parser.ParsingState;
import org.qubership.atp.dataset.macros.parser.Strategy;
import org.qubership.atp.dataset.macros.parser.TokenType;

public class ParsingStateTest {
    public static final Set<String> MACROSES = ImmutableSet.of((Object)"REF_DSL", (Object)"SUM", (Object)"REF_ALIAS", (Object)"REF_THIS");
    public static final MacroRegistry MACRO_FINDER = new MacroRegistry(){

        public boolean fullyEquals(String to) {
            to = to.toUpperCase();
            for (String macro : MACROSES) {
                if (!to.equals(macro)) continue;
                return true;
            }
            return false;
        }

        public boolean partiallyEquals(String to) {
            to = to.toUpperCase();
            for (String macro : MACROSES) {
                if (!macro.startsWith(to)) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public Macros getMacros(@Nonnull String key) {
            throw new UnsupportedOperationException("Mock method");
        }
    };

    public static void validate(String inputMacro, Map.Entry<TokenType, String> ... entries) {
        ValidateState testFacade = new ValidateState(inputMacro, Arrays.asList(entries).iterator());
        testFacade.validate();
    }

    @Test
    public void hasNestedMacro_NoExtraArgs_ContainsOnlyFormulas() throws Exception {
        ParsingStateTest.validate("#REF_DSL(#sum(1,2,3))", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"sum"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1,2,3"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"")});
    }

    @Test
    public void text_EndedWithSharp_IsProbablyFormula() throws Exception {
        ParsingStateTest.validate("123#", new Map.Entry[]{new ImmutablePair((Object)TokenType.PROBABLY_FORMULA, (Object)"123#")});
    }

    @Test
    public void text_WithSharpInTheMiddle_IsText() throws Exception {
        ParsingStateTest.validate("123#456", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"123#456")});
    }

    @Test
    public void hasNestedMacro_HasExtraArgs_ContainsTextPart() throws Exception {
        ParsingStateTest.validate("#REF_DSL(1,#sum(1,#2,#),3)", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"1,"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"sum"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1,#2,#"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)",3")});
    }

    @Test
    public void hasTwoNestedMacro_HasExtraArgs_ContainsTextParts() throws Exception {
        ParsingStateTest.validate("#REF_DSL(1,#sum(1,#2,#),3#sum(1,#2,#))", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"1,"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"sum"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1,#2,#"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)",3"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"sum"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1,#2,#"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"")});
    }

    @Test
    public void macroUnion_NoSeparator_ContainsOnlyFormulas() throws Exception {
        ParsingStateTest.validate("#REF_DSL(1.2.3)#REF_DSL(4.5.6)", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1.2.3"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"4.5.6")});
    }

    @Test
    public void macroUnion_HasSeparators_ContainsTextParts() throws Exception {
        ParsingStateTest.validate("#REF_DSL(1.2.3)##REF_DSL(4.5.6)#", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1.2.3"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"#"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"4.5.6"), new ImmutablePair((Object)TokenType.PROBABLY_FORMULA, (Object)"#")});
    }

    @Test
    public void macro_SurroundedWithText_EndsWithTextPart() throws Exception {
        ParsingStateTest.validate("first.#REF_DSL(1.2.3).third", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"first."), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1.2.3"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)".third")});
    }

    private static class ValidateState {
        private final Iterator<Map.Entry<TokenType, String>> er;
        private final StringBuilder toParse;
        StringBuilder parsed = new StringBuilder();
        ParsingState parsingState = new ParsingState(MACRO_FINDER){

            protected void pushToken(Strategy entry) {
                super.pushToken(entry);
                this.iterate(entry);
            }
        };

        private ValidateState(String inputMacro, Iterator<Map.Entry<TokenType, String>> er) {
            this.toParse = new StringBuilder(inputMacro);
            this.er = er;
        }

        public void validate() {
            while (this.toParse.length() != 0) {
                char c = this.toParse.charAt(0);
                this.toParse.deleteCharAt(0);
                this.parsed.append(c);
                this.parsingState.read(c);
            }
            if (!this.parsingState.currentStrategy.consumed) {
                this.iterate(this.parsingState.currentStrategy);
            }
            if (this.er.hasNext()) {
                String extra = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.er, 16), false).map(Objects::toString).collect(Collectors.joining("\n"));
                throw new IllegalStateException("Additional iteration(s) expected:\n" + extra);
            }
        }

        private void iterate(Strategy entry) {
            String currentIteration = this.parsed + " | " + this.toParse + "   " + entry.getKey() + "   " + (String)entry.getValue();
            if (!this.er.hasNext()) {
                throw new IllegalStateException("\nGot unexpected iteration:\n" + currentIteration);
            }
            Map.Entry<TokenType, String> expectedEntry = this.er.next();
            Assertions.assertEquals(expectedEntry, (Object)entry, (String)("\nFailed iteration:\n" + currentIteration));
            System.out.println(currentIteration);
        }
    }
}

