/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class ConcurrentModificationServiceTest
extends AbstractTest {
    private static final String VA_NAME = "VA";
    private static final String DSL_NAME = "DSL";
    private DataSetList dataSetList;
    @Autowired
    private ConcurrentModificationService concurrentModificationService;

    @BeforeEach
    public void setUp() {
        this.va = this.visibilityAreaService.create(VA_NAME);
        this.dataSetList = this.dataSetListService.create(this.va.getId(), DSL_NAME, null);
    }

    @Test
    public void testGetHttpStatus_shouldReturnsOk_whenEntityIdIsNull() {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(null, Long.valueOf(System.currentTimeMillis()));
        MatcherAssert.assertThat((Object)httpStatus, (Matcher)Matchers.equalTo((Object)HttpStatus.OK));
    }

    @Test
    public void testGetHttpStatus_shouldReturnsOk_whenModifiedWhenIsNull() {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(UUID.randomUUID(), null);
        MatcherAssert.assertThat((Object)httpStatus, (Matcher)Matchers.equalTo((Object)HttpStatus.OK));
    }

    @Test
    public void testGetHttpStatus_shouldReturnsOk_whenModifiedWhenIsNotNullAndEquals() {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(this.dataSetList.getId(), Long.valueOf(this.dataSetList.getModifiedWhen().getTime()));
        MatcherAssert.assertThat((Object)httpStatus, (Matcher)Matchers.equalTo((Object)HttpStatus.OK));
    }

    @Test
    public void testGetHttpStatus_shouldReturnsImUsed_whenModifiedWhenIsNotNullAndNotEquals() throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(500L);
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(this.dataSetList.getId(), Long.valueOf(System.currentTimeMillis()));
        MatcherAssert.assertThat((Object)httpStatus, (Matcher)Matchers.equalTo((Object)HttpStatus.IM_USED));
    }
}

