/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.LabelRepository;
import org.qubership.atp.dataset.exception.dataset.DataSetExistsException;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.service.direct.DuplicateKeyException;
import org.qubership.atp.dataset.service.direct.impl.DataSetBuilder;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class DataSetServiceImplTest
extends DataSetBuilder {
    DataSetList addressDsl;
    DataSetList postalCodeDsl;
    DataSet addrFirstDs;
    DataSet addrSecondDs;
    DataSet postalCodeFirstDs;
    DataSet postalCodeSecondDs;
    Attribute firstAttribute;
    Attribute postalCodeRef;
    @Autowired
    LabelRepository labelRepository;
    @Autowired
    JpaDataSetService jpaDataSetService;
    private DataSetList customerDsl;
    private DataSet customerDs;
    private Attribute addressRefAttr;
    private DataSetList datasetList1;
    private DataSetList dataSetList2;
    private DataSet dataSetToDelete;
    private Parameter parameterToCheck;

    @Override
    @BeforeEach
    public void setUp() throws EvalException {
        super.setUp();
        this.createAddressDsl();
        this.createPostalCodeDsl();
        this.createAttributes();
        this.overlapParameters();
        this.createDatasetAndRedParam();
    }

    @Test
    public void testRenameOfDataSetWillReplaceRef() throws DuplicateKeyException {
        this.parameterService.update(this.source.getId(), "#REF_DSL(DSL.DS.ATTR) #REF(DS.ATTR)");
        this.dataSetService.rename(this.dataSet1.getId(), "SZ_UPDATED");
        String text = ((Parameter)this.parameterService.get(this.source.getId())).getText();
        Assertions.assertEquals((Object)"#REF_DSL(DSL.SZ_UPDATED.ATTR) #REF(SZ_UPDATED.ATTR)", (Object)this.wrapperService.unWrapAlias(text));
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"DataSet + MagicName.")));
    }

    @Test
    public void testDeleteDataSetCascade() {
        Parameter parameter = this.parameterService.create(this.dataSet2.getId(), this.attr.getId(), "", null, null);
        this.dataSetService.delete(this.dataSet2.getId());
        Assertions.assertNotNull((Object)this.dataSetListService.get(this.dataSetList.getId()));
        Assertions.assertNull((Object)this.dataSetService.get(this.dataSet2.getId()));
        Assertions.assertNull((Object)this.parameterService.get(parameter.getId()));
        Assertions.assertNotNull((Object)this.attributeService.get(this.attr.getId()));
        List all = this.visibilityAreaService.getAll();
        VisibilityArea area = all.stream().filter(va -> va.getId().equals(this.vaId)).findFirst().orElseThrow(() -> new AssertionError((Object)"VisibilityArea not found"));
        Assertions.assertNotNull((Object)area);
    }

    @Test
    public void getAffectedDatasetsByChangesAttribute_Scenary_AffectedDatasetsHasTaken() {
        DataSetList dsl_source = this.dataSetListService.create(this.vaId, "dsl_source", null);
        DataSet dsSource = this.dataSetService.create(dsl_source.getId(), "ds_source");
        Attribute textAttr = this.attributeService.create(dsl_source.getId(), Integer.valueOf(0), "TXT", AttributeType.TEXT, null, null);
        this.parameterService.create(dsSource.getId(), textAttr.getId(), "text", null, null);
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSet ds1 = this.dataSetService.create(dsl.getId(), "ds");
        Attribute refAttr = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "ref_attr", AttributeType.DSL, dsl_source.getId(), null);
        this.parameterService.create(ds1.getId(), refAttr.getId(), null, null, dsSource.getId());
        this.parameterService.set(ds1.getId(), textAttr.getId(), Collections.singletonList(refAttr.getId()), "newText", null, null);
        List datasets = this.dataSetService.getOverlapContainers(dsSource.getId(), textAttr.getId(), false);
        Assertions.assertEquals((int)1, (int)datasets.size());
    }

    @Test
    public void testGetAffectedDatasetsWhenInHierarchy() {
        this.createCustomerDsl();
        this.parameterService.set(this.customerDs.getId(), this.firstAttribute.getId(), Arrays.asList(this.addressRefAttr.getId(), this.postalCodeRef.getId()), "Customer_override", null, null);
        List overlapDataSets = this.dataSetService.getOverlapContainers(this.postalCodeFirstDs.getId(), this.firstAttribute.getId(), false);
        List overlapData = this.dataSetService.getOverlapContainers(this.postalCodeFirstDs.getId(), this.firstAttribute.getId(), true);
        Assertions.assertEquals((int)0, (int)overlapDataSets.size(), (String)"Size must be 0, because no one parameter is overridden in Hierarchy for one dataset");
        Assertions.assertEquals((int)0, (int)overlapData.size(), (String)"Size must be 0, because no one parameter is overridden in Hierarchy for one dataset");
        Assertions.assertEquals((int)0, (int)overlapDataSets.size());
        Assertions.assertEquals((int)0, (int)overlapData.size());
        Assertions.assertEquals((int)0, (int)overlapData.size(), (String)"Size must be 0, because no one parameter is overridden in Hierarchy for one dataset");
        List ids = overlapData.stream().map(TableResponse::getDsId).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)ids.size());
    }

    @Test
    public void testGetAffectedDatasetsByChangesAttributeReturnOnlyAffectedDS() {
        List overlapDataSets = this.dataSetService.getOverlapContainers(this.postalCodeFirstDs.getId(), this.firstAttribute.getId(), false);
        List overlapData = this.dataSetService.getOverlapContainers(this.postalCodeFirstDs.getId(), this.firstAttribute.getId(), true);
        Assertions.assertEquals((int)0, (int)overlapDataSets.size(), (String)"Size must be 0, because no one ds is affected");
        Assertions.assertEquals((int)0, (int)overlapData.size(), (String)"Size must be 0, because no one ds is affected");
        Assertions.assertEquals((int)0, (int)overlapDataSets.size());
        Assertions.assertEquals((int)0, (int)overlapData.size());
    }

    @Test
    public void testGetAffectedDatasetsByChangesDataSetReferenceReturnOnlyAffectedDS() {
        List affectedDataSetsByChangesDataSetReference = this.dataSetService.getAffectedDataSetsByChangesDataSetReference(this.postalCodeFirstDs.getId(), false);
        Assertions.assertEquals((int)0, (int)affectedDataSetsByChangesDataSetReference.size(), (String)"Size must be 0, because no one ds is affected");
        Assertions.assertEquals((int)0, (int)affectedDataSetsByChangesDataSetReference.size());
    }

    @Test
    public void getAffectedInfoByDeletingDataSet_fullInfoReturned() {
        List affectedInfoByTryingToDeleteDs = this.dataSetService.getAffectedDataSetsByChangesDataSetReference(this.dataSetToDelete.getId(), true);
        Assertions.assertEquals((int)0, (int)affectedInfoByTryingToDeleteDs.size(), (String)"No one param is affected");
        Assertions.assertEquals((int)0, (int)affectedInfoByTryingToDeleteDs.size());
    }

    @Test
    public void testMarkDataSet() {
        this.createCustomerDsl();
        String labelName = "Customer Label #001";
        this.dataSetService.mark(this.customerDs.getId(), labelName);
        Assertions.assertEquals((Object)labelName, (Object)((Label)this.dataSetService.getLabels(this.customerDs.getId()).get(0)).getName());
    }

    @Test
    public void testUnmarkDataSet() {
        this.createCustomerDsl();
        Label label = this.dataSetService.mark(this.customerDs.getId(), "Label#001");
        this.dataSetService.unmark(this.customerDs.getId(), label.getId());
        Assertions.assertFalse((boolean)this.dataSetService.getLabels(this.customerDs.getId()).contains(label));
    }

    @Test
    public void testDeleteDataSetLabelCascade() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.createCustomerDsl();
        this.dataSetService.mark(this.customerDs.getId(), "Label#001");
        DataSet ds = (DataSet)this.dataSetService.get(this.customerDs.getId());
        Assertions.assertNotNull((Object)ds);
        MatcherAssert.assertThat((Object)ds.getLabels(), (Matcher)Matchers.hasSize((int)1));
        this.dataSetService.delete(this.customerDs.getId());
        MatcherAssert.assertThat((Object)this.customerDs.getLabels(), (Matcher)Matchers.empty());
        Method method = this.labelRepository.getClass().getDeclaredMethod("getLabelsOfDs", UUID.class);
        method.setAccessible(true);
        List labels = (List)method.invoke((Object)this.labelRepository, this.customerDs.getId());
        MatcherAssert.assertThat((Object)labels, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetAllDslDsByAttribute() {
        this.createCustomerDsl();
        List resultDs = this.dataSetService.getAllDslDsByAttribute(this.addressRefAttr.getId(), Collections.emptyList());
        Assertions.assertEquals((Object)this.addressRefAttr.getDataSetList().getDataSets(), (Object)resultDs);
    }

    @Test
    public void lockDataSet_setLockTrue_flagUpdate() throws DuplicateKeyException {
        DataSet dsLock = this.dataSetService.create(this.datasetList1.getId(), "dsLock");
        Assertions.assertEquals((Object)Objects.requireNonNull((DataSet)this.dataSetService.get(dsLock.getId())).isLocked(), (Object)false);
        this.dataSetService.lock(this.datasetList1.getId(), Collections.singletonList(dsLock.getId()), true);
        Assertions.assertEquals((Object)Objects.requireNonNull((DataSet)this.dataSetService.get(dsLock.getId())).isLocked(), (Object)true);
    }

    @Test
    public void renameDataSet_datasetIsLockTrue_NotRenameThrowException() throws DuplicateKeyException {
        DataSet dsLock = this.dataSetService.create(this.datasetList1.getId(), "dsLock");
        Assertions.assertEquals((Object)Objects.requireNonNull((DataSet)this.dataSetService.get(dsLock.getId())).isLocked(), (Object)false);
        this.dataSetService.lock(this.datasetList1.getId(), Collections.singletonList(dsLock.getId()), true);
        Assertions.assertEquals((Object)Objects.requireNonNull((DataSet)this.dataSetService.get(dsLock.getId())).isLocked(), (Object)true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dataSetService.rename(dsLock.getId(), "dsUnLock"));
    }

    @Test
    public void testCreateDataSetWithNonUniqueName() {
        Assertions.assertThrows(DataSetExistsException.class, () -> this.dataSetService.create(this.dataSetList.getId(), "DS"));
    }

    @Test
    public void testRenameDataSetWithNonUniqueName() {
        Assertions.assertThrows(DataSetExistsException.class, () -> this.dataSetService.rename(this.dataSet1.getId(), "DS2"));
    }

    @Test
    public void testDuplicateDataSetWithNonUniqueName() {
        Assertions.assertThrows(DataSetExistsException.class, () -> this.dataSetService.copy(this.dataSet1.getId(), "DS"));
    }

    private void createCustomerDsl() {
        this.customerDsl = this.dataSetListService.create(this.vaId, "CustomerDsl", null);
        this.addressRefAttr = this.attributeService.create(this.customerDsl.getId(), Integer.valueOf(0), "addressRef", AttributeType.DSL, this.addressDsl.getId(), null);
        this.customerDs = this.dataSetService.create(this.customerDsl.getId(), "CustomerDs");
        this.parameterService.create(this.customerDs.getId(), this.addressRefAttr.getId(), null, null, this.addrFirstDs.getId());
    }

    public void createAddressDsl() {
        this.addressDsl = this.dataSetListService.create(this.vaId, "addressDsl", null);
        this.addrFirstDs = this.dataSetService.create(this.addressDsl.getId(), "addrFirstDs");
        this.addrSecondDs = this.dataSetService.create(this.addressDsl.getId(), "addrSecondDs");
    }

    public void createPostalCodeDsl() {
        this.postalCodeDsl = this.dataSetListService.create(this.vaId, "postalCodeDsl", null);
        this.postalCodeFirstDs = this.dataSetService.create(this.postalCodeDsl.getId(), "postalCodeFirstDs");
        this.firstAttribute = this.attributeService.create(this.postalCodeDsl.getId(), Integer.valueOf(0), "PC_firstAttribute", AttributeType.TEXT, null, null);
        this.parameterService.create(this.postalCodeFirstDs.getId(), this.firstAttribute.getId(), "PC1_firstValue", null, null);
        this.postalCodeSecondDs = this.dataSetService.create(this.postalCodeDsl.getId(), "postalCodeSecondDs");
        this.parameterService.create(this.postalCodeSecondDs.getId(), this.firstAttribute.getId(), "postalCodeSecondDs", null, null).getId();
    }

    public void createAttributes() {
        this.postalCodeRef = this.attributeService.create(this.addressDsl.getId(), Integer.valueOf(2), "postalCodeRef", AttributeType.DSL, this.postalCodeDsl.getId(), null);
        this.parameterService.create(this.addrFirstDs.getId(), this.postalCodeRef.getId(), "", null, this.postalCodeFirstDs.getId()).getId();
        this.parameterService.create(this.addrSecondDs.getId(), this.postalCodeRef.getId(), "", null, this.postalCodeSecondDs.getId()).getId();
    }

    public void overlapParameters() {
        this.parameterService.set(this.addrFirstDs.getId(), this.firstAttribute.getId(), Collections.singletonList(this.postalCodeRef.getId()), "ADDR1_overlapped_firstValue", null, null);
        this.parameterService.set(this.addrSecondDs.getId(), this.firstAttribute.getId(), Collections.singletonList(this.postalCodeRef.getId()), "ADDR2_overlapped_firstValue", null, null);
    }

    private void createDatasetAndRedParam() {
        this.datasetList1 = this.dataSetListService.create(this.vaId, "dsl1", null);
        this.dataSetList2 = this.dataSetListService.create(this.vaId, "dsl2", null);
        this.dataSetToDelete = this.dataSetService.create(this.datasetList1.getId(), "dsToDelete");
        DataSet dsl2ds = this.dataSetService.create(this.dataSetList2.getId(), "ds");
        Attribute attribute = this.attributeService.create(this.dataSetList2.getId(), Integer.valueOf(0), "refAttr", AttributeType.DSL, this.datasetList1.getId(), null);
        this.parameterToCheck = this.parameterService.create(dsl2ds.getId(), attribute.getId(), "refToDs", null, this.dataSetToDelete.getId());
    }

    @Test
    public void mark_setLabelToDataset_dataSetHasLabel() {
        String labelName = "Label";
        this.dataSetService.mark(this.dsId1, labelName);
        List labels = ((DataSet)this.dataSetService.get(this.dsId1)).getLabels();
        Assertions.assertEquals((Object)labelName, (Object)((Label)labels.get(0)).getName());
    }

    @Test
    public void unmark_deleteLabelFromDataset_dataSetHasNotLabel() {
        String labelName = "Label";
        Label label = this.dataSetService.mark(this.dsId1, labelName);
        this.dataSetService.unmark(this.dsId1, label.getId());
        List labels = ((DataSet)this.dataSetService.get(this.dsId1)).getLabels();
        Assertions.assertEquals((int)0, (int)labels.size());
    }

    @Test
    public void rename_renameDataSetWithUniqueName_newDataSetNameInDB() throws DuplicateKeyException {
        Assertions.assertEquals((Object)"DS", (Object)((DataSet)this.dataSetService.get(this.dataSet1.getId())).getName());
        this.dataSetService.rename(this.dataSet1.getId(), "DS_new");
        Assertions.assertEquals((Object)"DS_new", (Object)((DataSet)this.dataSetService.get(this.dataSet1.getId())).getName());
    }

    @Test
    public void copy_duplicateDataSetWithNameProvidedAndChangeParameter_parentParameterShouldNotChangeInDB() throws DuplicateKeyException {
        DataSet newDataSet = this.dataSetService.copy(this.dataSet1.getId(), "DS_Copy");
        String valueBefore = this.source.getText();
        this.parameterService.set(newDataSet.getId(), this.firstAttribute.getId(), null, "txt_new", null, null);
        Assertions.assertEquals((Object)valueBefore, (Object)((Parameter)this.parameterService.get(this.parameterId)).getText());
    }

    @Test
    public void copy_duplicateDataSetWithNameProvided_newDataSetIsPresent() throws DuplicateKeyException {
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "DSL-1", null);
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "DSL-2", null);
        DataSet ds1 = this.dataSetService.create(dsl1.getId(), "DS1");
        DataSet ds2 = this.dataSetService.create(dsl2.getId(), "DS2");
        Attribute textAttr1 = this.attributeService.create(dsl1.getId(), Integer.valueOf(0), "TXT1", AttributeType.TEXT, null, null);
        Attribute textAttr2 = this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "TXT2", AttributeType.TEXT, null, null);
        Attribute refAttr2 = this.attributeService.create(dsl2.getId(), Integer.valueOf(1), "REF", AttributeType.DSL, dsl1.getId(), null);
        Attribute listAttr2 = this.attributeService.create(dsl2.getId(), Integer.valueOf(2), "LIST", AttributeType.LIST, null, Collections.singletonList("list1"));
        String textValue = "txt2";
        UUID refId = ds1.getId();
        UUID listId = ((ListValue)listAttr2.getListValues().get(0)).getId();
        this.parameterService.create(ds1.getId(), textAttr1.getId(), "txt1", null, null);
        this.parameterService.create(ds2.getId(), textAttr2.getId(), textValue, null, null);
        this.parameterService.create(ds2.getId(), refAttr2.getId(), null, null, refId);
        this.parameterService.create(ds2.getId(), listAttr2.getId(), null, listId, null);
        DataSet newDs = this.dataSetService.copy(ds2.getId(), "DS2_Copy");
        List parameters = newDs.getParameters();
        Assertions.assertEquals((Object)"DS2_Copy", (Object)newDs.getName());
        Assertions.assertEquals((Object)dsl2.getId(), (Object)newDs.getDataSetList().getId());
        Assertions.assertNotNull((Object)this.jpaDataSetService.getById(newDs.getId()));
        for (Parameter parameter : parameters) {
            if (Objects.nonNull(parameter.getText())) {
                Assertions.assertEquals((Object)textValue, (Object)parameter.getText());
            }
            if (Objects.nonNull(parameter.getDataSetReference())) {
                Assertions.assertEquals((Object)refId, (Object)parameter.getDataSetReference().getId());
            }
            if (!Objects.nonNull(parameter.getListValue())) continue;
            Assertions.assertEquals((Object)listId, (Object)parameter.getListValue().getId());
        }
    }

    @Test
    public void delete_deleteDataSetWithEmptyTextParameter_dataSetWasDeletedInDB() throws DuplicateKeyException {
        DataSet dsBefore = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        Attribute attribute = this.attributeService.create(this.datasetList1.getId(), Integer.valueOf(0), "TextAttr", AttributeType.TEXT, null, null);
        this.parameterService.create(this.dataSetToDelete.getId(), attribute.getId(), null, null, null);
        this.dataSetService.delete(this.dataSetToDelete.getId());
        DataSet dsAfter = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        Assertions.assertEquals((int)0, (int)dsBefore.getParameters().size());
        Assertions.assertNotNull((Object)dsBefore);
        Assertions.assertNull((Object)dsAfter);
    }

    @Test
    public void delete_deleteDataSetWithEmptyRefParameter_dataSetWasDeletedInDB() throws DuplicateKeyException {
        DataSet dsBefore = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        Attribute attribute = this.attributeService.create(this.datasetList1.getId(), Integer.valueOf(0), "RefAttr", AttributeType.DSL, null, null);
        this.parameterService.create(this.dataSetToDelete.getId(), attribute.getId(), null, null, null);
        this.dataSetService.delete(this.dataSetToDelete.getId());
        DataSet dsAfter = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        Assertions.assertEquals((int)0, (int)dsBefore.getParameters().size());
        Assertions.assertNotNull((Object)dsBefore);
        Assertions.assertNull((Object)dsAfter);
    }

    @Test
    public void delete_deleteDataSetWithEmptyTextAttribute_dataSetWasDeletedInDB() throws DuplicateKeyException {
        DataSet dsBefore = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        this.dataSetService.delete(this.dataSetToDelete.getId());
        DataSet dsAfter = (DataSet)this.dataSetService.get(this.dataSetToDelete.getId());
        Assertions.assertEquals((int)0, (int)dsBefore.getParameters().size());
        Assertions.assertNotNull((Object)dsBefore);
        Assertions.assertNull((Object)dsAfter);
    }

    @Test
    public void copy_copyDataSetWithEmptyRefParam_newDataSetHasNullRefParameter() throws DuplicateKeyException {
        this.dataSetService.create(this.dslId, "DS_Test").getId();
        Attribute refAttribute = this.attributeService.create(this.dslId, Integer.valueOf(0), "RefAttr", AttributeType.DSL, this.dataSetList2.getId(), null);
        DataSet dataSetCopy = this.dataSetService.copy(this.dataSet1.getId(), "DS_Test_Copy");
        Assertions.assertNull((Object)this.parameterService.getByDataSetIdAttributeId(dataSetCopy.getId(), refAttribute.getId()));
    }

    @Test
    public void copy_copyDataSetWithEmptyTextParam_newDataSetHasNullTextParameter() throws DuplicateKeyException {
        this.dataSetService.create(this.dslId, "DS_Test").getId();
        Attribute textAttribute = this.attributeService.create(this.dslId, Integer.valueOf(0), "TextAttr", AttributeType.TEXT, null, null);
        DataSet dataSetCopy = this.dataSetService.copy(this.dataSet1.getId(), "DS_Test_Copy");
        Assertions.assertNull((Object)this.parameterService.getByDataSetIdAttributeId(dataSetCopy.getId(), textAttribute.getId()));
    }

    @Test
    public void restore_deleteDataSetAndRestoreDataSet_dataSetRestoredSuccessfully() throws DuplicateKeyException, IOException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "DSL1", null);
        DataSet ds1 = this.dataSetService.create(dsl.getId(), "DS1");
        DataSet ds2 = this.dataSetService.create(dsl.getId(), "DS2");
        Attribute textAttribute = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "TextAttr", AttributeType.TEXT, null, null);
        Parameter parameter1 = this.parameterService.create(ds1.getId(), textAttribute.getId(), "Text1", null, null);
        Parameter parameter2 = this.parameterService.create(ds2.getId(), textAttribute.getId(), "Text2", null, null);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        String expectedJson = "{\"dataSetList\": \"" + dsl.getId() + "\",\"id\": \"" + ds2.getId() + "\",\"name\": \"" + ds2.getName() + "\",\"previousDataSet\": \"" + ds1.getId() + "\",\"parameters\": [{\"attribute\": \"" + textAttribute.getId() + "\",\"text\": \"Text2\",\"attrKey\": []}]}";
        JsonNode dataSetJson = mapper.readTree(expectedJson);
        this.dataSetService.delete(ds2.getId());
        Assertions.assertNotNull((Object)this.dataSetService.get(ds1.getId()));
        Assertions.assertNull((Object)this.dataSetService.get(ds2.getId()));
        this.dataSetService.restore(dataSetJson);
        DataSet newDs = (DataSet)this.dataSetService.get(ds2.getId());
        Assertions.assertNotNull((Object)this.dataSetService.get(ds1.getId()));
        Assertions.assertNotNull((Object)this.dataSetService.get(ds2.getId()));
        Assertions.assertEquals((Object)dsl.getId(), (Object)newDs.getDataSetList().getId());
        Assertions.assertEquals((int)1, (int)newDs.getParameters().size());
        Assertions.assertEquals((Object)textAttribute.getId(), (Object)((Parameter)newDs.getParameters().get(0)).getAttribute().getId());
        Assertions.assertEquals((Object)"Text2", (Object)((Parameter)newDs.getParameters().get(0)).getText());
        Assertions.assertEquals((Object)newDs.getId(), (Object)((Parameter)newDs.getParameters().get(0)).getDataSet().getId());
        Assertions.assertEquals((int)0, (int)newDs.getLabels().size());
        org.qubership.atp.dataset.service.jpa.delegates.DataSet dpaDs1 = this.jpaDataSetService.getById(ds1.getId());
        org.qubership.atp.dataset.service.jpa.delegates.DataSet dpaDs2 = this.jpaDataSetService.getById(ds2.getId());
        Assertions.assertTrue((dpaDs2.ordering() > dpaDs1.ordering() ? 1 : 0) != 0);
    }

    @Test
    public void restore_deleteDataSetAndRestoreDataSet_childDataSetNotChanged() throws DuplicateKeyException, IOException {
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "DSL1", null);
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "DSL2", null);
        Attribute textAttribute = this.attributeService.create(dsl1.getId(), Integer.valueOf(0), "TextAttr", AttributeType.TEXT, null, null);
        Attribute refAttribute = this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "RefAttr", AttributeType.DSL, dsl2.getId(), null);
        DataSet dsChild = this.dataSetService.create(dsl1.getId(), "dsChild");
        DataSet dsParent = this.dataSetService.create(dsl2.getId(), "dsParent");
        Parameter parameter1 = this.parameterService.create(dsChild.getId(), textAttribute.getId(), "Text", null, null);
        Parameter parameter2 = this.parameterService.create(dsParent.getId(), textAttribute.getId(), null, null, dsChild.getId());
        int numberOfParams = dsChild.getParameters().size();
        String value = parameter1.getText();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        String expectedJson = "{\"dataSetList\": \"" + dsl1.getId() + "\",\"id\": \"" + dsParent.getId() + "\",\"name\": \"" + dsParent.getName() + "\",\"previousDataSet\": \"" + dsChild.getId() + "\",\"parameters\": [{\"attribute\": \"" + refAttribute.getId() + "\",\"text\": \"\",\"attrKey\": []}]}";
        JsonNode dataSetJson = mapper.readTree(expectedJson);
        this.dataSetService.delete(dsParent.getId());
        this.dataSetService.restore(dataSetJson);
        Assertions.assertEquals((int)numberOfParams, (int)dsChild.getParameters().size());
        Assertions.assertEquals((Object)value, (Object)((Parameter)dsChild.getParameters().get(0)).getText());
    }

    @Test
    public void collectAffectedDatasetsByDsId() {
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "DSL1", null);
        DataSet ds1 = this.dataSetService.create(dsl1.getId(), "DS1");
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "DSL2", null);
        DataSet ds2 = this.dataSetService.create(dsl2.getId(), "DS2");
        DataSetList dsl3 = this.dataSetListService.create(this.vaId, "DSL3", null);
        DataSet ds3 = this.dataSetService.create(dsl2.getId(), "DS3");
        Attribute refAttr1 = this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "ref_attr", AttributeType.DSL, dsl1.getId(), null);
        Parameter parameter1 = this.parameterService.create(ds2.getId(), refAttr1.getId(), null, null, ds1.getId());
        Attribute refAttr2 = this.attributeService.create(dsl3.getId(), Integer.valueOf(0), "ref_attr", AttributeType.DSL, dsl2.getId(), null);
        Parameter parameter2 = this.parameterService.create(ds3.getId(), refAttr2.getId(), null, null, ds2.getId());
        Set result = this.dataSetService.collectAffectedDatasetsByDsId(ds1.getId());
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertTrue((boolean)result.contains(ds1.getId()));
        Assertions.assertTrue((boolean)result.contains(ds2.getId()));
        Assertions.assertTrue((boolean)result.contains(ds3.getId()));
    }

    @Test
    public void collectAffectedDatasetsByDslId() {
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "DSL1", null);
        DataSet ds1_1 = this.dataSetService.create(dsl1.getId(), "DS1_1");
        DataSet ds1_2 = this.dataSetService.create(dsl1.getId(), "DS1_2");
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "DSL2", null);
        DataSet ds2 = this.dataSetService.create(dsl2.getId(), "DS2");
        DataSetList dsl3 = this.dataSetListService.create(this.vaId, "DSL3", null);
        DataSet ds3 = this.dataSetService.create(dsl2.getId(), "DS3");
        Attribute refAttr1 = this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "ref_attr", AttributeType.DSL, dsl1.getId(), null);
        Parameter parameter1 = this.parameterService.create(ds2.getId(), refAttr1.getId(), null, null, ds1_1.getId());
        Attribute refAttr2 = this.attributeService.create(dsl3.getId(), Integer.valueOf(0), "ref_attr", AttributeType.DSL, dsl2.getId(), null);
        Parameter parameter2 = this.parameterService.create(ds3.getId(), refAttr2.getId(), null, null, ds2.getId());
        Set result = this.dataSetService.collectAffectedDatasetsByDslId(dsl1.getId());
        Assertions.assertEquals((int)4, (int)result.size());
        Assertions.assertTrue((boolean)result.contains(ds1_1.getId()));
        Assertions.assertTrue((boolean)result.contains(ds1_2.getId()));
        Assertions.assertTrue((boolean)result.contains(ds2.getId()));
        Assertions.assertTrue((boolean)result.contains(ds3.getId()));
    }
}

