/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class ParameterServiceImplTest
extends AbstractTest {
    private VisibilityArea visibilityArea;
    DataSetList dsl1;
    DataSetList dsl2;
    private DataSet ds_11;
    private DataSet ds_21;
    private Attribute attr11;
    private Attribute attr12;
    private Attribute attr13;
    private Attribute attr21;
    private Attribute attr22;
    Parameter param11;
    Parameter param12;
    Parameter param21;
    Parameter param22;
    String originalTextValue;
    UUID originalListValue;
    UUID newListValue;

    @BeforeEach
    public void setUp() throws Exception {
        this.visibilityArea = this.visibilityAreaService.create("TestVA");
        this.dsl1 = this.dataSetListService.create(this.visibilityArea.getId(), "Dsl1", null);
        this.ds_11 = this.dataSetService.create(this.dsl1.getId(), "Ds11");
        this.attr11 = this.attributeService.create(this.dsl1.getId(), Integer.valueOf(0), "Attr11", AttributeType.TEXT, null, null);
        this.attr12 = this.attributeService.create(this.dsl1.getId(), Integer.valueOf(1), "Attr12", AttributeType.LIST, null, Arrays.asList("list1", "list2"));
        this.attr13 = this.attributeService.create(this.dsl1.getId(), Integer.valueOf(2), "Attr13", AttributeType.TEXT, null, null);
        this.originalTextValue = "textOriginalValue";
        this.originalListValue = ((ListValue)this.attr12.getListValues().get(0)).getId();
        this.newListValue = ((ListValue)this.attr12.getListValues().get(1)).getId();
        this.param11 = this.parameterService.create(this.ds_11.getId(), this.attr11.getId(), this.originalTextValue, null, null);
        this.param12 = this.parameterService.create(this.ds_11.getId(), this.attr12.getId(), null, this.originalListValue, null);
        this.dsl2 = this.dataSetListService.create(this.visibilityArea.getId(), "Dsl2", null);
        this.ds_21 = this.dataSetService.create(this.dsl2.getId(), "Ds21");
        this.attr21 = this.attributeService.create(this.dsl2.getId(), Integer.valueOf(0), "Attr21", AttributeType.DSL, this.dsl1.getId(), null);
        this.attr22 = this.attributeService.create(this.dsl2.getId(), Integer.valueOf(1), "Attr22", AttributeType.DSL, this.dsl1.getId(), null);
        this.param21 = this.parameterService.create(this.ds_21.getId(), this.attr21.getId(), null, null, this.ds_11.getId());
        this.param22 = this.parameterService.create(this.ds_21.getId(), this.attr22.getId(), null, null, this.ds_11.getId());
    }

    @Test
    public void deleteParameterOverlap_createAndRevertTextOverlap_overlappedTextAttributeShouldChangeAndRestoreValue() {
        String textOverlap = "overlappedTextValue";
        this.parameterService.set(this.ds_21.getId(), this.attr11.getId(), (List)ImmutableList.of((Object)this.attr21.getId()), textOverlap, null, null);
        this.ds_21 = (DataSet)this.dataSetService.get(this.ds_21.getId());
        Parameter actualTextValue = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)this.ds_21, (UUID)this.attr11.getId(), (Collection)ImmutableList.of((Object)this.attr21.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)textOverlap, (Object)actualTextValue.getText());
        actualTextValue = this.dataSetService.deleteParameterOverlap(this.ds_21.getId(), this.attr11.getId(), (List)ImmutableList.of((Object)this.attr21.getId()));
        Assertions.assertEquals((Object)this.originalTextValue, (Object)actualTextValue.getText());
    }

    @Test
    public void deleteParameterOverlap_createAndRevertListOverlap_overlappedListAttributeShouldChangeAndRestoreValue() {
        this.parameterService.set(this.ds_21.getId(), this.attr12.getId(), (List)ImmutableList.of((Object)this.attr22.getId()), null, null, this.newListValue);
        this.ds_21 = (DataSet)this.dataSetService.get(this.ds_21.getId());
        Parameter actualListValue = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)this.ds_21, (UUID)this.attr12.getId(), (Collection)ImmutableList.of((Object)this.attr22.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)this.newListValue, (Object)actualListValue.getListValue().getId());
        actualListValue = this.dataSetService.deleteParameterOverlap(this.ds_21.getId(), this.attr12.getId(), (List)ImmutableList.of((Object)this.attr22.getId()));
        Assertions.assertEquals((Object)this.originalListValue, (Object)actualListValue.getListValue().getId());
    }

    @Test
    public void set_editParentTextParameter_childReferenceParameterShouldChanged() throws Exception {
        Parameter textParameter = (Parameter)this.parameterService.get(this.param21.getId());
        Assertions.assertEquals((long)1L, (long)textParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getText()) && this.originalTextValue.equals(parameter.getText())).count());
        String newTextValue = "newTextValue";
        this.parameterService.set(this.ds_11.getId(), this.attr11.getId(), newTextValue, null);
        textParameter = (Parameter)this.parameterService.get(this.param21.getId());
        Assertions.assertEquals((long)1L, (long)textParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getText()) && newTextValue.equals(parameter.getText())).count());
    }

    @Test
    public void set_editParentListParameter_childReferenceParameterShouldChanged() throws Exception {
        Parameter refParameter = (Parameter)this.parameterService.get(this.param22.getId());
        Assertions.assertEquals((long)1L, (long)refParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getListValue()) && this.originalListValue.equals(parameter.getListValue().getId())).count());
        this.parameterService.set(this.ds_11.getId(), this.attr12.getId(), null, null, null, this.newListValue);
        refParameter = (Parameter)this.parameterService.get(this.param22.getId());
        Assertions.assertEquals((long)1L, (long)refParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getListValue()) && this.newListValue.equals(parameter.getListValue().getId())).count());
    }

    @Test
    public void deleteListValues_deleteLastListValueInParentListParameter_listValueInChildParameterHasEmptyValue() {
        Parameter refParameter = (Parameter)this.parameterService.get(this.param22.getId());
        Assertions.assertEquals((long)1L, (long)refParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getListValue()) && this.originalListValue.equals(parameter.getListValue().getId())).count());
        this.attributeService.deleteListValues(this.attr12.getId(), Arrays.asList(this.originalListValue, this.newListValue));
        refParameter = (Parameter)this.parameterService.get(this.param22.getId());
        Assertions.assertEquals((long)0L, (long)refParameter.getDataSetReference().getParameters().stream().filter(parameter -> Objects.nonNull(parameter.getListValue()) && this.originalListValue.equals(parameter.getListValue().getId())).count());
    }

    @Test
    public void set_deleteOverlapListValueInChildParameter_overlapParameterShouldHasEmptyValue() {
        Parameter parameter = this.parameterService.set(this.ds_21.getId(), this.attr12.getId(), (List)ImmutableList.of((Object)this.attr22.getId()), null, null, this.originalListValue);
        this.ds_21 = (DataSet)this.dataSetService.get(this.ds_21.getId());
        Parameter actualListValue = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)this.ds_21, (UUID)this.attr12.getId(), (Collection)ImmutableList.of((Object)this.attr22.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)this.originalListValue, (Object)actualListValue.getListValue().getId());
        parameter = this.parameterService.set(this.ds_21.getId(), this.attr12.getId(), (List)ImmutableList.of((Object)this.attr22.getId()), null, null, null);
        Assertions.assertNull((Object)parameter.getListValue());
    }

    @Test
    public void testParameterIsCreatedByServiceAndHasValue() {
        Parameter simpleText = this.parameterService.create(this.ds_11.getId(), this.attr13.getId(), "SimpleText", null, null);
        Parameter parameter = (Parameter)this.parameterService.get(simpleText.getId());
        Assertions.assertNotNull((Object)parameter);
        this.parameterService.delete(parameter);
    }

    @Test
    public void testGetOrCreateParameterOverlap() {
        Parameter parameter = this.parameterService.getOrCreateOverlap(this.ds_11.getId(), this.attr11.getId(), Collections.singletonList(this.attr11.getId()));
        Assertions.assertNotNull((Object)parameter);
    }

    @Test
    public void set_setMultiplyParameterValue_newValueOfParameterInDB() {
        String value = "MULTIPLY " + UUID.randomUUID();
        Parameter parameter = this.parameterService.set(this.ds_11.getId(), this.attr11.getId(), null, value, null, null);
        Assertions.assertEquals((Object)value, (Object)parameter.getText());
    }

    @Test
    public void set_changeMultiplyParameterValue_newValueOfParameterInDB() {
        String value = "MULTIPLY " + UUID.randomUUID();
        this.parameterService.set(this.ds_11.getId(), this.attr11.getId(), null, value, null, null);
        value = "MULTIPLY " + UUID.randomUUID() + " " + UUID.randomUUID();
        Parameter parameter = this.parameterService.set(this.ds_11.getId(), this.attr11.getId(), null, value, null, null);
        Assertions.assertEquals((Object)value, (Object)parameter.getText());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.visibilityAreaService.delete(this.visibilityArea.getId());
    }
}

