/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.ListValueImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.utils.ExcelRowsReader;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.importexport.converters.ListAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class ListAttributeExportConverterTest {
    private static final String RESOURCES_PATH = "src/test/resources/exportToFile/";
    private static final String EXCEL_FILE = "DSL_LIST_ATTR.xlsx";
    private static final AttributeType attrType = AttributeType.LIST;
    private UUID datasetListId;
    private static DatasetListExportService datasetListExportService;

    @BeforeEach
    public void setUp() {
        DataSetListService dslService = (DataSetListService)Mockito.mock(DataSetListService.class);
        DataSetListImportExportFactory factory = (DataSetListImportExportFactory)Mockito.mock(DataSetListImportExportFactory.class);
        datasetListExportService = new DatasetListExportService(dslService, factory);
        DataSetListImpl dataSetList = new DataSetListImpl();
        this.datasetListId = UUID.randomUUID();
        dataSetList.setId(this.datasetListId);
        dataSetList.setName("DSL_LIST_ATTR");
        UiManDataSetList uiManDataSetList = new UiManDataSetList();
        uiManDataSetList.setSource((DataSetList)dataSetList);
        ArrayList<DataSetImpl> dataSets = new ArrayList<DataSetImpl>();
        ArrayList<UiManDataSet> uiManDataSets = new ArrayList<UiManDataSet>();
        DataSetImpl ds1 = new DataSetImpl();
        UUID ds1Id = UUID.randomUUID();
        MixInIdImpl mId1 = new MixInIdImpl(ds1Id);
        ds1.setMixInId((MixInId)mId1);
        ds1.setId(ds1Id);
        ds1.setName("DS1");
        UiManDataSet uds1 = new UiManDataSet();
        uds1.setSource((DataSet)ds1);
        DataSetImpl ds2 = new DataSetImpl();
        UUID ds2Id = UUID.randomUUID();
        MixInIdImpl mId2 = new MixInIdImpl(ds2Id);
        ds2.setMixInId((MixInId)mId2);
        ds2.setId(ds2Id);
        ds2.setName("DS2");
        UiManDataSet uds2 = new UiManDataSet();
        uds2.setSource((DataSet)ds2);
        dataSets.add(ds1);
        dataSets.add(ds2);
        dataSetList.setDataSets(dataSets);
        uiManDataSets.add(uds1);
        uiManDataSets.add(uds2);
        uiManDataSetList.setDataSets(uiManDataSets);
        AttributeImpl attribute = new AttributeImpl();
        attribute.setType(attrType);
        attribute.setName("List Attribute");
        UiManAttribute uiManAttribute = new UiManAttribute();
        uiManAttribute.setSource((Attribute)attribute);
        ListValueImpl listValue1 = new ListValueImpl();
        listValue1.setName("a");
        ParameterImpl parameter1 = new ParameterImpl();
        parameter1.setDataSet((DataSet)ds1);
        parameter1.setListValue((ListValue)listValue1);
        UiManParameter uiManParameter1 = new UiManParameter();
        uiManParameter1.setDataSet(ds1Id);
        uiManParameter1.setSource((Parameter)parameter1);
        uiManParameter1.setValue((Object)Objects.requireNonNull(parameter1.getListValue()).getName());
        ListValueImpl listValue2 = new ListValueImpl();
        listValue2.setName("b");
        ParameterImpl parameter2 = new ParameterImpl();
        parameter2.setDataSet((DataSet)ds2);
        parameter2.setListValue((ListValue)listValue2);
        UiManParameter uiManParameter2 = new UiManParameter();
        uiManParameter2.setDataSet(ds2Id);
        uiManParameter2.setSource((Parameter)parameter2);
        uiManParameter2.setValue((Object)Objects.requireNonNull(parameter2.getListValue()).getName());
        attribute.setParameters(Arrays.asList(parameter1, parameter2));
        dataSetList.setAttributes(Collections.singletonList(attribute));
        uiManAttribute.setParameters(Arrays.asList(uiManParameter1, uiManParameter2));
        uiManDataSetList.setAttributes(Collections.singletonList(uiManAttribute));
        Mockito.when((Object)dslService.getAsTree(this.datasetListId, false)).thenReturn((Object)uiManDataSetList);
        Mockito.when((Object)factory.getAttributeExportConverter((String)ArgumentMatchers.any())).thenReturn((Object)new ListAttributeExportConverter());
    }

    @Test
    public void datasetListExportService_mapListAttributeToRow_returnDocumentWithEqualStructure() {
        File erFile = new File("src/test/resources/exportToFile/DSL_LIST_ATTR.xlsx");
        File arFile = datasetListExportService.exportDataSetList(this.datasetListId);
        List erRows = ExcelRowsReader.read((File)erFile).collect(Collectors.toList());
        List arRows = ExcelRowsReader.read((File)arFile).collect(Collectors.toList());
        Assertions.assertEquals(erRows, arRows);
    }
}

