/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.IdentifiedCache;
import org.qubership.atp.dataset.db.utils.IdentifiedCacheDelegate;
import org.qubership.atp.dataset.db.utils.WeakIdentifiedCache;
import org.qubership.atp.dataset.model.Identified;
import org.springframework.stereotype.Repository;

@Repository
public class CacheRepository
extends IdentifiedCacheDelegate {
    public static final IdentifiedCache DISABLED = new IdentifiedCache(){

        @Override
        @Nonnull
        public <T extends Identified> T computeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
            return (T)((Identified)Preconditions.checkNotNull((Object)((Identified)sourceFunc.apply(id)), (String)"[%s] with id [%s] is not provided by [%s]", type, (Object)id, sourceFunc));
        }

        @Override
        @Nullable
        public <T extends Identified> T tryComputeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
            return (T)((Identified)sourceFunc.apply(id));
        }

        @Override
        @Nullable
        public <T extends Identified> T getIfPresent(@Nonnull Class<T> type, @Nonnull UUID id) {
            return null;
        }

        @Override
        public <T extends Identified> void put(@Nonnull Class<T> type, @Nonnull T identified) {
        }

        @Override
        public void clear() {
        }
    };
    private final ThreadLocal<CacheSwitch> caches = ThreadLocal.withInitial(() -> new CacheSwitch());

    @Override
    @Nonnull
    public IdentifiedCache getCache() {
        return this.caches.get().cache;
    }

    public boolean isCacheEnabled() {
        return this.caches.get().isEnabled();
    }

    public void enableCache() {
        this.caches.get().enable();
    }

    public void disableCache() {
        this.caches.get().disable();
    }

    private static class CacheSwitch {
        IdentifiedCache cache = DISABLED;
        private int usages = -1;

        private CacheSwitch() {
        }

        public void enable() {
            if (++this.usages == 0) {
                this.cache = new WeakIdentifiedCache();
            }
        }

        public void disable() {
            if (--this.usages == -1) {
                this.cache = DISABLED;
            }
        }

        public boolean isEnabled() {
            return this.usages > -1;
        }
    }
}

