/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.entities;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;

@Entity
@Table(name="parameter")
public class ParameterEntity
extends AbstractUuidBasedEntity {
    private static final long serialVersionUID = 5436974377291909573L;
    @Column(name="string")
    private String stringValue;
    @Column(name="file")
    private UUID fileValueId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dataset_id")
    private DataSetEntity dataSet;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="ds")
    private UUID dataSetReferenceId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="attribute_id")
    private AbstractAttributeEntity attribute;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="list")
    public ListValueEntity listValue;

    @Transient
    public UUID getDataSetId() {
        return this.dataSet.getId();
    }

    public String getParameterValueByType() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.listValue != null) {
            return this.listValue.getText();
        }
        if (this.dataSetReferenceId != null) {
            return this.dataSetReferenceId.toString();
        }
        if (this.fileValueId != null) {
            return this.getId().toString();
        }
        return null;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setFileValueId(UUID fileValueId) {
        this.fileValueId = fileValueId;
    }

    public void setDataSet(DataSetEntity dataSet) {
        this.dataSet = dataSet;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setDataSetReferenceId(UUID dataSetReferenceId) {
        this.dataSetReferenceId = dataSetReferenceId;
    }

    public void setAttribute(AbstractAttributeEntity attribute) {
        this.attribute = attribute;
    }

    public void setListValue(ListValueEntity listValue) {
        this.listValue = listValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public UUID getFileValueId() {
        return this.fileValueId;
    }

    public DataSetEntity getDataSet() {
        return this.dataSet;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public UUID getDataSetReferenceId() {
        return this.dataSetReferenceId;
    }

    public AbstractAttributeEntity getAttribute() {
        return this.attribute;
    }

    public ListValueEntity getListValue() {
        return this.listValue;
    }
}

