/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.args;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.Position;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.MacroArgFactory;
import org.qubership.atp.dataset.macros.args.MacroArgsFactory;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.args.SigValueSup;
import org.qubership.atp.dataset.macros.args.TextArg;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.VisibilityArea;

public class MacroArgFactoryImpl
implements MacroArgFactory {
    private final MacroArgsFactory delegate;
    private Position position;
    private String text;

    public MacroArgFactoryImpl(MacroArgsFactory delegate) {
        this.delegate = delegate;
    }

    private static Optional<Attribute> getAttribute(@Nonnull DataSetList dsl, @Nonnull String text) {
        return dsl.getAttributes().stream().filter(ds -> text.equals(ds.getName())).findAny();
    }

    public MacroArgFactoryImpl withText(Position position, String text) {
        this.position = position;
        this.text = text;
        return this;
    }

    @Override
    public TextArg.WithSignature text() {
        return this.delegate.text(this.position, this.text);
    }

    @Override
    public RefArg.Signature<DataSetList> dsl() {
        return this.delegate.dsl(this.position, this.text, DslByName.INSTANCE);
    }

    @Override
    public RefArg.Signature<DataSet> ds() {
        return this.delegate.ds(this.position, this.text, DsByName.INSTANCE);
    }

    @Override
    public RefArg.Signature<Attribute> attr() {
        return this.delegate.attr(this.position, this.text, AttrByName.INSTANCE);
    }

    private static class DslByName
    implements SigValueSup<DataSetList> {
        private static final DslByName INSTANCE = new DslByName();

        private DslByName() {
        }

        @Override
        @Nonnull
        public DataSetList get(@Nonnull List<? extends MacroArg> previousArgs, @Nonnull String text, @Nonnull VisibilityArea va, @Nonnull DataSetList contextDsl) throws Exception {
            Optional<DataSetList> byName = va.getDataSetLists().stream().filter(dsl -> text.equals(dsl.getName())).findAny();
            if (byName.isPresent()) {
                return byName.get();
            }
            throw new NoSuchElementException("No data set list found by name [" + text + "] in " + va);
        }

        public String toString() {
            return "DSL by name in context va";
        }
    }

    private static class DsByName
    implements SigValueSup<DataSet> {
        private static final DsByName INSTANCE = new DsByName();

        private DsByName() {
        }

        @Override
        @Nonnull
        public DataSet get(@Nonnull List<? extends MacroArg> previousArgs, @Nonnull String text, @Nonnull VisibilityArea contextVa, @Nonnull DataSetList contextDsl) throws Exception {
            Optional<DataSet> byName;
            DataSetList dsl = contextDsl;
            for (MacroArg arg : Lists.reverse(previousArgs)) {
                Optional<DataSetList> dslOpt = arg.asRef().flatMap(RefArg::asDsl).map(RefArg::get);
                if (!dslOpt.isPresent()) continue;
                dsl = dslOpt.get();
                break;
            }
            if ((byName = dsl.getDataSets().stream().filter(ds -> text.equals(ds.getName())).findAny()).isPresent()) {
                return byName.get();
            }
            throw new NoSuchElementException("No data set found by name [" + text + "] in " + dsl);
        }

        public String toString() {
            return "DS by name";
        }
    }

    private static class AttrByName
    implements SigValueSup<Attribute> {
        private static final AttrByName INSTANCE = new AttrByName();

        private AttrByName() {
        }

        @Override
        @Nonnull
        public Attribute get(@Nonnull List<? extends MacroArg> previousArgs, @Nonnull String text, @Nonnull VisibilityArea contextVa, @Nonnull DataSetList contextDsl) throws Exception {
            Optional result;
            DataSetList dsl = contextDsl;
            for (MacroArg arg : Lists.reverse(previousArgs)) {
                Optional<Attribute> attrOpt = arg.asRef().flatMap(RefArg::asAttr).map(RefArg::get);
                if (attrOpt.isPresent()) {
                    Attribute attr = attrOpt.get();
                    dsl = attr.getDataSetListReference();
                    if (dsl != null) break;
                    throw new EvalException("No attribute found by name [" + text + "] because dsl ref is not set in parent attribute" + attr);
                }
                Optional<DataSetList> dslOpt = arg.asRef().flatMap(RefArg::asDsl).map(RefArg::get);
                if (!dslOpt.isPresent()) continue;
                dsl = dslOpt.get();
                break;
            }
            if ((result = MacroArgFactoryImpl.getAttribute(dsl, text)).isPresent()) {
                return (Attribute)result.get();
            }
            throw new NoSuchElementException("No attribute found by name [" + text + "] in " + dsl);
        }

        public String toString() {
            return "ATTR by name";
        }
    }
}

