/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.args;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.Position;
import org.qubership.atp.dataset.macros.args.ArgSignature;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.args.SignatureArg;

public abstract class TextArg
implements MacroArg {
    protected final String value;

    public static NoSignature of(@Nonnull String text) {
        return new NoSignature(text);
    }

    private TextArg(@Nonnull String value) {
        this.value = value;
    }

    public static WithSignature of(@Nonnull Position position, @Nonnull String text) {
        return new WithSignature(position, text);
    }

    @Override
    public String getText() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static class NoSignature
    extends TextArg {
        private NoSignature(@Nonnull String value) {
            super(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoSignature textArg = (NoSignature)o;
            return Objects.equals(this.value, textArg.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public Optional<? extends RefArg<?>> asRef() {
            return Optional.empty();
        }

        @Override
        public Optional<? extends SignatureArg> asSignature() {
            return Optional.empty();
        }
    }

    public static class WithSignature
    extends TextArg
    implements ArgSignature,
    SignatureArg {
        protected final Position position;

        private WithSignature(@Nonnull Position position, @Nonnull String value) {
            super(value);
            this.position = position;
        }

        @Override
        @Nonnull
        public Position getPosition() {
            return this.position;
        }

        @Override
        @Nonnull
        public String getSource() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithSignature textArg = (WithSignature)o;
            return Objects.equals(this.value, textArg.value) && Objects.equals(this.position, textArg.position);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.position);
        }

        public Optional<RefArg.Signature<?>> asRef() {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public ArgSignature getSignature() {
            return this;
        }

        @Override
        public Optional<? extends SignatureArg> asSignature() {
            return Optional.of(this);
        }
    }
}

