/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.CreatedModified;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.LabelProvider;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.TestPlanProvider;
import org.qubership.atp.dataset.model.VisibilityArea;

@Schema
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=DataSetList.class)
public interface DataSetList
extends Identified,
Named,
LabelProvider,
TestPlanProvider,
CreatedModified {
    @Schema(description="parent", required=true)
    public VisibilityArea getVisibilityArea();

    public void setVisibilityArea(VisibilityArea var1);

    @ArraySchema
    public List<DataSet> getDataSets();

    public void setDataSets(List<DataSet> var1);

    @ArraySchema
    public List<Attribute> getAttributes();

    @Nonnull
    @JsonIgnore
    default public Collection<Attribute> getAttributes(@Nonnull AttributeType type) {
        return this.getAttributes().stream().filter(attr -> type == attr.getType()).collect(Collectors.toList());
    }

    public void setAttributes(List<Attribute> var1);
}

