/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.Parameter;

public class FlatDataImpl
implements Consumer<Identified> {
    private Collection<DataSetList> dataSetListLists;
    private Collection<DataSet> dataSets;
    private Collection<Attribute> attributes;
    private Collection<Parameter> parameters;
    private Collection<Label> labels;

    public Collection<DataSetList> getDataSetLists() {
        return this.dataSetListLists;
    }

    public void setDataSetLists(Collection<DataSetList> dataSetListLists) {
        this.dataSetListLists = dataSetListLists;
    }

    public Collection<DataSet> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(Collection<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Collection<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<Label> labels) {
        this.labels = labels;
    }

    @Override
    @JsonIgnore
    public void accept(@Nonnull Identified entry) {
        Preconditions.checkNotNull((Object)entry, (String)"[%s] could not contain nulls", (Object)this);
        Class<?> clazz = entry.getClass();
        if (Label.class.isAssignableFrom(clazz)) {
            this.fillEntry((Label)entry, this::getLabels, this::setLabels);
        } else if (Parameter.class.isAssignableFrom(clazz)) {
            this.fillEntry((Parameter)entry, this::getParameters, this::setParameters);
        } else if (Attribute.class.isAssignableFrom(clazz)) {
            this.fillEntry((Attribute)entry, this::getAttributes, this::setAttributes);
        } else if (DataSet.class.isAssignableFrom(clazz)) {
            this.fillEntry((DataSet)entry, this::getDataSets, this::setDataSets);
        } else if (DataSetList.class.isAssignableFrom(clazz)) {
            this.fillEntry((DataSetList)entry, this::getDataSetLists, this::setDataSetLists);
        } else {
            throw new IllegalArgumentException(String.format("[%s] is not designed to accept [%s]", this, clazz));
        }
    }

    @JsonIgnore
    private <T> void fillEntry(T entry, Supplier<Collection<T>> getter, Consumer<Collection<T>> setter) {
        ArrayList lst = getter.get();
        if (lst == null) {
            lst = Lists.newArrayList();
            setter.accept(lst);
        }
        lst.add(entry);
    }
}

