/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.impl;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.dataset.db.generated.QAttribute;
import org.qubership.atp.dataset.db.generated.QDataset;
import org.qubership.atp.dataset.db.generated.QDatasetlist;
import org.qubership.atp.dataset.db.generated.QParameter;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.model.ParameterOverlap;

public class TableResponse {
    private static final QParameter PARAM = new QParameter("PARAM");
    protected static final QDatasetlist DSL = new QDatasetlist("DSL");
    protected static final QDataset DS = new QDataset("DS");
    protected static final QAttribute ATTR = new QAttribute("ATTR");
    private UUID id;
    private UUID dslId;
    private String dslName;
    private UUID dsId;
    private String dsName;
    private UUID attributeId;
    private String attributeName;
    private UUID listValueId;
    private UUID ds;

    public static TableResponse fromParameterOverlap(ParameterOverlap overlap) {
        return new TableResponse(null, overlap.getDataSet().getDataSetList().getId(), overlap.getDataSet().getDataSetList().getName(), overlap.getDataSet().getId(), overlap.getDataSet().getName(), overlap.getAttribute().getId(), overlap.getAttribute().getName(), null, null);
    }

    public static TableResponse fromParameterTuple(Tuple row) {
        return new TableResponse((UUID)row.get(TableResponse.PARAM.id), (UUID)row.get(TableResponse.DSL.id), (String)row.get((Expression)TableResponse.DSL.name), (UUID)row.get(TableResponse.DS.id), (String)row.get((Expression)TableResponse.DS.name), (UUID)row.get(TableResponse.ATTR.id), (String)row.get((Expression)TableResponse.ATTR.name), (UUID)row.get(TableResponse.PARAM.list), (UUID)row.get(TableResponse.PARAM.ds));
    }

    public static TableResponse fromAttributeEntity(AttributeEntity entity) {
        DataSetListEntity dataSetList = entity.getDataSetList();
        boolean isDslPresent = Objects.nonNull(dataSetList);
        return new TableResponse(null, isDslPresent ? dataSetList.getId() : null, isDslPresent ? dataSetList.getName() : null, null, null, entity.getId(), entity.getName(), null, null);
    }

    public static TableResponse fromParameterEntity(ParameterEntity entity) {
        DataSetEntity dataSet = entity.getDataSet();
        boolean isDsPresent = Objects.nonNull(dataSet);
        DataSetListEntity dataSetList = isDsPresent ? dataSet.getDataSetList() : null;
        boolean isDslPresent = isDsPresent && Objects.nonNull(dataSetList);
        AbstractAttributeEntity attribute = entity.getAttribute();
        boolean isAttrPresent = Objects.nonNull(attribute);
        ListValueEntity listValue = entity.getListValue();
        boolean isListValuePresent = Objects.nonNull(listValue);
        return new TableResponse(entity.getId(), isDslPresent ? dataSetList.getId() : null, isDslPresent ? dataSetList.getName() : null, isDsPresent ? dataSet.getId() : null, isDsPresent ? dataSet.getName() : null, isAttrPresent ? attribute.getId() : null, isAttrPresent ? attribute.getName() : null, isListValuePresent ? listValue.getId() : null, isDsPresent ? entity.getDataSetReferenceId() : null);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getDslId() {
        return this.dslId;
    }

    public String getDslName() {
        return this.dslName;
    }

    public UUID getDsId() {
        return this.dsId;
    }

    public String getDsName() {
        return this.dsName;
    }

    public UUID getAttributeId() {
        return this.attributeId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public UUID getListValueId() {
        return this.listValueId;
    }

    public UUID getDs() {
        return this.ds;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setDslId(UUID dslId) {
        this.dslId = dslId;
    }

    public void setDslName(String dslName) {
        this.dslName = dslName;
    }

    public void setDsId(UUID dsId) {
        this.dsId = dsId;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public void setAttributeId(UUID attributeId) {
        this.attributeId = attributeId;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setListValueId(UUID listValueId) {
        this.listValueId = listValueId;
    }

    public void setDs(UUID ds) {
        this.ds = ds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableResponse)) {
            return false;
        }
        TableResponse other = (TableResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$dslId = this.getDslId();
        UUID other$dslId = other.getDslId();
        if (this$dslId == null ? other$dslId != null : !((Object)this$dslId).equals(other$dslId)) {
            return false;
        }
        String this$dslName = this.getDslName();
        String other$dslName = other.getDslName();
        if (this$dslName == null ? other$dslName != null : !this$dslName.equals(other$dslName)) {
            return false;
        }
        UUID this$dsId = this.getDsId();
        UUID other$dsId = other.getDsId();
        if (this$dsId == null ? other$dsId != null : !((Object)this$dsId).equals(other$dsId)) {
            return false;
        }
        String this$dsName = this.getDsName();
        String other$dsName = other.getDsName();
        if (this$dsName == null ? other$dsName != null : !this$dsName.equals(other$dsName)) {
            return false;
        }
        UUID this$attributeId = this.getAttributeId();
        UUID other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        UUID this$listValueId = this.getListValueId();
        UUID other$listValueId = other.getListValueId();
        if (this$listValueId == null ? other$listValueId != null : !((Object)this$listValueId).equals(other$listValueId)) {
            return false;
        }
        UUID this$ds = this.getDs();
        UUID other$ds = other.getDs();
        return !(this$ds == null ? other$ds != null : !((Object)this$ds).equals(other$ds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $dslId = this.getDslId();
        result = result * 59 + ($dslId == null ? 43 : ((Object)$dslId).hashCode());
        String $dslName = this.getDslName();
        result = result * 59 + ($dslName == null ? 43 : $dslName.hashCode());
        UUID $dsId = this.getDsId();
        result = result * 59 + ($dsId == null ? 43 : ((Object)$dsId).hashCode());
        String $dsName = this.getDsName();
        result = result * 59 + ($dsName == null ? 43 : $dsName.hashCode());
        UUID $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        UUID $listValueId = this.getListValueId();
        result = result * 59 + ($listValueId == null ? 43 : ((Object)$listValueId).hashCode());
        UUID $ds = this.getDs();
        result = result * 59 + ($ds == null ? 43 : ((Object)$ds).hashCode());
        return result;
    }

    public String toString() {
        return "TableResponse(id=" + this.getId() + ", dslId=" + this.getDslId() + ", dslName=" + this.getDslName() + ", dsId=" + this.getDsId() + ", dsName=" + this.getDsName() + ", attributeId=" + this.getAttributeId() + ", attributeName=" + this.getAttributeName() + ", listValueId=" + this.getListValueId() + ", ds=" + this.getDs() + ")";
    }

    public TableResponse(UUID id, UUID dslId, String dslName, UUID dsId, String dsName, UUID attributeId, String attributeName, UUID listValueId, UUID ds) {
        this.id = id;
        this.dslId = dslId;
        this.dslName = dslName;
        this.dsId = dsId;
        this.dsName = dsName;
        this.attributeId = attributeId;
        this.attributeName = attributeName;
        this.listValueId = listValueId;
        this.ds = ds;
    }

    public TableResponse() {
    }
}

