/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.args.SignatureArg;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.impl.reference.ReferenceAliasType;
import org.qubership.atp.dataset.macros.processor.RefAliasContext;
import org.qubership.atp.dataset.macros.processor.RefAliasProcessor;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.IdentifiedService;
import org.qubership.atp.dataset.service.direct.UnwrapStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliasWrapperServiceImpl
implements AliasWrapperService {
    private static final Logger log = LoggerFactory.getLogger(AliasWrapperServiceImpl.class);
    private final UnWrap unwrap = new UnWrap();
    private final MacroRegistry macroRegistry;
    private final Provider<DataSetListService> dslServiceProvider;
    private final Provider<DataSetService> dsServiceProvider;
    private final Provider<AttributeService> attrServiceProvider;

    private static void processRefs(ArgsParser.Result args, StringBuilder toReplaceIn, RefAliasContext context, Replacer replacer) throws CtxEvalException {
        boolean replaced;
        String source = args.toString();
        int argsStartPosition = context.offset - args.toString().length();
        try {
            replaced = replacer.replace(args);
        }
        catch (Exception e) {
            throw new CtxEvalException("Can not process arguments: " + args, context, (Throwable)e);
        }
        if (replaced) {
            String replacement = args.toString();
            toReplaceIn.replace(argsStartPosition + context.replacementDiff, context.offset + context.replacementDiff, replacement);
            context.replacementDiff += replacement.length() - source.length();
        }
    }

    private String process(@Nonnull String text, final @Nonnull Replacer replacer) throws EvalException {
        final StringBuilder result = new StringBuilder(text);
        new RefAliasProcessor(this.macroRegistry, text){

            @Override
            protected void notifyRefsFound(RefAliasContext context, ArgsParser.Result args) throws CtxEvalException {
                AliasWrapperServiceImpl.processRefs(args, result, context, replacer);
            }
        }.evaluateAll();
        return result.toString();
    }

    @Override
    public String wrapToAlias(String text, VisibilityArea visibilityArea, DataSetList dsl) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        try {
            return this.process(text, new Wrap(visibilityArea, dsl));
        }
        catch (Exception e) {
            log.warn("Failed wrapping to alias: " + text, (Throwable)e);
            return text;
        }
    }

    @Override
    public <T extends Identified & Named> UnwrapStatus unWrapAlias(RefArg.Signature<T> ref) {
        Object value;
        UUID uuid;
        String source = ref.getText();
        try {
            uuid = UUID.fromString(source);
        }
        catch (IllegalArgumentException e) {
            return UnwrapStatus.SKIPPED;
        }
        try {
            value = this.getAlias(ref.getType(), uuid);
        }
        catch (IllegalArgumentException e) {
            return UnwrapStatus.UNUSED;
        }
        if (value == null) {
            return UnwrapStatus.SKIPPED;
        }
        ref.resolve(value);
        ref.setText(((Named)value).getName());
        return UnwrapStatus.UNWRAPPED;
    }

    @Override
    public String unWrapAlias(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        try {
            return this.process(text, this.unwrap);
        }
        catch (Exception e) {
            log.error("Failed unwrapping from alias: " + text, (Throwable)e);
            return text;
        }
    }

    @Nonnull
    private UUID createAlias(@Nonnull ReferenceAliasType type, @Nonnull UUID objectId) {
        return objectId;
    }

    @Nullable
    private <T extends Identified & Named> T getAlias(@Nonnull ReferenceAliasType<T> type, @Nonnull UUID objectId) {
        T result = this.getAliasObject(type, objectId);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Nullable
    private <T extends Identified & Named> T getAliasObject(@Nonnull ReferenceAliasType<T> type, @Nonnull UUID objectId) {
        IdentifiedService<T> service = type.chooseService((IdentifiedService)this.dslServiceProvider.get(), (IdentifiedService)this.dsServiceProvider.get(), (IdentifiedService)this.attrServiceProvider.get());
        return service.get(objectId);
    }

    public AliasWrapperServiceImpl(MacroRegistry macroRegistry, Provider<DataSetListService> dslServiceProvider, Provider<DataSetService> dsServiceProvider, Provider<AttributeService> attrServiceProvider) {
        this.macroRegistry = macroRegistry;
        this.dslServiceProvider = dslServiceProvider;
        this.dsServiceProvider = dsServiceProvider;
        this.attrServiceProvider = attrServiceProvider;
    }

    private static interface Replacer {
        public boolean replace(ArgsParser.Result var1) throws Exception;
    }

    private class Wrap
    implements Replacer {
        private final VisibilityArea va;
        private final DataSetList dsl;

        private Wrap(VisibilityArea va, DataSetList dsl) {
            this.va = va;
            this.dsl = dsl;
        }

        private void resolve(@Nonnull List<? extends MacroArg> previousArgs, RefArg.Signature<?> source) throws Exception {
            Object instance = source.resolve(previousArgs, this.va, this.dsl);
            UUID result = AliasWrapperServiceImpl.this.createAlias(source.getType(), instance.getId());
            source.setText(result.toString());
        }

        @Override
        public boolean replace(ArgsParser.Result args) throws Exception {
            boolean changed = false;
            List<SignatureArg> toResolve = args.getParsed();
            for (int i = 0; i < toResolve.size(); ++i) {
                Optional<RefArg.Signature<?>> signature = toResolve.get(i).asRef();
                if (!signature.isPresent()) continue;
                this.resolve(toResolve.subList(0, i), signature.get());
                changed = true;
            }
            return changed;
        }
    }

    private class UnWrap
    implements Replacer {
        private UnWrap() {
        }

        @Override
        public boolean replace(ArgsParser.Result args) throws Exception {
            boolean changed = false;
            Iterator<SignatureArg> argsIter = args.getParsed().iterator();
            while (argsIter.hasNext()) {
                SignatureArg macroArg = argsIter.next();
                Optional<RefArg.Signature<?>> signature = macroArg.asRef();
                if (!signature.isPresent()) continue;
                UnwrapStatus unwrapStatus = AliasWrapperServiceImpl.this.unWrapAlias(signature.get());
                switch (unwrapStatus) {
                    case UNWRAPPED: {
                        changed = true;
                        break;
                    }
                    case UNUSED: {
                        argsIter.remove();
                        break;
                    }
                }
            }
            return changed;
        }
    }
}

