/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.exception.attribute.AttributeDslCopyException;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsRequest;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsResponse;
import org.qubership.atp.dataset.model.enums.CompareStatus;
import org.qubership.atp.dataset.model.enums.DetailedComparisonStatus;
import org.qubership.atp.dataset.model.impl.ComparedAttribute;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.CompareService;
import org.qubership.atp.dataset.service.direct.EncryptionService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

@Service
public class CompareDatasetServiceImpl
implements CompareService {
    private static final Logger log = LoggerFactory.getLogger(CompareDatasetServiceImpl.class);
    private final ModelsProvider modelsProvider;
    private final EncryptionService encryptionService;

    @Override
    public CompareStatus compare(UUID leftDsCaseId, UUID rightDsCaseId) {
        boolean hasDiff;
        int i;
        int countAttrRight;
        log.info("Started compare dataset {} with {}", (Object)leftDsCaseId, (Object)rightDsCaseId);
        if (leftDsCaseId.equals(rightDsCaseId)) {
            return CompareStatus.OK;
        }
        List<Parameter> leftParameters = this.modelsProvider.getSortedParameterByDataSetId(leftDsCaseId);
        List<Parameter> rightParameters = this.modelsProvider.getSortedParameterByDataSetId(rightDsCaseId);
        List<Parameter> leftOverlapParameters = this.modelsProvider.getSortedOverlapParametersByDataSetId(leftDsCaseId);
        List<Parameter> rightOverlapParameters = this.modelsProvider.getSortedOverlapParametersByDataSetId(rightDsCaseId);
        int countAttrLeft = this.modelsProvider.countAttributes(leftDsCaseId);
        if (countAttrLeft != (countAttrRight = this.modelsProvider.countAttributes(rightDsCaseId))) {
            return CompareStatus.WARNING;
        }
        if (rightParameters.size() != leftParameters.size()) {
            return CompareStatus.WARNING;
        }
        if (rightOverlapParameters.size() != leftOverlapParameters.size()) {
            return CompareStatus.WARNING;
        }
        for (i = 0; i < leftParameters.size(); ++i) {
            Parameter rightParameter;
            Parameter leftParameter = leftParameters.get(i);
            hasDiff = this.hasParameterDiff(leftParameter, rightParameter = rightParameters.get(i));
            if (!hasDiff) continue;
            return CompareStatus.WARNING;
        }
        for (i = 0; i < leftOverlapParameters.size(); ++i) {
            Parameter rightOverlapParameter;
            Parameter leftOverlapParameter = leftOverlapParameters.get(i);
            hasDiff = this.hasParameterDiff(leftOverlapParameter, rightOverlapParameter = rightOverlapParameters.get(i));
            if (!hasDiff) continue;
            return CompareStatus.WARNING;
        }
        log.info("Finished compare dataset {} with {}", (Object)leftDsCaseId, (Object)rightDsCaseId);
        return CompareStatus.OK;
    }

    private boolean hasParameterDiff(Parameter leftParameter, Parameter rightParameter) {
        Attribute leftAttribute = leftParameter.getAttribute();
        Attribute rightAttribute = rightParameter.getAttribute();
        if (leftParameter.isOverlap()) {
            leftAttribute = leftParameter.getAttributeKey().getAttribute();
            rightAttribute = leftParameter.getAttributeKey().getAttribute();
        }
        AttributeTypeName attrTypeLeft = leftAttribute.getAttributeType();
        AttributeTypeName attrTypeRight = rightAttribute.getAttributeType();
        if (!leftAttribute.getName().equals(rightAttribute.getName())) {
            return true;
        }
        if (attrTypeLeft != attrTypeRight) {
            return true;
        }
        switch (attrTypeLeft) {
            case CHANGE: 
            case TEXT: {
                return this.hasTextDiff(leftParameter, rightParameter);
            }
            case ENCRYPTED: {
                return this.hasEncryptDiff(leftParameter, rightParameter);
            }
            case DSL: {
                return this.hasDslDiff(leftParameter, rightParameter);
            }
            case LIST: {
                return this.hasListDiff(leftParameter, rightParameter);
            }
            case FILE: {
                return this.hasFileDiff(leftParameter, rightParameter);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)attrTypeLeft));
    }

    private DetailedComparisonStatus compareParameters(Parameter leftParameter, Parameter rightParameter) {
        AttributeTypeName attrTypeRight;
        AttributeTypeName attrTypeLeft;
        log.debug("Compare parameters (leftParameterId: {}, rightParameterId: {})", (Object)leftParameter.getId(), (Object)rightParameter.getId());
        if (leftParameter.isOverlap() && rightParameter.isOverlap()) {
            attrTypeLeft = leftParameter.getAttributeKey().getAttributeType();
            attrTypeRight = rightParameter.getAttributeKey().getAttributeType();
        } else {
            attrTypeLeft = leftParameter.getAttribute().getAttributeType();
            attrTypeRight = rightParameter.getAttribute().getAttributeType();
        }
        if (attrTypeLeft != attrTypeRight) {
            log.trace("INCOMPATIBLE TYPES (leftAttrType: {}, rightAttrType: {})", (Object)attrTypeLeft, (Object)attrTypeRight);
            return DetailedComparisonStatus.INCOMPATIBLE_TYPES;
        }
        log.trace("Compare parameters by attribute type (AttrType: {})", (Object)attrTypeLeft);
        switch (attrTypeLeft) {
            case CHANGE: 
            case TEXT: {
                return this.hasTextDiff(leftParameter, rightParameter) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.EQUAL;
            }
            case ENCRYPTED: {
                return this.hasEncryptDiff(leftParameter, rightParameter) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.EQUAL;
            }
            case DSL: {
                return this.hasDslDiff(leftParameter, rightParameter) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.EQUAL;
            }
            case LIST: {
                return this.hasListDiff(leftParameter, rightParameter) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.EQUAL;
            }
            case FILE: {
                return this.hasFileDiff(leftParameter, rightParameter) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.EQUAL;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)attrTypeLeft));
    }

    private boolean hasTextDiff(Parameter leftParameter, Parameter rightParameter) {
        return !leftParameter.getStringValue().equals(rightParameter.getStringValue());
    }

    private boolean hasEncryptDiff(Parameter leftParameter, Parameter rightParameter) {
        String leftValue = leftParameter.getStringValue();
        String rightValue = rightParameter.getStringValue();
        if (Objects.isNull(leftValue) || Objects.isNull(rightValue)) {
            return !Objects.isNull(leftValue) || !Objects.isNull(rightValue);
        }
        try {
            return !this.encryptionService.decrypt(leftValue).equals(this.encryptionService.decrypt(rightValue));
        }
        catch (AtpDecryptException ex) {
            throw new RuntimeException("Failed to decrypt encrypted parameter", ex);
        }
    }

    private boolean hasFileDiff(Parameter leftParameter, Parameter rightParameter) {
        FileData leftFile = leftParameter.getFileDataIfExist();
        FileData rightFile = rightParameter.getFileDataIfExist();
        if (leftFile != null && rightFile != null) {
            return !leftFile.getFileName().equals(rightFile.getFileName());
        }
        return leftFile != null || rightFile != null;
    }

    private boolean hasListDiff(Parameter leftParameter, Parameter rightParameter) {
        ListValueEntity leftList = leftParameter.getListValue();
        ListValueEntity rightList = rightParameter.getListValue();
        if (leftList == null && rightList == null) {
            return false;
        }
        if (leftList != null && rightList != null) {
            return !leftList.getText().equals(rightList.getText());
        }
        return true;
    }

    private boolean hasDslDiff(Parameter leftParameter, Parameter rightParameter) {
        return !leftParameter.getDataSetReferenceId().equals(rightParameter.getDataSetReferenceId());
    }

    @Override
    public DetailedComparisonDsResponse detailedComparison(DetailedComparisonDsRequest request) {
        log.debug("Detailed comparison (request: {})", (Object)request);
        UUID leftDsId = request.getLeftDatasetId();
        UUID rightDsId = request.getRightDatasetId();
        DataSet leftDs = this.modelsProvider.getDataSetById(leftDsId);
        DataSet rightDs = this.modelsProvider.getDataSetById(rightDsId);
        List<Parameter> parameters = leftDs.getParameters();
        parameters.addAll(rightDs.getParameters());
        Map groupedParameters = parameters.stream().filter(p -> {
            Attribute attr = p.getAttribute();
            return Objects.nonNull(attr) && !((AttributeEntity)attr.getEntity()).isAttributeKey();
        }).collect(Collectors.groupingBy(p -> p.getAttribute().getName(), HashMap::new, Collectors.toList()));
        Map groupedParametersOverlap = parameters.stream().filter(p -> {
            AttributeKey attr = p.getAttributeKey();
            return Objects.nonNull(attr) && ((AttributeKeyEntity)attr.getEntity()).isAttributeKey();
        }).collect(Collectors.groupingBy(p -> p.getAttributeKey().getPathNames() + "." + p.getAttributeKey().getAttribute().getName(), HashMap::new, Collectors.toList()));
        List<ComparedAttribute> comparedAttributes = this.compareAttributes(leftDsId, rightDsId, groupedParameters);
        comparedAttributes.addAll(this.compareAttributes(leftDsId, rightDsId, groupedParametersOverlap));
        List<Attribute> notUsedAttributes = this.modelsProvider.getNotUsedAttributesByDatasetId(leftDsId);
        notUsedAttributes.addAll(this.modelsProvider.getNotUsedAttributesByDatasetId(rightDsId));
        Map groupedNotUsedAttributes = notUsedAttributes.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Attribute::getName, HashMap::new, Collectors.toList()));
        comparedAttributes.addAll(this.compareUnusedAttributes(groupedNotUsedAttributes));
        comparedAttributes.sort(Comparator.comparing(ComparedAttribute::getAttributeName));
        PageRequest pageRequest = PageRequest.of((int)request.getPage(), (int)request.getSize());
        int totalSize = comparedAttributes.size();
        int start = Math.min((int)pageRequest.getOffset(), totalSize);
        int end = Math.min(start + pageRequest.getPageSize(), totalSize);
        return new DetailedComparisonDsResponse(leftDsId, leftDs.getName(), leftDs.getDataSetList().getName(), rightDsId, rightDs.getName(), rightDs.getDataSetList().getName(), totalSize, comparedAttributes.subList(start, end));
    }

    private List<ComparedAttribute> compareAttributes(UUID leftDsId, UUID rightDsId, Map<String, List<Parameter>> groupedParameters) {
        ArrayList<ComparedAttribute> comparedAttributes = new ArrayList<ComparedAttribute>();
        for (Map.Entry<String, List<Parameter>> entry : groupedParameters.entrySet()) {
            String attributeName = entry.getKey();
            List<Parameter> value = entry.getValue();
            if (value.size() > 2) {
                log.error("Found more than two parameters related to attributes with same name (attributeName {}, leftDatasetId {}, rightDatasetId {})", new Object[]{attributeName, leftDsId, rightDsId});
                continue;
            }
            if (value.size() == 2) {
                comparedAttributes.add(this.getComparedAttribute(value.get(0), value.get(1), attributeName));
                continue;
            }
            ComparedAttribute comparedAttribute = this.getComparedAttribute(leftDsId, rightDsId, value.get(0), attributeName);
            comparedAttributes.add(comparedAttribute);
        }
        return comparedAttributes;
    }

    private List<ComparedAttribute> compareUnusedAttributes(Map<String, List<Attribute>> notUsedAttribute) {
        ArrayList<ComparedAttribute> comparedAttributes = new ArrayList<ComparedAttribute>();
        for (Map.Entry<String, List<Attribute>> entry : notUsedAttribute.entrySet()) {
            List<Attribute> attributes = entry.getValue();
            if (attributes.size() != 2) continue;
            Attribute leftAttribute = attributes.get(0);
            Attribute rightAttribute = attributes.get(1);
            comparedAttributes.add(new ComparedAttribute(leftAttribute.getId(), null, leftAttribute.getAttributeType(), false, rightAttribute.getId(), null, rightAttribute.getAttributeType(), false, leftAttribute.getName(), leftAttribute.getAttributeType().equals((Object)rightAttribute.getAttributeType()) ? DetailedComparisonStatus.EQUAL : DetailedComparisonStatus.INCOMPATIBLE_TYPES));
        }
        return comparedAttributes;
    }

    private ComparedAttribute getComparedAttribute(Parameter leftParameter, Parameter rightParameter, String attributeName) {
        log.debug("Create comparedAttribute for (leftParameterId: {}, rightParameterId: {}, attributeName: {})", new Object[]{leftParameter.getId(), rightParameter.getId(), attributeName});
        if (leftParameter.isOverlap() || rightParameter.isOverlap()) {
            AttributeKey leftAttr = leftParameter.getAttributeKey();
            AttributeKey rightAttr = rightParameter.getAttributeKey();
            return new ComparedAttribute(leftAttr.getId(), leftParameter.getParameterValueByTypeAsObject(), leftAttr.getAttributeType(), leftParameter.isOverlap(), rightAttr.getId(), rightParameter.getParameterValueByTypeAsObject(), rightAttr.getAttributeType(), rightParameter.isOverlap(), attributeName, this.compareParameters(leftParameter, rightParameter));
        }
        return new ComparedAttribute(leftParameter.getAttributeId(), leftParameter.getParameterValueByTypeAsObject(), leftParameter.getAttribute().getAttributeType(), leftParameter.isOverlap(), rightParameter.getAttributeId(), rightParameter.getParameterValueByTypeAsObject(), rightParameter.getAttribute().getAttributeType(), rightParameter.isOverlap(), attributeName, this.compareParameters(leftParameter, rightParameter));
    }

    private ComparedAttribute getComparedAttribute(UUID leftDsId, UUID rightDsId, Parameter parameter, String attributeName) {
        UUID attributeId = parameter.getAttributeId();
        Object parameterValue = parameter.getParameterValueByTypeAsObject();
        UUID parameterDatasetId = parameter.getDataSetId();
        AttributeTypeName attrType = parameter.isOverlap() ? parameter.getAttributeKey().getAttributeType() : parameter.getAttribute().getAttributeType();
        ComparedAttribute comparedAttribute = new ComparedAttribute();
        if (leftDsId.equals(parameterDatasetId)) {
            log.debug("Create comparedAttribute for (leftParameterId: {}, rightParameterId: {}, attributeName: {})", new Object[]{parameter.getId(), null, attributeName});
            comparedAttribute.setLeftAttributeId(attributeId);
            comparedAttribute.setLeftAttributeValue(parameterValue);
            comparedAttribute.setLeftAttributeType(attrType);
            comparedAttribute.setLeftAttributeIsOverlap(parameter.isOverlap());
        }
        if (rightDsId.equals(parameterDatasetId)) {
            log.debug("Create comparedAttribute for (leftParameterId: {}, rightParameterId: {}, attributeName: {})", new Object[]{null, parameter.getId(), attributeName});
            comparedAttribute.setRightAttributeId(attributeId);
            comparedAttribute.setRightAttributeValue(parameterValue);
            comparedAttribute.setRightAttributeType(attrType);
            comparedAttribute.setRightAttributeIsOverlap(parameter.isOverlap());
        }
        comparedAttribute.setAttributeName(attributeName);
        comparedAttribute.setStatus(DetailedComparisonStatus.NOT_EQUAL);
        return comparedAttribute;
    }

    @Override
    public boolean isAttributesComparable(UUID leftAttrId, UUID rightAttrId) {
        AttributeTypeName rightAttributeType;
        AttributeTypeName leftAttributeType;
        if (Objects.isNull(leftAttrId) || Objects.isNull(rightAttrId)) {
            return false;
        }
        if (this.modelsProvider.getAttributeById(leftAttrId) != null) {
            leftAttributeType = this.modelsProvider.getAttributeById(leftAttrId).getAttributeType();
            rightAttributeType = this.modelsProvider.getAttributeById(rightAttrId).getAttributeType();
            if (this.modelsProvider.isDslDifferentAttributes(leftAttrId, rightAttrId)) {
                throw new AttributeDslCopyException();
            }
        } else {
            leftAttributeType = this.modelsProvider.getAttributeKeyById(leftAttrId).getAttributeType();
            rightAttributeType = this.modelsProvider.getAttributeKeyById(rightAttrId).getAttributeType();
        }
        return leftAttributeType.equals((Object)rightAttributeType);
    }

    @Override
    public DetailedComparisonStatus compareAttributeValues(UUID leftDatasetId, UUID rightDataSetId, UUID leftAttributeId, UUID rightAttributeId) {
        Parameter leftParameter = this.modelsProvider.getParameterByAttributeIdAndDataSetId(leftAttributeId, leftDatasetId);
        Parameter rightParameter = this.modelsProvider.getParameterByAttributeIdAndDataSetId(rightAttributeId, rightDataSetId);
        if (Objects.isNull(leftParameter) || Objects.isNull(rightParameter)) {
            if (Objects.isNull(leftParameter) && Objects.isNull(rightParameter)) {
                return this.isAttributesComparable(leftAttributeId, rightAttributeId) ? DetailedComparisonStatus.EQUAL : DetailedComparisonStatus.INCOMPATIBLE_TYPES;
            }
            return this.isAttributesComparable(leftAttributeId, rightAttributeId) ? DetailedComparisonStatus.NOT_EQUAL : DetailedComparisonStatus.INCOMPATIBLE_TYPES;
        }
        return this.compareParameters(leftParameter, rightParameter);
    }

    public CompareDatasetServiceImpl(ModelsProvider modelsProvider, EncryptionService encryptionService) {
        this.modelsProvider = modelsProvider;
        this.encryptionService = encryptionService;
    }
}

