/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetListTreeRepository;
import org.qubership.atp.dataset.db.TestPlanRepository;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListAndTestPlanException;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListExistsException;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListNotFoundException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.api.saga.requests.RevertRequest;
import org.qubership.atp.dataset.model.impl.FlatDataImpl;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.rest.PaginationResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.AffectedDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSetListServiceImpl
implements DataSetListService {
    private static final Logger log = LoggerFactory.getLogger(DataSetListServiceImpl.class);
    private final DataSetService dsService;
    private final DataSetListRepository repo;
    private final EvaluationService evaluationService;
    private final AttributeService attributeService;
    private final DataSetListTreeRepository dslTreeRepo;
    private final TestPlanRepository testPlanRepo;
    private final Provider<UserInfo> userInfoProvider;
    private final DataSetListSnapshotService dataSetListSnapshotService;
    private final ModelsProvider modelsProvider;
    private final MacrosCalculator macrosCalculator;
    private final MacroContextService macroContextService;
    private final JpaDataSetListService dataSetListService;
    private final MacrosFeignClient macrosFeignClient;
    private final DataSetParameterProvider dataSetParameterProvider;
    private final ClearCacheService clearCacheService;
    @Value(value="${feign.atp.macros.url}")
    private String macroFeignUrl;
    @Value(value="${feign.atp.macros.route}")
    private String macroFeignRoute;

    @Override
    @Nullable
    public FlatDataImpl getAsFlat(UUID id, boolean evaluate) {
        DataSetList result = this.get(id);
        if (result == null) {
            return null;
        }
        FlatDataImpl flatData = Utils.doFlatData(result);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, true);){
            flatData.getParameters().forEach(param -> param.setText(evaluator.apply((Parameter)param).map(Object::toString).orElse("")));
        }
        return flatData;
    }

    @Override
    @Nullable
    public UiManDataSetList getAsTree(UUID id, boolean evaluate, @Nullable Collection<UUID> dataSetsFilter, @Nullable Collection<UUID> attributesFilter, Integer startIndex, Integer endIndex, boolean isSortEnabled, boolean expandAll) {
        DataSetList result = this.dslTreeRepo.getEagerById(id, dataSetsFilter, attributesFilter, startIndex, endIndex, isSortEnabled);
        if (result == null) {
            return null;
        }
        if (!(Strings.isNullOrEmpty((String)this.macroFeignUrl) && Strings.isNullOrEmpty((String)this.macroFeignRoute) || !evaluate)) {
            try (DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, true);){
                MacroContext macroContext = this.prepareMacros(result);
                UiManDataSetList dataSetList = Utils.doUiDs(result, macroContext, this.dataSetParameterProvider, evaluator, evaluate, expandAll);
                this.sortTable(isSortEnabled, dataSetList);
                UiManDataSetList uiManDataSetList = dataSetList;
                return uiManDataSetList;
            }
        }
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, true);){
            UiManDataSetList dataSetList = Utils.doUiDs(result, evaluator, expandAll);
            this.sortTable(isSortEnabled, dataSetList);
            UiManDataSetList uiManDataSetList = dataSetList;
            return uiManDataSetList;
        }
    }

    @Override
    public UiManDataSetList getAsTree(UUID id, boolean evaluate) {
        return this.getAsTree(id, evaluate, null, null, null, null, false, true);
    }

    @Override
    public UiManDataSetList getAsTree(UUID id, boolean evaluate, Collection<UUID> dataSetsFilter, boolean isSortEnabled) {
        return this.getAsTree(id, evaluate, dataSetsFilter, null, null, null, isSortEnabled, true);
    }

    private MacroContext prepareMacros(DataSetList dataSetList) {
        MacroContext macroContext = new MacroContext();
        macroContext.setMacroContextService(this.macroContextService);
        macroContext.setMacrosCalculator(this.macrosCalculator);
        UUID visibilityArea = dataSetList.getVisibilityArea().getId();
        List macrosDtoList = (List)this.macrosFeignClient.findNonTechnicalMacrosByProject(visibilityArea).getBody();
        if (Objects.nonNull(macrosDtoList)) {
            log.info("macrosDtoList size is  {}", (Object)macrosDtoList.size());
        }
        List macros = new MacrosDtoConvertService().convertList(macrosDtoList, Macros.class);
        macroContext.setMacros(macros);
        return macroContext;
    }

    private void sortTable(boolean isSortEnabled, UiManDataSetList dataSetList) {
        if (isSortEnabled) {
            dataSetList.getAttributes().forEach(attribute -> {
                if (CollectionUtils.isNotEmpty(attribute.getAttributes())) {
                    attribute.getAttributes().sort(Comparator.comparing(UiManAttribute::getName));
                }
            });
        }
    }

    @Override
    public void checkOnDuplicate(UUID visibilityArea, String newNameDsl) {
        for (DataSetList dataSetList : this.getAll(visibilityArea)) {
            if (!dataSetList.getName().equals(newNameDsl)) continue;
            throw new DataSetListExistsException(newNameDsl);
        }
    }

    @Override
    @Transactional
    @Nonnull
    public DataSetList create(@Nonnull UUID visibilityArea, @Nonnull String name, @Nullable UUID testPlanId) {
        UUID createdBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp createdWhen = Timestamp.from(Instant.now());
        DataSetList dataSetList = this.repo.create(visibilityArea, name, testPlanId, createdBy, createdWhen);
        this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
        return dataSetList;
    }

    @Override
    @Nullable
    public DataSetList get(@Nonnull UUID id) {
        return this.dslTreeRepo.getEagerById(id, null, null, null, null, false);
    }

    @Override
    @Nonnull
    public List<DataSetList> getAll() {
        return this.repo.getAll();
    }

    @Override
    @Nonnull
    public List<DataSetList> getAll(@Nonnull UUID visibilityArea, @Nullable String labelName) {
        if (labelName == null) {
            return this.repo.getAll(visibilityArea);
        }
        return this.repo.getAllByLabel(visibilityArea, labelName);
    }

    @Override
    @Nonnull
    public List<DataSetList> getAll(@Nonnull List<UUID> datasetListIds) {
        return this.repo.getAll(datasetListIds);
    }

    @Override
    @Transactional
    public boolean modify(@Nonnull UUID dataSetListId, @Nullable String name, @Nullable UUID testPlanId, boolean clearTestPlan) {
        boolean result = false;
        if (clearTestPlan) {
            UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
            Timestamp modifiedWhen = Timestamp.from(Instant.now());
            result = this.repo.setTestPlan(dataSetListId, null, modifiedBy, modifiedWhen);
        }
        if (name != null && !name.isEmpty()) {
            result = this.rename(dataSetListId, name);
        }
        if (testPlanId != null) {
            result = this.setTestPlan(dataSetListId, testPlanId);
        }
        if (result) {
            this.dataSetListSnapshotService.findAndCommitIfExists(dataSetListId);
        }
        this.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        return result;
    }

    @Override
    public boolean rename(@Nonnull UUID dataSetListId, @Nonnull String name) {
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modifiedWhen = Timestamp.from(Instant.now());
        return this.repo.rename(dataSetListId, name, modifiedBy, modifiedWhen);
    }

    private boolean setTestPlan(@Nonnull UUID dataSetListId, @Nonnull UUID testPlanId) {
        UUID visibilityAreaOftestPlan;
        UUID visibilityAreaOfDataSetList = this.get(dataSetListId).getVisibilityArea().getId();
        if (visibilityAreaOfDataSetList.equals(visibilityAreaOftestPlan = this.testPlanRepo.getById(testPlanId).getVisibilityArea().getId())) {
            UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
            Timestamp modifiedWhen = Timestamp.from(Instant.now());
            return this.repo.setTestPlan(dataSetListId, testPlanId, modifiedBy, modifiedWhen);
        }
        throw new DataSetListAndTestPlanException();
    }

    @Override
    public DataSetList getByNameUnderVisibilityArea(UUID visibilityArea, String name) {
        return this.repo.getByNameUnderVisibilityArea(visibilityArea, name);
    }

    @Override
    @Nonnull
    public List<DataSet> getChildren(@Nonnull UUID dataSetListId, boolean evaluate, @Nullable String label) {
        return this.dsService.getByParentId(dataSetListId, evaluate, label).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<DatasetResponse> getListOfDsIdsAndNameAndDslId(@Nonnull List<UUID> dataSetListIds) {
        List<DataSetList> dataSetLists = this.getAll(dataSetListIds);
        return dataSetLists.stream().flatMap(dataSetList -> dataSetList.getDataSets().stream().map(dataSet -> new DatasetResponse((DataSet)dataSet, (DataSetList)dataSetList))).collect(Collectors.toList());
    }

    @Override
    public PaginationResponse<TableResponse> getAffectedAttributes(UUID dataSetListId, Integer page, Integer size) {
        PageRequest pageRequest = Objects.nonNull(page) && Objects.nonNull(size) ? PageRequest.of((int)page, (int)size) : null;
        return this.modelsProvider.getAttributesByTypeDatasetListId(dataSetListId, (Pageable)pageRequest);
    }

    @Override
    public List<TableResponse> getAffectedAttributes(UUID dataSetListId) {
        return this.repo.getAffectedAttributes(dataSetListId, null, null);
    }

    private void updateModifiedFields(UUID dataSetListId) {
        log.debug("DataSetListServiceImpl#updateModifiedFields(dataSetListId: {})", (Object)dataSetListId);
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modifiedWhen = Timestamp.from(Instant.now());
        this.repo.updateModifiedFields(dataSetListId, modifiedBy, modifiedWhen);
    }

    @Override
    public void updateModifiedFields(UUID dataSetListId, UUID modifiedBy, Timestamp modifiedWhen) {
        log.debug("DataSetListServiceImpl#updateModifiedFields(dataSetListId: {}, modifiedBy: {}, modifiedWhen: {})", new Object[]{dataSetListId, modifiedBy, modifiedWhen.toString()});
        this.repo.updateModifiedFields(dataSetListId, modifiedBy, modifiedWhen);
    }

    @Override
    public List<AffectedDataSetList> getAffectedDataSetLists(@Nonnull UUID dataSetListId, @Nullable Integer limit, @Nullable Integer offset) {
        log.debug("DataSetListServiceImpl#getAffectedDSL(dataSetListId: {}, limit: {}, offset: {})", new Object[]{dataSetListId, limit, offset});
        return this.repo.getAffectedDataSetLists(dataSetListId, limit, offset);
    }

    @Override
    public Timestamp getModifiedWhen(UUID dataSetListId) {
        log.debug("DataSetListServiceImpl#getDataSetListModifiedWhen(dataSetListId: {})", (Object)dataSetListId);
        Timestamp modifiedWhen = null;
        if (this.repo.existsById(dataSetListId) && (modifiedWhen = this.repo.getModifiedWhen(dataSetListId)) == null) {
            modifiedWhen = Timestamp.from(Instant.EPOCH);
        }
        return modifiedWhen;
    }

    @Override
    public Long getAffectedAttributesCount(UUID dataSetListId) {
        log.debug("DataSetListServiceImpl#getAffectedAttributesCount(dataSetListId: {})", (Object)dataSetListId);
        return this.modelsProvider.getAttributesByTypeDatasetListId(dataSetListId, null).getTotalCount();
    }

    @Override
    @Transactional
    public void delete(@Nonnull UUID dataSetListId) {
        Set<UUID> affectedDataSetLists = this.getAffectedAttributes(dataSetListId).stream().filter(response -> !dataSetListId.equals(response.getDslId())).map(TableResponse::getDslId).collect(Collectors.toSet());
        this.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        this.repo.delete(dataSetListId);
        affectedDataSetLists.forEach(uuid -> {
            this.updateModifiedFields((UUID)uuid);
            this.dataSetListSnapshotService.commitEntity((UUID)uuid);
        });
        this.dataSetListSnapshotService.deleteDataSetList(dataSetListId);
    }

    @Override
    @Transactional
    public DataSetList copy(@Nonnull UUID visibilityArea, @Nonnull UUID dataSetListId, @Nonnull String name, @Nullable Boolean withData, @Nullable UUID testPlanId) {
        log.info("Called service copying data set list {}", (Object)dataSetListId);
        DataSetList dslToCopy = this.get(dataSetListId);
        Preconditions.checkNotNull((Object)dslToCopy, (String)"Can not find data set list to copy by id %s", (Object)dataSetListId);
        if (testPlanId != null) {
            Preconditions.checkArgument((boolean)visibilityArea.equals(this.testPlanRepo.getById(testPlanId).getVisibilityArea().getId()), (Object)"Data Set List and Test Plan are in different Visibility Areas");
        }
        DataSetList newDsl = this.create(visibilityArea, name, testPlanId);
        Map<UUID, UUID> attrToAttr = this.copyAttr(dslToCopy, newDsl);
        if (Boolean.TRUE.equals(withData)) {
            for (DataSet ds : dslToCopy.getDataSets()) {
                this.dsService.copy(ds.getId(), newDsl.getId(), attrToAttr);
            }
        }
        newDsl = this.get(newDsl.getId());
        this.dataSetListSnapshotService.commitEntity(newDsl.getId());
        return newDsl;
    }

    @Override
    @Transactional
    public Map<UUID, Pair<UUID, UUID>> copy(String name, Map<UUID, Set<UUID>> data) {
        HashMap<UUID, Pair<UUID, UUID>> result = new HashMap<UUID, Pair<UUID, UUID>>();
        ArrayList<UUID> dslIds = new ArrayList<UUID>(data.keySet());
        if (dslIds.isEmpty()) {
            log.error("Can not find DataSet lists to copy - no ids.");
            throw new DataSetListNotFoundException();
        }
        Map<UUID, DataSetList> datasetListMap = this.getAll(dslIds).stream().collect(Collectors.toMap(Identified::getId, dsl -> dsl));
        for (Map.Entry<UUID, Set<UUID>> entry : data.entrySet()) {
            DataSetList dslToCopy = datasetListMap.get(entry.getKey());
            Preconditions.checkNotNull((Object)dslToCopy, (String)"Can not find data set list to copy by id %s", (Object)entry.getKey());
            DataSetList newDsl = this.create(dslToCopy.getVisibilityArea().getId(), dslToCopy.getName() + "_" + name, null);
            Map<UUID, UUID> attrToAttr = this.copyAttr(dslToCopy, newDsl);
            for (DataSet ds : dslToCopy.getDataSets()) {
                if (!entry.getValue().contains(ds.getId())) continue;
                DataSet copyDs = this.dsService.copy(ds, newDsl.getId(), attrToAttr);
                result.put(ds.getId(), (Pair<UUID, UUID>)new ImmutablePair((Object)copyDs.getId(), (Object)newDsl.getId()));
            }
            this.dataSetListSnapshotService.commitEntity(newDsl.getId());
        }
        return result;
    }

    private Map<UUID, UUID> copyAttr(DataSetList dslToCopy, DataSetList newDsl) {
        int ordering = 0;
        HashMap<UUID, UUID> attrToAttr = new HashMap<UUID, UUID>();
        for (Attribute attr : dslToCopy.getAttributes()) {
            Attribute newAttr = this.attributeService.copy(newDsl, attr, ordering);
            attrToAttr.put(attr.getId(), newAttr.getId());
            ++ordering;
        }
        return attrToAttr;
    }

    @Override
    @Transactional
    public Label mark(@Nonnull UUID dataSetListId, @Nonnull String name) {
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modifiedWhen = Timestamp.from(Instant.now());
        Label label = this.repo.mark(dataSetListId, name, modifiedBy, modifiedWhen);
        this.dataSetListSnapshotService.findAndCommitIfExists(dataSetListId);
        return label;
    }

    @Override
    public List<Label> getLabels(@Nonnull UUID dataSetListId) {
        return this.repo.getLabels(dataSetListId);
    }

    @Override
    @Transactional
    public boolean unmark(@Nonnull UUID dataSetListId, @Nonnull UUID labelId) {
        Timestamp modifiedWhen;
        UUID modifiedBy = ((UserInfo)this.userInfoProvider.get()).getId();
        boolean isUnmarked = this.repo.unmark(dataSetListId, labelId, modifiedBy, modifiedWhen = Timestamp.from(Instant.now()));
        if (isUnmarked) {
            this.dataSetListSnapshotService.findAndCommitIfExists(dataSetListId);
        }
        return isUnmarked;
    }

    @Override
    public boolean existsById(@Nonnull UUID dataSetListId) {
        log.debug("DataSetListServiceImpl#existsById(dataSetListId: {})", (Object)dataSetListId);
        return this.repo.existsById(dataSetListId);
    }

    @Override
    public void evictAllAffectedDatasetsFromContextCacheByDslId(UUID updatedDataSetListId) {
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDslId(updatedDataSetListId);
    }

    @Override
    @Transactional
    public void revert(UUID sagaSessionId, RevertRequest request) {
        Set<UUID> dataSetListIds = this.modelsProvider.getDataSetListIdsBySagaSessionIdIdAndVisibilityAreaId(sagaSessionId, request.getProjectId());
        dataSetListIds.forEach(this::delete);
    }

    public DataSetListServiceImpl(DataSetService dsService, DataSetListRepository repo, EvaluationService evaluationService, AttributeService attributeService, DataSetListTreeRepository dslTreeRepo, TestPlanRepository testPlanRepo, Provider<UserInfo> userInfoProvider, DataSetListSnapshotService dataSetListSnapshotService, ModelsProvider modelsProvider, MacrosCalculator macrosCalculator, MacroContextService macroContextService, JpaDataSetListService dataSetListService, MacrosFeignClient macrosFeignClient, DataSetParameterProvider dataSetParameterProvider, ClearCacheService clearCacheService) {
        this.dsService = dsService;
        this.repo = repo;
        this.evaluationService = evaluationService;
        this.attributeService = attributeService;
        this.dslTreeRepo = dslTreeRepo;
        this.testPlanRepo = testPlanRepo;
        this.userInfoProvider = userInfoProvider;
        this.dataSetListSnapshotService = dataSetListSnapshotService;
        this.modelsProvider = modelsProvider;
        this.macrosCalculator = macrosCalculator;
        this.macroContextService = macroContextService;
        this.dataSetListService = dataSetListService;
        this.macrosFeignClient = macrosFeignClient;
        this.dataSetParameterProvider = dataSetParameterProvider;
        this.clearCacheService = clearCacheService;
    }
}

