/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.exception.file.FileDsCopyException;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundException;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundToCopyException;
import org.qubership.atp.dataset.exception.file.FileDsSaveException;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GridFsServiceImpl
implements GridFsService {
    private static final Logger log = LoggerFactory.getLogger(GridFsServiceImpl.class);
    private final GridFsRepository repository;
    private final ParameterRepository parameterRepository;
    private final DataSetListSnapshotService commitEntityService;
    private final ClearCacheService clearCacheService;

    @Override
    public void save(FileData fileData, InputStream file, boolean isTestPlan) {
        Parameter parameter;
        log.debug("start save(fileData: {}, InputStream file)", (Object)fileData);
        this.repository.save(fileData, file);
        if (!isTestPlan && (parameter = this.parameterRepository.getById(fileData.getParameterUuid())) != null) {
            UUID dataSetListId = parameter.getDataSet().getDataSetList().getId();
            this.commitEntityService.findAndCommitIfExists(dataSetListId);
            this.clearCacheService.evictDatasetListContextCache(parameter.getDataSet().getId());
            this.clearCacheService.evictParameterCache(parameter.getId());
        }
    }

    @Override
    public GridFSFile getGridFsFile(UUID attachmentUuid) {
        Optional<GridFSFile> file = this.repository.getGridFsFile(attachmentUuid);
        if (file.isPresent()) {
            return file.get();
        }
        log.error("Can not found gridFs file with id: {}", (Object)attachmentUuid);
        return null;
    }

    @Override
    public void saveAll(List<FileData> filesData, MultipartFile file) {
        log.info("start saveAll(filesData: {}, file: {})", filesData, (Object)file.getOriginalFilename());
        filesData.forEach(fileData -> {
            try {
                this.repository.save((FileData)fileData, file.getInputStream());
                Parameter parameter = this.parameterRepository.getById(fileData.getParameterUuid());
                this.clearCacheService.evictDatasetListContextCache(parameter.getDataSet().getId());
                this.clearCacheService.evictParameterCache(parameter.getId());
            }
            catch (IOException e) {
                log.error("Cannot bulk save file resource. fileData: {}, file: {}", new Object[]{fileData, file.getOriginalFilename(), e});
                throw new FileDsSaveException();
            }
        });
    }

    @Override
    public void delete(UUID parameterUuid) {
        this.repository.remove(parameterUuid);
        Parameter parameter = this.parameterRepository.getById(parameterUuid);
        if (parameter != null) {
            if (parameter.isOverlap()) {
                ParameterOverlap parameterOverlap = parameter.asOverlap();
                this.parameterRepository.delete(parameterOverlap);
            }
            DataSet ds = parameter.getDataSet();
            UUID dataSetListId = ds.getDataSetList().getId();
            this.commitEntityService.findAndCommitIfExists(dataSetListId);
            this.clearCacheService.evictDatasetListContextCache(ds.getId());
        }
    }

    @Override
    public Optional<InputStream> get(UUID parameterUuid) {
        return this.repository.get(parameterUuid);
    }

    @Override
    public Map<UUID, Optional<InputStream>> getAll(List<UUID> parametersUuids) {
        return this.repository.getAll(parametersUuids);
    }

    @Override
    public void copy(UUID sourceParameterUuid, UUID targetParameterUuid, boolean isTestPlan) {
        Optional<InputStream> streamOptional = this.repository.get(sourceParameterUuid);
        Optional<FileData> parameterInfo = this.repository.getFileInfo(sourceParameterUuid);
        InputStream stream = streamOptional.orElseThrow(() -> {
            log.error("Can not create copy of file with id: " + sourceParameterUuid + "' file doesn't exist.");
            return new FileDsNotFoundToCopyException();
        });
        FileData fileData = parameterInfo.orElseThrow(() -> {
            log.error("Can not create copy of file with UUID '" + sourceParameterUuid + "', has no information about [Type, FileName, AttachmentUUid, ContentType].");
            return new FileDsCopyException();
        });
        fileData.setParameterUuid(targetParameterUuid);
        this.save(fileData, stream, isTestPlan);
    }

    @Override
    public void copyIfExist(UUID sourceParameterUuid, UUID targetParameterUuid, boolean isTestPlan) {
        log.debug("copyIfExist (sourceParameterId: {}, targetParameterId: {}, isTestPlan: {})", new Object[]{sourceParameterUuid, targetParameterUuid, isTestPlan});
        InputStream inputStream = this.repository.get(sourceParameterUuid).orElse(null);
        FileData fileData = this.repository.getFileInfo(sourceParameterUuid).orElse(null);
        if (Objects.nonNull(inputStream) && Objects.nonNull(fileData)) {
            log.debug("File found on source parameter - copying");
            fileData.setParameterUuid(targetParameterUuid);
            this.save(fileData, inputStream, isTestPlan);
        }
    }

    @Override
    public FileData getFileInfo(UUID parameterUuid) {
        return this.repository.getFileInfo(parameterUuid).orElseThrow(() -> {
            log.error("File not found by id: " + parameterUuid);
            return new FileDsNotFoundException();
        });
    }

    public GridFsServiceImpl(GridFsRepository repository, ParameterRepository parameterRepository, DataSetListSnapshotService commitEntityService, ClearCacheService clearCacheService) {
        this.repository = repository;
        this.parameterRepository = parameterRepository;
        this.commitEntityService = commitEntityService;
        this.clearCacheService = clearCacheService;
    }
}

