/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.crypt.exception.AtpEncryptException;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.dto.ParameterDataDto;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.exception.attribute.AttributeNotFoundException;
import org.qubership.atp.dataset.exception.attribute.AttributeTypeException;
import org.qubership.atp.dataset.exception.file.FileDsUploadException;
import org.qubership.atp.dataset.exception.parameter.ParameterOverlapLevelDownException;
import org.qubership.atp.dataset.exception.parameter.ParameterValueEncryptException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributePath;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.direct.EncryptionService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.impl.ClearCacheServiceImpl;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ParameterServiceImpl
implements ParameterService {
    private static final Logger log = LoggerFactory.getLogger(ParameterServiceImpl.class);
    private static final String EMPTY_STRING = "";
    private static final int OVERLAP_MAX_LEVELS = 15;
    private final Provider<DataSetService> dsServiceProvider;
    private final DateAuditorService dateAuditorService;
    private final ParameterRepository repo;
    private final AliasWrapperService aliasWrapperService;
    private final AttributeService attributeService;
    private final GridFsService gridFsService;
    private final DataSetListSnapshotService dataSetListSnapshotService;
    private final EncryptionService encryptionService;
    private final ClearCacheServiceImpl clearCacheService;

    @Nonnull
    private ParameterDataDto extractData(@Nonnull Parameter parameter, UUID newParentId) {
        UUID listValueId = parameter.getListValue() == null ? null : this.extractListValueData(parameter, newParentId);
        UUID dsRef = parameter.getDataSetReference() == null ? null : parameter.getDataSetReference().getId();
        return this.prepareData(parameter.getAttribute().getId(), parameter.getDataSet().getId(), parameter.getText(), listValueId, dsRef, parameter.getAttribute().getType() == AttributeType.FILE);
    }

    private UUID extractListValueData(@Nonnull Parameter parameter, UUID newParentId) {
        if (newParentId == null) {
            return parameter.getListValue().getId();
        }
        List<ListValue> newListValues = ((Attribute)this.attributeService.get(newParentId)).getListValues();
        String oldValue = parameter.getListValue().getName();
        ListValue newValue = newListValues.stream().filter(value -> value.getName().equals(oldValue)).findFirst().get();
        return newValue.getId();
    }

    @Override
    @Transactional
    @Nonnull
    public Parameter create(@Nonnull UUID dsId, @Nonnull UUID attrId, @Nullable String text, @Nullable UUID listValueReference, @Nullable UUID referenceDataSet) {
        Parameter parameter = this.repo.create(dsId, attrId, this.prepareData(attrId, dsId, text, listValueReference, referenceDataSet, false));
        DataSetList dataSetList = parameter.getDataSet().getDataSetList();
        this.dateAuditorService.updateModifiedFields(dataSetList.getId());
        this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
        return parameter;
    }

    @Override
    @Transactional
    @CacheEvict(value={"ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE_OS"}, key="#dsId")
    @NotNull
    public Parameter setParamSelectJavers(@NotNull UUID dsId, @NotNull UUID targetAttrId, @Nullable List<UUID> attrPathIds, @Nullable String stringValue, @Nullable UUID dsRef, @Nullable UUID listValueRef, boolean isJavers) {
        return this.setParameter(dsId, targetAttrId, attrPathIds, stringValue, dsRef, listValueRef, isJavers);
    }

    @Override
    @Nonnull
    @Transactional
    public Parameter set(@Nonnull UUID dsId, @Nonnull UUID targetAttrId, @Nullable List<UUID> attrPathIds, @Nullable String stringValue, @Nullable UUID dsRef, @Nullable UUID listValueRef) {
        this.clearCacheService.evictDatasetListContextCache(dsId);
        return this.setParameter(dsId, targetAttrId, attrPathIds, stringValue, dsRef, listValueRef, true);
    }

    @Override
    @Nonnull
    public Parameter set(@Nonnull UUID dsId, @Nonnull UUID targetAttrId, @Nonnull String value, List<UUID> attrPathIds) {
        String stringValue = null;
        UUID dsRef = null;
        UUID listValueRef = null;
        Attribute attr = (Attribute)this.attributeService.get(targetAttrId);
        if (attr == null) {
            log.error("No such attribute");
            throw new AttributeNotFoundException();
        }
        AttributeType type = attr.getType();
        switch (type) {
            case CHANGE: 
            case ENCRYPTED: 
            case TEXT: {
                stringValue = value;
                break;
            }
            case LIST: {
                listValueRef = UUID.fromString(value);
                break;
            }
            case DSL: {
                dsRef = UUID.fromString(value);
                break;
            }
            default: {
                String error = "Unknown attribute type " + (Object)((Object)type);
                log.error(error);
                throw new AttributeTypeException(attr.getName(), type.toString());
            }
        }
        return this.set(dsId, targetAttrId, attrPathIds, stringValue, dsRef, listValueRef);
    }

    @NotNull
    private Parameter setParameter(@NotNull UUID dsId, @NotNull UUID targetAttrId, @Nullable List<UUID> attrPathIds, @Nullable String stringValue, @Nullable UUID dsRef, @Nullable UUID listValueRef, @NotNull Boolean isJavers) {
        this.checkDsLocked(targetAttrId, dsId);
        ParameterDataDto data = this.prepareData(targetAttrId, dsId, stringValue, listValueRef, dsRef, false);
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{stringValue, dsRef, listValueRef})) {
            isJavers = false;
        }
        if (attrPathIds == null || attrPathIds.isEmpty()) {
            Parameter target = this.repo.getByDataSetIdAttributeId(dsId, targetAttrId);
            if (target != null) {
                log.debug("Updating parameter {} in ds {}", (Object)target.getId(), (Object)dsId);
                Parameter parameter = this.repo.update(target, data);
                this.dateAuditorService.updateModifiedFields(parameter.getDataSet().getDataSetList().getId());
                if (isJavers.booleanValue()) {
                    log.debug("Javers activated");
                    this.dataSetListSnapshotService.commitEntity(parameter.getDataSet().getDataSetList().getId());
                }
                return parameter;
            }
            log.debug("Creating parameter of attribute {} in ds {}", (Object)targetAttrId, (Object)dsId);
            Parameter parameter = this.repo.create(dsId, targetAttrId, data);
            this.dateAuditorService.updateModifiedFields(parameter.getDataSet().getDataSetList().getId());
            if (isJavers.booleanValue()) {
                log.debug("Javers activated");
                this.dataSetListSnapshotService.commitEntity(parameter.getDataSet().getDataSetList().getId());
            }
            return parameter;
        }
        if (attrPathIds.size() > 15) {
            String message = String.format("You cannot overlap parameters deeper than %s levels down", 15);
            log.error(message);
            throw new ParameterOverlapLevelDownException(message);
        }
        DataSet ds = (DataSet)((DataSetService)this.dsServiceProvider.get()).get(dsId);
        Preconditions.checkArgument((ds != null ? 1 : 0) != 0, (String)"No data set found by id: %s", (Object)dsId);
        UUID dslId = ds.getDataSetList().getId();
        ParameterOverlap target = this.repo.getOverlap(dslId, dsId, targetAttrId, attrPathIds);
        if (target != null) {
            log.debug("Updating overlap parameter {} with path {}, in ds {}", new Object[]{target.getId(), attrPathIds, dsId});
            Parameter parameter = this.repo.update(target, data);
            this.dateAuditorService.updateModifiedFields(parameter.getDataSet().getDataSetList().getId());
            if (isJavers.booleanValue()) {
                log.debug("Javers activated");
                this.dataSetListSnapshotService.commitEntity(parameter.getDataSet().getDataSetList().getId());
            }
            return parameter;
        }
        log.debug("Creating overlap parameter with path {}, in ds {}", attrPathIds, (Object)dsId);
        ParameterOverlap parameterOverlap = this.repo.overlap(dslId, dsId, targetAttrId, data, attrPathIds);
        this.dateAuditorService.updateModifiedFields(parameterOverlap.getDataSet().getDataSetList().getId());
        if (isJavers.booleanValue()) {
            log.debug("Javers activated");
            this.dataSetListSnapshotService.commitEntity(parameterOverlap.getDataSet().getDataSetList().getId());
        }
        return parameterOverlap;
    }

    @Override
    @Transactional
    public boolean bulkUpdateValue(@Nullable String stringValue, @Nullable UUID dsRef, @Nullable UUID listValueRef, @Nonnull List<UUID> parameterIds) {
        ParameterDataDto data = new ParameterDataDto(stringValue, dsRef, listValueRef);
        boolean isUpdated = this.repo.update(parameterIds, data);
        if (isUpdated) {
            parameterIds.stream().map(parameterId -> this.repo.getById((UUID)parameterId)).filter(Objects::nonNull).map(Parameter::getDataSet).collect(Collectors.groupingBy(DataSet::getDataSetList)).keySet().forEach(dataSetList -> {
                this.dateAuditorService.updateModifiedFields(dataSetList.getId());
                this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
            });
        }
        return isUpdated;
    }

    @Override
    public FileData upload(UUID datasetId, UUID attributeId, List<UUID> attrPathIds, String contentType, String fileName, InputStream file) {
        Parameter parameter = CollectionUtils.isEmpty(attrPathIds) ? this.getOrCreateByDataSetIdAttributeId(datasetId, attributeId) : this.getOrCreateOverlap(datasetId, attributeId, attrPathIds);
        Preconditions.checkNotNull((Object)parameter.getId(), (Object)"Could not get parameters id");
        return this.upload(parameter.getId(), contentType, fileName, file);
    }

    @Override
    public FileData upload(UUID parameterUuid, String contentType, String fileName, InputStream file) {
        FileData fileData = new FileData(fileName, parameterUuid, contentType);
        this.gridFsService.save(fileData, file, false);
        return fileData;
    }

    @Override
    public List<FileData> bulkUploadAttachment(UUID dataSetListId, List<UUID> dataSetsIds, UUID attributeId, MultipartFile file, List<UUID> attrPathIds) {
        String fileName = file.getOriginalFilename();
        String contentType = file.getContentType();
        List<FileData> parametersToUpdate = this.getParametersToUpdate(attributeId, dataSetsIds, attrPathIds, fileName, contentType);
        log.info("bulkUpload of file parameters for attribute {} and datasets {}", (Object)attributeId, dataSetsIds);
        try {
            this.gridFsService.saveAll(parametersToUpdate, file);
        }
        catch (IOException e) {
            log.error("Cannot upload file {}", (Object)fileName, (Object)e);
            throw new FileDsUploadException(fileName);
        }
        this.dateAuditorService.updateModifiedFields(dataSetListId);
        return parametersToUpdate;
    }

    private List<FileData> getParametersToUpdate(UUID attributeId, List<UUID> dataSetsIds, List<UUID> attrPathIds, String fileName, String contentType) {
        ArrayList<FileData> parametersToUpdate = new ArrayList<FileData>();
        Function<UUID, Function> getOrCreate = CollectionUtils.isEmpty(attrPathIds) ? ds -> attr -> service -> service.getOrCreateByDataSetIdAttributeId((UUID)ds, (UUID)attr) : ds -> attr -> service -> service.getOrCreateOverlap((UUID)ds, (UUID)attr, attrPathIds);
        dataSetsIds.forEach(dsId -> parametersToUpdate.add(this.prepareParams((UUID)dsId, attributeId, fileName, contentType, (Function<UUID, Function<UUID, Function<ParameterService, Parameter>>>)getOrCreate)));
        return parametersToUpdate;
    }

    private FileData prepareParams(UUID dsId, UUID attributeId, String fileName, String contentType, Function<UUID, Function<UUID, Function<ParameterService, Parameter>>> getOrCreate) {
        Parameter parameter = getOrCreate.apply(dsId).apply(attributeId).apply(this);
        Preconditions.checkNotNull((Object)parameter, (Object)"Could not get parameter");
        return new FileData(fileName, parameter.getId(), contentType);
    }

    @Override
    public List<Object> bulkUpdate(UUID dataSetListId, List<UUID> attrPathIds, List<UUID> dataSetsIds, UUID attributeId, String value, MultipartFile file) {
        if (CollectionUtils.isEmpty(dataSetsIds)) {
            dataSetsIds = this.getListOfDataSetByDataSetListId(dataSetListId);
        }
        this.removeForSkipIdsDsLocked(dataSetListId, dataSetsIds);
        log.info("bulkUpdate of parameters for attribute {} and datasets {}", (Object)attributeId, dataSetsIds);
        ArrayList<Object> updatedObjects = new ArrayList<Object>();
        if (this.isFile(attributeId)) {
            if (file == null) {
                updatedObjects.addAll(this.bulkClearAttachment(dataSetsIds, attributeId, attrPathIds, dataSetListId));
            } else {
                updatedObjects.addAll(this.bulkUploadAttachment(dataSetListId, dataSetsIds, attributeId, file, attrPathIds));
            }
        } else if ((value = StringUtils.trimToNull((String)value)) == null) {
            updatedObjects.addAll(this.bulkClearParameter(dataSetsIds, attributeId, dataSetListId, attrPathIds));
        } else {
            updatedObjects.addAll(this.bulkSetParameter(dataSetsIds, attributeId, value, attrPathIds));
        }
        return updatedObjects;
    }

    private void removeForSkipIdsDsLocked(UUID dataSetListId, List<UUID> dataSetsIds) {
        List filteredDsLocked = dataSetsIds.stream().filter(dsId -> {
            DataSet dataSet = (DataSet)((DataSetService)this.dsServiceProvider.get()).get((UUID)dsId);
            return Objects.isNull(dataSet) || dataSet.isLocked() != false;
        }).collect(Collectors.toList());
        dataSetsIds.removeAll(filteredDsLocked);
        log.info("Remove for skip locked datasets id:{} from datasetList id {}", filteredDsLocked, (Object)dataSetListId);
    }

    private boolean isFile(UUID attributeId) {
        Attribute attr = (Attribute)this.attributeService.get(attributeId);
        return attr != null && AttributeType.FILE == attr.getType();
    }

    private List<Parameter> bulkSetParameter(List<UUID> dataSetsIds, UUID attributeId, String value, List<UUID> attrPathIds) {
        ArrayList<Parameter> updatedObjects = new ArrayList<Parameter>();
        dataSetsIds.forEach(dsId -> updatedObjects.add(this.set((UUID)dsId, attributeId, value, attrPathIds)));
        return updatedObjects;
    }

    private List<Parameter> bulkClearParameter(List<UUID> dataSetsIds, UUID attributeId, UUID datasetListId, List<UUID> attrPathIds) {
        ArrayList<Parameter> updatedObjects = new ArrayList<Parameter>();
        dataSetsIds.forEach(dsId -> this.delete(attributeId, (UUID)dsId, datasetListId, attrPathIds));
        return updatedObjects;
    }

    private List<FileData> bulkClearAttachment(List<UUID> dataSetsIds, UUID attributeId, List<UUID> attrPathIds, UUID dataSetListId) {
        List<FileData> parametersToUpdate = this.getParametersToUpdate(attributeId, dataSetsIds, attrPathIds, null, null);
        parametersToUpdate.forEach(fileData -> this.clearAttachment(fileData.getParameterUuid()));
        this.dateAuditorService.updateModifiedFields(dataSetListId);
        return parametersToUpdate;
    }

    @Override
    public void clearAttachment(UUID parameterId) {
        this.gridFsService.delete(parameterId);
    }

    private List<UUID> getListOfDataSetByDataSetListId(UUID dataSetListId) {
        return ((DataSetService)this.dsServiceProvider.get()).getByParentId(dataSetListId, false, null).map(DataSet::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public boolean update(@Nonnull UUID parameterId, String text) {
        Parameter parameter = this.repo.getById(parameterId);
        if (parameter == null) {
            return false;
        }
        UUID attributeId = parameter.getAttribute().getId();
        UUID dsId = parameter.getDataSet().getId();
        return this.repo.update(parameterId, this.prepareData(attributeId, dsId, text, null, null, parameter.getAttribute().getType() == AttributeType.FILE));
    }

    @Override
    @Nullable
    public Parameter get(@Nonnull UUID id) {
        return this.repo.getById(id);
    }

    @Override
    public boolean existsById(@NotNull UUID id) {
        return this.repo.existsById(id);
    }

    @Override
    @Nonnull
    public List<Parameter> getAll() {
        return this.repo.getAll();
    }

    @Override
    @Transactional
    public boolean delete(@Nonnull Parameter parameter) {
        return this.repo.delete(parameter);
    }

    @Override
    @Transactional
    public boolean delete(@Nonnull UUID attributeId, @Nonnull UUID dataSetId, UUID datasetListId, List<UUID> attrPathIds) {
        this.clearCacheService.evictDatasetListContextCache(dataSetId);
        return this.deleteParameter(attributeId, dataSetId, datasetListId, attrPathIds, true);
    }

    private boolean deleteParameter(@Nonnull UUID attributeId, @Nonnull UUID dataSetId, UUID datasetListId, List<UUID> attrPathIds, boolean isJavers) {
        this.checkDsLocked(attributeId, dataSetId);
        Parameter parameter = this.repo.getByDataSetIdAttributeId(dataSetId, attributeId);
        if (parameter == null) {
            parameter = this.repo.getOverlap(datasetListId, dataSetId, attributeId, attrPathIds);
        }
        if (parameter == null) {
            return false;
        }
        DataSetList dataSetList = parameter.getDataSet().getDataSetList();
        this.repo.delete(parameter);
        this.dateAuditorService.updateModifiedFields(dataSetList.getId());
        if (isJavers) {
            log.debug("Javers activated");
            this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
        }
        return true;
    }

    @Override
    @Transactional
    public void deleteParamSelectJavers(@Nonnull UUID attributeId, @Nonnull UUID dataSetId, UUID datasetListId, List<UUID> attrPathIds, boolean isJavers) {
        this.deleteParameter(attributeId, dataSetId, datasetListId, attrPathIds, isJavers);
    }

    @Override
    @Transactional
    public Parameter copy(@Nonnull DataSet newParentDs, @Nonnull Parameter parameter, @Nullable Map<UUID, UUID> attributes) {
        UUID newParentId;
        UUID parentId = parameter.getAttribute().getId();
        UUID uUID = newParentId = attributes == null ? null : attributes.get(parentId);
        if (newParentId == null) {
            newParentId = parentId;
        }
        UUID dsId = newParentDs.getId();
        ParameterDataDto data = this.extractData(parameter, newParentId);
        Parameter result = null;
        if (!parameter.isOverlap()) {
            result = this.repo.create(dsId, newParentId, data);
        } else {
            List<UUID> attrPathIds = parameter.asOverlap().getAttributePath().getPath().stream().map(attribute -> {
                UUID oldId = attribute.getId();
                UUID newId = null;
                if (attributes != null) {
                    newId = (UUID)attributes.get(oldId);
                }
                return newId == null ? oldId : newId;
            }).collect(Collectors.toList());
            UUID dslId = newParentDs.getDataSetList().getId();
            result = this.repo.overlap(dslId, dsId, newParentId, data, attrPathIds);
        }
        if (data.isFile()) {
            this.copyFile(parameter, result);
        }
        if (result != null) {
            newParentDs.getParameters().add(result);
        }
        return result;
    }

    private void copyFile(Parameter parameter, Parameter result) {
        if (this.gridFsService.get(parameter.getId()).isPresent()) {
            this.gridFsService.copy(parameter.getId(), result.getId(), false);
        }
    }

    private ParameterDataDto prepareData(@Nonnull UUID attrId, @Nonnull UUID dsId, @Nullable String text, @Nullable UUID listValueReference, @Nullable UUID referenceDataSet, boolean isFile) {
        if (text != null) {
            Attribute attribute = (Attribute)this.attributeService.get(attrId);
            if (attribute == null) {
                log.error(String.format("Attribute %s not found", attrId));
                throw new AttributeNotFoundException();
            }
            if (AttributeType.ENCRYPTED.equals((Object)attribute.getType()) && !Strings.isNullOrEmpty((String)text.replace("\u0000", EMPTY_STRING)) && !this.encryptionService.isEncrypted(text)) {
                try {
                    text = this.encryptionService.decodeBase64(text);
                    text = this.encryptionService.encrypt(text);
                }
                catch (AtpEncryptException e) {
                    log.error("Failed to encrypt parameter {}", (Object)attrId);
                    throw new ParameterValueEncryptException();
                }
            }
            text = this.wrapToAlias(text, attrId);
            text = this.convertToEmptyIfNeed(text);
        }
        return new ParameterDataDto(text, referenceDataSet, listValueReference, isFile);
    }

    private String wrapToAlias(String text, UUID attributeId) {
        DataSetList dsl = Proxies.base(DataSetList.class, () -> {
            Attribute attribute = (Attribute)this.attributeService.get(attributeId);
            Preconditions.checkNotNull((Object)attribute, (String)"Attribute not found by Id: %s", (Object)attributeId);
            return attribute.getDataSetList();
        });
        VisibilityArea va = Proxies.base(VisibilityArea.class, dsl::getVisibilityArea);
        return this.aliasWrapperService.wrapToAlias(text, va, dsl);
    }

    @Override
    @Nullable
    public Parameter getByDataSetIdAttributeId(UUID dataSetId, UUID attrId) {
        return this.repo.getByDataSetIdAttributeId(dataSetId, attrId);
    }

    @Override
    @Nullable
    public List<Parameter> getByAttributeIdAndDatasetIds(@Nonnull UUID attributeId, @Nonnull Set<UUID> datasetIds) {
        return this.repo.getByAttributeIdAndDatasetIds(attributeId, datasetIds);
    }

    @Override
    @Nullable
    public Parameter getOrCreateByDataSetIdAttributeId(UUID dataSetId, UUID attrId) {
        Parameter parameter = this.getByDataSetIdAttributeId(dataSetId, attrId);
        if (parameter == null) {
            parameter = this.create(dataSetId, attrId, null, null, null);
        }
        return parameter;
    }

    @Override
    @Nonnull
    public Parameter getOrCreateOverlap(UUID dsId, UUID targetAttrId, List<UUID> attrPathIds) {
        DataSet ds = (DataSet)((DataSetService)this.dsServiceProvider.get()).get(dsId);
        Preconditions.checkArgument((ds != null ? 1 : 0) != 0, (String)"No data set found by id: %s", (Object)dsId);
        UUID dslId = ds.getDataSetList().getId();
        ParameterOverlap target = this.repo.getOverlap(dslId, dsId, targetAttrId, attrPathIds);
        if (target == null) {
            target = this.repo.overlap(dslId, dsId, targetAttrId, new ParameterDataDto(null, null, null, true), attrPathIds);
        }
        return target;
    }

    private String convertToEmptyIfNeed(String text) {
        if (!Strings.isNullOrEmpty((String)text) && text.charAt(0) == '\u0000') {
            return EMPTY_STRING;
        }
        return text;
    }

    @Override
    @Nullable
    public ParameterOverlap getOverlap(@Nonnull UUID dsId, @Nonnull UUID attributeId, @Nonnull List<UUID> attributePathIds) {
        DataSet ds = (DataSet)((DataSetService)this.dsServiceProvider.get()).get(dsId);
        Preconditions.checkArgument((ds != null ? 1 : 0) != 0, (String)"No data set found by id: %s", (Object)dsId);
        UUID dslId = ds.getDataSetList().getId();
        return this.repo.getOverlap(dslId, dsId, attributeId, attributePathIds);
    }

    @Override
    public Stream<ParameterOverlap> getOverlaps(@Nonnull UUID targetAttributeId, @Nonnull Predicate<AttributePath> filter) {
        return this.repo.getOverlaps(targetAttributeId, filter);
    }

    @Override
    public List<?> getParametersAffectedByListValue(UUID listValueId, boolean withDsl) {
        if (withDsl) {
            return this.repo.findAllByListValueIdWithDataSetList(listValueId);
        }
        return this.repo.findAllByListValueId(listValueId);
    }

    @Override
    public List<TableResponse> getParametersAffectedByListValues(List<UUID> listValueIds) {
        return this.repo.findAllByListValueIdsWithDataSetList(listValueIds);
    }

    private void checkDsLocked(@NotNull UUID attributeId, @NotNull UUID dataSetId) {
        DataSet dataSet = (DataSet)((DataSetService)this.dsServiceProvider.get()).get(dataSetId);
        Preconditions.checkArgument((!Objects.isNull(dataSet) && dataSet.isLocked() == false ? 1 : 0) != 0, (String)"Can not change parameter with attribute id: %s because dataset id locked: %s", (Object)attributeId, (Object)dataSetId);
    }

    public ParameterServiceImpl(Provider<DataSetService> dsServiceProvider, DateAuditorService dateAuditorService, ParameterRepository repo, AliasWrapperService aliasWrapperService, AttributeService attributeService, GridFsService gridFsService, DataSetListSnapshotService dataSetListSnapshotService, EncryptionService encryptionService, ClearCacheServiceImpl clearCacheService) {
        this.dsServiceProvider = dsServiceProvider;
        this.dateAuditorService = dateAuditorService;
        this.repo = repo;
        this.aliasWrapperService = aliasWrapperService;
        this.attributeService = attributeService;
        this.gridFsService = gridFsService;
        this.dataSetListSnapshotService = dataSetListSnapshotService;
        this.encryptionService = encryptionService;
        this.clearCacheService = clearCacheService;
    }
}

