/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AbstractAttributeConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.models.ParameterImportResponse;
import org.qubership.atp.dataset.service.direct.importexport.utils.ImportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DatasetLinkAttributeImportConverter
extends AbstractAttributeConverter
implements AttributeImportConverter {
    private static final Logger log = LoggerFactory.getLogger(DatasetLinkAttributeImportConverter.class);
    private final ParameterService parameterService;

    @Override
    public ParameterImportResponse importAttributeParameter(AttributeImportModel importModel, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext) throws Exception {
        log.debug("Import dsl attribute parameter, import model: '{}', dataset param value: '{}', import context: '{}'", new Object[]{importModel, datasetParameterValue, importContext});
        UUID attributeId = importModel.getId();
        String attributeName = importModel.getName();
        String datasetName = datasetParameterValue.getDatasetName();
        UUID datasetId = datasetParameterValue.getDatasetId();
        String parameterValue = datasetParameterValue.getTextValue();
        String datasetListReference = datasetParameterValue.getDatasetListReference();
        String datasetReference = datasetParameterValue.getDatasetReference();
        String refDatasetKey = ImportUtils.getDatasetKey(datasetListReference, datasetReference);
        UUID refDatasetId = importContext.getRefDatasetId(refDatasetKey);
        boolean isJavers = importContext.isJavers();
        List<UUID> attributePath = importModel.getPath();
        boolean isDataChanges = false;
        boolean isRootDslAttribute = attributeName.equals(importModel.getRootDatasetListName());
        log.debug("Is root dsl attribute: {}", (Object)isRootDslAttribute);
        String targetRefDsName = "";
        if (!isRootDslAttribute) {
            boolean attributeShouldOverlap = this.isAttributeShouldOverlap(importModel, datasetParameterValue, importContext, parameter -> !refDatasetId.equals(parameter.getDataSetReference().getId()));
            if (!attributeShouldOverlap) {
                attributePath = Collections.emptyList();
                String refAttributeKey = this.getRefAttributeKey(importModel, datasetParameterValue);
                Parameter refDsParameter = importContext.getRefParameter(refAttributeKey);
                targetRefDsName = this.getTargetRefDsName(refDsParameter, targetRefDsName);
            } else {
                targetRefDsName = importContext.getTargetDslOverlaps().get(datasetParameterValue.getDatasetName() + "_" + importModel.getKey());
            }
        } else {
            Parameter refDsParameter = this.parameterService.getByDataSetIdAttributeId(datasetId, attributeId);
            targetRefDsName = this.getTargetRefDsName(refDsParameter, targetRefDsName);
        }
        String keyAttributeValue = importModel.getKey();
        if (StringUtils.isNotEmpty((String)datasetReference) && !Objects.equals(datasetReference, targetRefDsName)) {
            log.info("Import parameter for dsl attribute Key '{}' Id '{}' in dataset '{}' with value '{}' and reference dataset '{}'", new Object[]{keyAttributeValue, attributeId, datasetName, parameterValue, refDatasetId});
            Parameter parameter2 = this.parameterService.setParamSelectJavers(datasetId, attributeId, attributePath, null, refDatasetId, null, isJavers);
            isDataChanges = true;
            log.debug("Parameter with has been successfully imported: {}", (Object)parameter2);
        } else if (StringUtils.isEmpty((String)datasetReference) && isRootDslAttribute && StringUtils.isNotEmpty((String)targetRefDsName)) {
            org.qubership.atp.dataset.service.jpa.delegates.DataSet dataset = importContext.getDataset(datasetId);
            UUID datasetListId = dataset.getDataSetList().getId();
            log.info("Delete parameter of attribute Key '{}' Id '{}' for dsl '{}' and ds '{}'", new Object[]{keyAttributeValue, attributeId, datasetListId, datasetId});
            this.parameterService.deleteParamSelectJavers(attributeId, datasetId, datasetListId, attributePath, false);
            isDataChanges = true;
        }
        return new ParameterImportResponse(isDataChanges ? datasetId : null);
    }

    private String getTargetRefDsName(Parameter refDsParameter, String targetRefDsName) {
        if (Objects.nonNull(refDsParameter)) {
            DataSet targetRefDs = refDsParameter.getDataSetReference();
            targetRefDsName = Objects.nonNull(targetRefDs) ? targetRefDs.getName() : targetRefDsName;
        }
        return targetRefDsName;
    }

    @Override
    public AttributeImportModel mapRowToImportModel(Map<Integer, String> row, AttributeImportContext importContext, ListIterator<Map<Integer, String>> rowsIterator) {
        Map<Integer, String> nextRow;
        log.debug("Map excel row to DSL attribute import model");
        AttributeImportModel rootDslAttributeImportModel = this.mapTextRowToImportModel(row, importContext);
        String rootDatasetListName = rootDslAttributeImportModel.getRootDatasetListName();
        if (rootDatasetListName == null) {
            String rootAttributeName = rootDslAttributeImportModel.getName();
            log.debug("Set root DSL list name: {}", (Object)rootAttributeName);
            rootDslAttributeImportModel.setRootDatasetListName(rootAttributeName);
        }
        if (rowsIterator.hasNext() && !ImportUtils.isBlankRow(nextRow = rowsIterator.next())) {
            String nextAttributeKey = this.getAttributeKey(nextRow);
            log.debug("Next row attribute key: {}", (Object)nextAttributeKey);
            boolean isDslChildAttribute = ImportUtils.isArrowDelimiterPresent(nextAttributeKey);
            log.debug("Rollback to previous row");
            rowsIterator.previous();
            if (isDslChildAttribute) {
                return this.mapChildrenRowsToImportModel(rootDslAttributeImportModel, importContext, rowsIterator);
            }
            return rootDslAttributeImportModel;
        }
        return rootDslAttributeImportModel;
    }

    private AttributeImportModel mapChildrenRowsToImportModel(AttributeImportModel parentModel, AttributeImportContext importContext, ListIterator<Map<Integer, String>> rowsIterator) {
        log.debug("Map DSL attribute children excel rows to import model. Parent import model: {}", (Object)parentModel);
        String parentAttributeName = parentModel.getKey();
        log.debug("Parent attribute name: {}", (Object)parentAttributeName);
        while (rowsIterator.hasNext()) {
            Map<Integer, String> row = rowsIterator.next();
            if (ImportUtils.isBlankRow(row)) continue;
            String attributeName = this.getRowAttributeName(row);
            log.debug("Child attribute name: {}", (Object)attributeName);
            if (attributeName.startsWith(parentAttributeName)) {
                AttributeImportModel childModel = this.mapTextRowToImportModel(row, importContext);
                childModel.setParent(parentModel);
                log.debug("Child import model: {}", (Object)childModel);
                String attributeKey = childModel.getKey();
                UUID childAttributeId = importContext.getAttributeId(attributeKey);
                log.debug("Child attribute id: {}", (Object)childAttributeId);
                AttributeType attributeType = childModel.getType();
                childModel.setId(childAttributeId);
                childModel.addPath(parentModel);
                String parentDslReference = importContext.getAttributeDslRef(parentModel.getKey());
                childModel.setDatasetListReference(parentDslReference);
                boolean isChildDslAttribute = AttributeType.DSL.equals((Object)attributeType);
                if (isChildDslAttribute) {
                    childModel.setRootDatasetListName(parentAttributeName);
                    log.debug("Set root DSL name: {}", (Object)parentAttributeName);
                    parentModel.addChildren(this.mapChildrenRowsToImportModel(childModel, importContext, rowsIterator));
                    continue;
                }
                childModel.fillParentDslReferences(parentModel);
                log.debug("Fill parent DSL references");
                parentModel.addChildren(childModel);
                continue;
            }
            rowsIterator.previous();
            break;
        }
        return parentModel;
    }

    @Override
    public List<ParameterImportResponse> validate(AttributeImportModel model, AttributeImportContext context) {
        log.debug("Validate DSL attribute import model. Import model: '{}', context: '{}'", (Object)model, (Object)context);
        return new ArrayList<ParameterImportResponse>();
    }

    public DatasetLinkAttributeImportConverter(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

