/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListCycleException;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListNotFoundException;
import org.qubership.atp.dataset.service.jpa.JpaVisibilityAreaService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListContextService;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.CyclesCheckResult;
import org.qubership.atp.dataset.service.jpa.model.VisibilityAreaFlatModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetListCheckService {
    @Autowired
    protected DataSetListContextService dataSetListContextService;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected JpaVisibilityAreaService visibilityAreaService;

    public CyclesCheckResult checkOnCyclesAll() {
        CyclesCheckResult result = new CyclesCheckResult();
        for (VisibilityAreaFlatModel visibilityAreaFlatModel : this.visibilityAreaService.getAll()) {
            for (UUID dataSetListId : visibilityAreaFlatModel.getDataSetLists()) {
                try {
                    DataSetList dataSetListById = this.modelsProvider.getDataSetListById(dataSetListId);
                    if (!dataSetListById.getDataSets().isEmpty()) {
                        this.dataSetListContextService.getDataSetListContext(dataSetListId, Collections.emptyList(), Collections.emptyList(), null);
                        result.getResults().put(dataSetListId, "OK");
                        continue;
                    }
                    result.getResults().put(dataSetListId, "NO_DATASETS");
                }
                catch (DataSetListNotFoundException e) {
                    result.getResults().put(dataSetListId, e.getMessage());
                }
            }
        }
        return result;
    }

    public void checkOnCyclesThrowException(DataSetList dataSetList) {
        LinkedList<UUID> level = new LinkedList<UUID>();
        this.checkRecursively(dataSetList, level);
    }

    private void checkRecursively(DataSetList dataSetList, List<UUID> level) {
        if (level.contains(dataSetList.getId())) {
            throw new DataSetListCycleException();
        }
        level.add(dataSetList.getId());
        for (Attribute dslAttribute : dataSetList.getAttributes()) {
            if (dslAttribute.getAttributeType() != AttributeTypeName.DSL) continue;
            this.checkRecursively(dslAttribute.getTypeDataSetList(), level);
        }
        level.remove(dataSetList.getId());
    }
}

