/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.attribute.AttributeNotFoundException;
import org.qubership.atp.dataset.exception.datasetlist.DataSetListNotFoundException;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListAsyncService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListContextService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.DataSetListDependencyNode;
import org.qubership.atp.dataset.service.jpa.model.copy.DataSetListCopyData;
import org.qubership.atp.dataset.service.jpa.model.dscontext.CycleChecker;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.dsl.DataSetListFlat;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext.RefDataSetListFlat;
import org.qubership.atp.dataset.service.rest.server.CopyDataSetListsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class JpaDataSetListServiceImpl
implements JpaDataSetListService {
    private static final Logger log = LoggerFactory.getLogger(JpaDataSetListServiceImpl.class);
    @Autowired
    protected DataSetListContextService dataSetListContextService;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected DataSetParameterProvider parameterProvider;
    @Autowired
    protected DataSetListAsyncService dataSetListAsyncService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=true)
    public DataSetListFlat getDataSetListFlat(UUID dataSetListId) {
        try {
            DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
            this.checkNotNull(dataSetListId, dataSetList);
            DataSetListFlat dataSetListFlat = new DataSetListFlat(dataSetList, this.parameterProvider);
            return dataSetListFlat;
        }
        finally {
            this.dataSetListContextService.dropLocalThreadCache();
        }
    }

    @Override
    @Transactional
    public List<CopyDataSetListsResponse> copyDataSetLists(List<UUID> dataSetListIds, boolean updateReferences, String postfix, String prevNamePattern) {
        return this.copyDataSetLists(dataSetListIds, updateReferences, null, postfix, prevNamePattern, null);
    }

    @Override
    @Transactional
    public List<CopyDataSetListsResponse> copyDataSetLists(List<UUID> dataSetListIds, boolean updateReferences, UUID targetVisibilityAreaId, String postfix, String prevNamePattern, @Nullable UUID sagaSessionId) {
        long duration;
        LinkedList<CopyDataSetListsResponse> result = new LinkedList<CopyDataSetListsResponse>();
        LinkedHashMap<UUID, UUID> dataSetMap = new LinkedHashMap<UUID, UUID>();
        LinkedList<DataSetList> copies = new LinkedList<DataSetList>();
        LinkedHashMap<UUID, DataSetListCopyData> copiesData = new LinkedHashMap<UUID, DataSetListCopyData>();
        long startTime = System.currentTimeMillis();
        try {
            this.copyDataSetLists(dataSetListIds, copies, copiesData, dataSetMap, result, postfix, prevNamePattern, sagaSessionId);
            if (updateReferences) {
                for (DataSetList dataSetList : copies) {
                    log.debug("UpdateReferences dataSetList copies id: {}", (Object)dataSetList.getId());
                    dataSetList.updateDslReferences(copiesData, dataSetMap);
                }
            }
            duration = (System.currentTimeMillis() - startTime) / 1000L;
            log.info("Finish copy Dataset Lists, time sec: {}", (Object)duration);
        }
        catch (Exception e) {
            log.error("Cannot copy Data Set Lists or update Dsl References exception:", (Throwable)e);
        }
        log.info("Copy all DSL step 1 - Finish");
        startTime = System.currentTimeMillis();
        LinkedList overlapFutures = new LinkedList();
        for (DataSetList dataSetList : copies) {
            try {
                overlapFutures.add(this.dataSetListAsyncService.updateOverlaps(dataSetList, copiesData));
            }
            catch (Exception e) {
                log.error("Cannot update overlaps overlapFutures.add: ", (Throwable)e);
            }
        }
        for (Future future : overlapFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Cannot update overlaps future.get: ", (Throwable)e);
            }
        }
        if (targetVisibilityAreaId != null) {
            for (DataSetList dataSetList : copies) {
                dataSetList.setVisibilityArea(targetVisibilityAreaId);
            }
        }
        duration = (System.currentTimeMillis() - startTime) / 1000L;
        log.info("Finish copy Dataset Lists, time sec: {}", (Object)duration);
        log.info("Update overlaps step 2 - Finish");
        return result;
    }

    private void copyDataSetLists(List<UUID> dataSetListIds, List<DataSetList> copies, Map<UUID, DataSetListCopyData> copiesData, Map<UUID, UUID> dataSetMap, List<CopyDataSetListsResponse> result, @Nullable String postfix, String prevNamePattern, @Nullable UUID sagaSessionId) {
        LinkedHashMap<UUID, Future<DataSetListCopyData>> copyDslFutures = new LinkedHashMap<UUID, Future<DataSetListCopyData>>();
        for (UUID dataSetListId : dataSetListIds) {
            copyDslFutures.put(dataSetListId, this.dataSetListAsyncService.duplicate(dataSetListId, postfix, prevNamePattern, sagaSessionId));
        }
        for (UUID dataSetListId : copyDslFutures.keySet()) {
            try {
                DataSetListCopyData duplicateData = (DataSetListCopyData)((Future)copyDslFutures.get(dataSetListId)).get();
                Preconditions.checkNotNull((Object)duplicateData, (Object)("Duplicate data is null for DataSetList with id " + dataSetListId));
                copies.add(duplicateData.getDataSetListCopy());
                copiesData.put(dataSetListId, duplicateData);
                dataSetMap.putAll(duplicateData.getDataSetsMap());
                CopyDataSetListsResponse dslResult = new CopyDataSetListsResponse();
                dslResult.setOriginalId(dataSetListId);
                dslResult.setCopyId(duplicateData.getCopyId());
                dslResult.setDatasets(duplicateData.getDataSetsMap());
                result.add(dslResult);
            }
            catch (Exception e) {
                log.error("Cannot duplicate DataSetList with id {}.", (Object)dataSetListId, (Object)e);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public DataSetList getById(UUID dataSetListId) {
        return this.modelsProvider.getDataSetListById(dataSetListId);
    }

    @Override
    @Transactional
    public void remove(UUID dataSetListId) {
        DataSetList object = this.modelsProvider.getDataSetListById(dataSetListId);
        if (object != null) {
            object.remove();
        }
    }

    @Override
    @Transactional
    public DataSetList create(String name, UUID visibilityAreaId) {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(visibilityAreaId);
        return visibilityArea.createDataSetList(name);
    }

    @Override
    @Transactional
    public DataSetList replicate(UUID id, String name, UUID visibilityAreaId, UUID sourceId, UUID createdBy, Timestamp createdWhen, UUID modifiedBy, Timestamp modifiedWhen) throws DataSetServiceException {
        return this.modelsProvider.replicateDataSetList(id, name, visibilityAreaId, sourceId, createdBy, createdWhen, modifiedBy, modifiedWhen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=true)
    public RefDataSetListFlat getReferencedDataSetListFlat(UUID dataSetListId, UUID dataSetListAttributeId, String attributePath, @Nullable List<UUID> dataSetIds, Pageable pageable) {
        try {
            DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
            this.checkNotNull(dataSetListId, dataSetList);
            List<Integer> columnsToLoad = this.getColumnsToLoad(dataSetList, dataSetListAttributeId, dataSetIds);
            boolean isLastPage = this.checkLastPage(columnsToLoad, pageable);
            columnsToLoad = this.getSubListByPage(columnsToLoad, pageable);
            List<UUID> path = this.getPath(attributePath);
            DataSetListContext dataSetListContext = this.dataSetListContextService.getDataSetListContext(dataSetListId, columnsToLoad, Arrays.asList(AttributeTypeName.values()), path, pageable);
            RefDataSetListFlat refDataSetListFlat = new RefDataSetListFlat(dataSetListContext, dataSetList, path, this.parameterProvider, isLastPage);
            return refDataSetListFlat;
        }
        finally {
            this.dataSetListContextService.dropLocalThreadCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=true)
    public RefDataSetListFlat getReferencedDataSetListFlatRows(UUID dataSetListId, UUID dataSetListAttributeId, String attributePath, @Nullable List<UUID> dataSetIds, Pageable pageable) {
        try {
            DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
            this.checkNotNull(dataSetListId, dataSetList);
            List<Integer> columnsToLoad = this.getColumnsToLoad(dataSetList, dataSetListAttributeId, dataSetIds);
            List<UUID> path = this.getPath(attributePath);
            DataSetListContext dataSetListContext = this.dataSetListContextService.getDataSetListContext(dataSetListId, columnsToLoad, Arrays.asList(AttributeTypeName.values()), path, pageable);
            RefDataSetListFlat refDataSetListFlat = new RefDataSetListFlat(dataSetListContext, dataSetList, path, this.parameterProvider);
            return refDataSetListFlat;
        }
        finally {
            this.dataSetListContextService.dropLocalThreadCache();
        }
    }

    private List<Integer> getColumnsToLoad(DataSetList dataSetList, UUID dataSetListAttributeId, @Nullable List<UUID> dataSetIds) {
        Attribute attribute = this.modelsProvider.getAttributeById(dataSetListAttributeId);
        if (attribute == null) {
            log.error("Attribute {} not found", (Object)dataSetListAttributeId);
            throw new AttributeNotFoundException();
        }
        LinkedList<Integer> columnsToLoad = new LinkedList();
        if (CollectionUtils.isEmpty(dataSetIds)) {
            Integer dataSetsCount = dataSetList.getDataSetsCount();
            for (int i = 0; i < dataSetsCount; ++i) {
                columnsToLoad.add(i);
            }
        } else {
            columnsToLoad = dataSetList.getDataSetColumnsByIds(dataSetIds);
        }
        return columnsToLoad;
    }

    private void checkNotNull(UUID dataSetListId, DataSetList dataSetList) {
        if (dataSetList == null) {
            log.error("Data Set List {} not found", (Object)dataSetListId);
            throw new DataSetListNotFoundException();
        }
    }

    private boolean checkLastPage(List list, Pageable pageable) {
        int startIdx = pageable.getPageNumber() * pageable.getPageSize();
        return startIdx >= list.size() - pageable.getPageSize();
    }

    private <T> List<T> getSubListByPage(List<T> list, Pageable pageable) {
        int startIdx = pageable.getPageNumber() * pageable.getPageSize();
        int endIdx = startIdx + pageable.getPageSize();
        if (startIdx >= list.size()) {
            return Collections.emptyList();
        }
        return list.subList(startIdx, Math.min(endIdx, list.size()));
    }

    public List<UUID> getPath(String key) {
        String[] splitResult;
        LinkedList<UUID> result = new LinkedList<UUID>();
        for (String splitPart : splitResult = key.split(",")) {
            result.add(UUID.fromString(splitPart));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public DataSetListContext getDataSetListContext(UUID dataSetListId, List<UUID> dataSetsIds, Pageable pageable) {
        AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST, AttributeTypeName.FILE, AttributeTypeName.CHANGE};
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        this.checkNotNull(dataSetListId, dataSetList);
        List<Integer> columnsToLoad = dataSetList.getDataSetsColumns(dataSetsIds);
        return this.dataSetListContextService.getDataSetListContext(dataSetListId, columnsToLoad, Arrays.asList(attributesToLoad), null, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public DataSetListContext getDataSetListContext(UUID dataSetListId, List<UUID> dataSetsIds) {
        AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST, AttributeTypeName.FILE, AttributeTypeName.CHANGE};
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        this.checkNotNull(dataSetListId, dataSetList);
        List<Integer> columnsToLoad = dataSetList.getDataSetsColumns(dataSetsIds);
        return this.dataSetListContextService.getDataSetListContext(dataSetListId, columnsToLoad, Arrays.asList(attributesToLoad), null, null);
    }

    @Override
    @Transactional
    public void save(DataSetList dataSetList) {
        dataSetList.save();
    }

    @Override
    @Transactional(readOnly=true)
    public List<DataSetListDependencyNode> getDependencies(List<UUID> dataSetListIds) {
        LinkedList<DataSetListDependencyNode> result = new LinkedList<DataSetListDependencyNode>();
        for (UUID dataSetListId : dataSetListIds) {
            result.add(this.getDependencies(dataSetListId));
        }
        return result;
    }

    public DataSetListDependencyNode getDependencies(UUID dataSetListId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        this.checkNotNull(dataSetListId, dataSetList);
        return DataSetListDependencyNode.getDependencyTree(dataSetList);
    }

    @Override
    public List<DataSetListDependencyNode> getDependenciesRecursive(List<UUID> dataSetListIds) {
        LinkedHashSet<UUID> dataSetListIdsResult = new LinkedHashSet<UUID>();
        for (UUID dataSetListId : dataSetListIds) {
            DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
            if (dataSetList == null) continue;
            CycleChecker cycleChecker = new CycleChecker();
            this.getAllDslRecursively(dataSetList, dataSetListIdsResult, cycleChecker);
        }
        return this.getDependencies(new LinkedList<UUID>(dataSetListIdsResult));
    }

    @Override
    public List<DataSetList> getByNameAndVisibilityAreaId(String name, UUID visibilityArea) {
        return this.modelsProvider.getDataSetListByNameAndVisibilityAreaId(name, visibilityArea);
    }

    @Override
    public List<DataSetList> getByVisibilityAreaId(UUID visibilityAreaId) {
        return this.modelsProvider.getByVisibilityAreaId(visibilityAreaId);
    }

    @Override
    public List<DataSetList> getBySourceIdAndVisibilityAreaId(UUID sourceId, UUID visibilityAreaId) {
        return this.modelsProvider.getDataSetListBySourceIdAndVisibilityAreaId(sourceId, visibilityAreaId);
    }

    private Set<UUID> getAllDslRecursively(DataSetList dataSetList, Set<UUID> dataSetListIds, CycleChecker cycleChecker) {
        dataSetListIds.add(dataSetList.getId());
        cycleChecker.openNode(dataSetList.getId());
        List<Attribute> referencedAttributes = dataSetList.getAttributesByTypes(Collections.singletonList(AttributeTypeName.DSL));
        for (Attribute referencedAttribute : referencedAttributes) {
            DataSetList typeDataSetList = referencedAttribute.getTypeDataSetList();
            this.getAllDslRecursively(typeDataSetList, dataSetListIds, cycleChecker);
        }
        cycleChecker.closeNode(dataSetList.getId());
        return dataSetListIds;
    }

    @Override
    @Transactional(readOnly=true)
    public Timestamp getModifiedWhen(UUID dataSetListId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        if (dataSetList == null) {
            return Timestamp.from(Instant.EPOCH);
        }
        return dataSetList.getModifiedWhen();
    }

    @Override
    public LinkedList<UUID> getDataSetsIdsByDataSetListId(UUID dataSetListId) {
        return this.modelsProvider.getDataSetsIdsByDataSetListId(dataSetListId);
    }

    @Override
    @Transactional
    public void checkDslNames(UUID visibilityArea) {
        List<String> names = this.modelsProvider.getNotUniqueDslNames(visibilityArea);
        if (!names.isEmpty()) {
            throw new RuntimeException(String.format("There are duplicated DSL names: %s", names));
        }
    }
}

