/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListContextService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResultContainer;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.DataSetListParameterExtractor;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.ParameterExtractor;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.tree.DataSetListEvaluatedParametersCache;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MacroContextServiceImpl
implements MacroContextService {
    @Autowired
    protected DataSetListContextService dataSetListContextService;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Lazy
    @Autowired
    protected DataSetParameterProvider parameterProvider;
    protected ThreadLocal<DataSetListEvaluatedParametersCache> cachedEvaluatedValues = new ThreadLocal();
    protected ThreadLocal<CachedDslMacroResultContainer> cachedDslMacroValues = new ThreadLocal();

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public String getTextParameterByListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSetPath, List<PathStep> referenceAttributePath, PathStep attribute) throws DataSetServiceException {
        dataSetPath = this.translateDataSetIdToName(dataSetPath);
        referenceAttributePath = this.findAndTranslateAttributesIdsToNames(referenceAttributePath);
        attribute = this.findAndTranslateAttributeIdToName(attribute);
        DataSetList topLevelDataSetList = this.getDataSetList(visibilityAreaId, dataSetList);
        Pair<Integer, UUID> dataSetColumnAndId = this.getDataSetColumnByIdOrName(topLevelDataSetList, dataSetPath);
        AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST};
        DataSetListContext dataSetListContext = this.dataSetListContextService.getDataSetListContext(topLevelDataSetList.getId(), Collections.singletonList((Integer)dataSetColumnAndId.getKey()), Arrays.asList(attributesToLoad), null);
        ParameterExtractor extractor = new ParameterExtractor(dataSetListContext, (UUID)dataSetColumnAndId.getValue(), (Integer)dataSetColumnAndId.getKey(), Collections.emptyList(), referenceAttributePath, attribute);
        extractor.setCache(this.getCachedEvaluatedValues(dataSetListContext.getDataSetListId()));
        return extractor.extractWithProvider(this.parameterProvider);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public String getTextParameterByExternalListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSetPath, List<PathStep> referenceAttributePath, PathStep attribute) throws DataSetServiceException {
        dataSetPath = this.translateDataSetIdToName(dataSetPath);
        referenceAttributePath = this.findAndTranslateAttributesIdsToNames(referenceAttributePath);
        attribute = this.findAndTranslateAttributeIdToName(attribute);
        DataSetList topLevelDataSetList = this.getDataSetList(visibilityAreaId, dataSetList);
        DataSetListParameterExtractor dataSetListParameterExtractor = new DataSetListParameterExtractor(topLevelDataSetList, dataSetPath, referenceAttributePath, attribute);
        return dataSetListParameterExtractor.extract();
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public String getTextParameterFromCachedContextByNamesPath(UUID visibilityAreaId, PathStep topLevelDataSetList, UUID dataSetId, int dataSetColumn, List<UUID> macroPosition, List<PathStep> pathSteps, PathStep attribute) throws DataSetServiceException {
        pathSteps = this.findAndTranslateAttributesIdsToNames(pathSteps);
        attribute = this.findAndTranslateAttributeIdToName(attribute);
        DataSetList dataSetList = this.getDataSetList(visibilityAreaId, topLevelDataSetList);
        AttributeTypeName[] attributesToLoad = new AttributeTypeName[]{AttributeTypeName.TEXT, AttributeTypeName.ENCRYPTED, AttributeTypeName.LIST, AttributeTypeName.DSL};
        DataSetListContext dataSetListContext = this.dataSetListContextService.getDataSetListContext(dataSetList.getId(), Collections.singletonList(dataSetColumn), Arrays.asList(attributesToLoad), null);
        ParameterExtractor extractor = new ParameterExtractor(dataSetListContext, dataSetId, dataSetColumn, macroPosition, pathSteps, attribute);
        extractor.setCache(this.getCachedEvaluatedValues(dataSetList.getId()));
        return extractor.extractWithProvider(this.parameterProvider);
    }

    @Override
    public String getDataSetListName(UUID dataSetListId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        if (dataSetList == null) {
            return null;
        }
        return dataSetList.getName();
    }

    @Override
    public String getDataSetName(UUID dataSetListId) throws DataSetServiceException {
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetListId);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getName();
    }

    @Override
    public UUID getDataSetUuid(String dataSetName, UUID dataSetListId) throws DataSetServiceException {
        List<DataSet> dataSets = this.modelsProvider.getDataSetByNameAndDataSetListId(dataSetName, dataSetListId);
        if (CollectionUtils.isEmpty(dataSets)) {
            return null;
        }
        if (dataSets.size() > 1) {
            throw new DataSetServiceException(String.format("Multiple datasets found with name %s under dslId %s", dataSetName, dataSetListId));
        }
        return dataSets.get(0).getId();
    }

    @Override
    public String getAttributeName(UUID dataSetListId) throws DataSetServiceException {
        Attribute attribute = this.modelsProvider.getAttributeById(dataSetListId);
        if (attribute == null) {
            return null;
        }
        return attribute.getName();
    }

    private List<PathStep> findAndTranslateAttributesIdsToNames(List<PathStep> steps) {
        LinkedList<PathStep> result = new LinkedList<PathStep>();
        for (PathStep pathStep : steps) {
            result.add(this.findAndTranslateAttributeIdToName(pathStep));
        }
        return result;
    }

    private PathStep findAndTranslateAttributeIdToName(PathStep step) {
        if (step.getId() == null) {
            return step;
        }
        Attribute attribute = this.modelsProvider.getAttributeById(step.getId());
        if (attribute != null) {
            return new PathStep(attribute.getName());
        }
        return step;
    }

    private PathStep translateDataSetIdToName(PathStep step) {
        if (step.getId() == null) {
            return step;
        }
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(step.getId());
        if (dataSetList != null) {
            return new PathStep(dataSetList.getName());
        }
        return step;
    }

    @Override
    public DataSetList getDataSetList(UUID visibilityAreaId, PathStep dataSetListPathStep) throws DataSetServiceException {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(visibilityAreaId);
        DataSetList result = null;
        if (visibilityArea == null) {
            throw new DataSetServiceException("Visibility Area not found " + visibilityAreaId);
        }
        if (dataSetListPathStep.getId() != null) {
            result = visibilityArea.getDataSetListById(dataSetListPathStep.getId());
        }
        if (result == null) {
            result = visibilityArea.getDataSetListByName(dataSetListPathStep.getName());
        }
        if (result == null) {
            throw new DataSetServiceException("Data Set List not found " + dataSetListPathStep);
        }
        return result;
    }

    private Pair<Integer, UUID> getDataSetColumnByIdOrName(DataSetList dataSetList, PathStep dataSetToSearch) throws DataSetServiceException {
        ImmutablePair result = null;
        if (dataSetToSearch.getId() != null) {
            result = new ImmutablePair((Object)dataSetList.getDataSetColumnById(dataSetToSearch.getId()), (Object)dataSetToSearch.getId());
        }
        if (result == null) {
            result = new ImmutablePair((Object)dataSetList.getDataSetColumnByName(dataSetToSearch.getName()), (Object)dataSetList.getDataSetByName(dataSetToSearch.getName()).getId());
        }
        if (result == null) {
            throw new DataSetServiceException("Data Set not found " + dataSetToSearch);
        }
        return result;
    }

    @Override
    public Map<ParameterPositionContext, String> getCachedEvaluatedValues(UUID dataSetListId) {
        if (this.cachedEvaluatedValues.get() == null) {
            this.cachedEvaluatedValues.set(new DataSetListEvaluatedParametersCache());
        }
        return this.cachedEvaluatedValues.get().getCache(dataSetListId);
    }

    @Override
    public void dropLocalThreadCache() {
        this.cachedEvaluatedValues.remove();
        this.cachedDslMacroValues.remove();
    }

    @Override
    public CachedDslMacroResultContainer getDslMacroCache() {
        if (this.cachedDslMacroValues.get() == null) {
            this.cachedDslMacroValues.set(new CachedDslMacroResultContainer());
        }
        return this.cachedDslMacroValues.get();
    }
}

