/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.model.tree.Overlap;

public class OverlapNode
implements Serializable {
    private static final long serialVersionUID = 2784126984197713421L;
    private UUID dataSetListId;
    private UUID id;
    private Overlap[] overlaps;
    private List<OverlapNode> childNodes = new LinkedList<OverlapNode>();

    public OverlapNode(UUID id, UUID dataSetListId, int columns) {
        this.id = id;
        this.dataSetListId = dataSetListId;
        this.overlaps = new Overlap[columns];
    }

    public void addOverlap(List<UUID> path, int columnNumber, AttributeKey attributeKey) {
        if (attributeKey.getParameter() == null) {
            return;
        }
        if (path.isEmpty()) {
            if (this.overlaps[columnNumber] != null) {
                if (!this.overlaps[columnNumber].isTheSameAttributeOverlap(attributeKey)) {
                    UUID attributeId = attributeKey.getAttribute().getId();
                    if (!this.overlaps[columnNumber].getOverlappedAttributes().containsKey(attributeId)) {
                        this.overlaps[columnNumber].getOverlappedAttributes().put(attributeId, attributeKey);
                    }
                }
            } else {
                Overlap newOverlap = new Overlap();
                UUID attributeId = attributeKey.getAttribute().getId();
                newOverlap.getOverlappedAttributes().put(attributeId, attributeKey);
                this.overlaps[columnNumber] = newOverlap;
            }
        } else {
            UUID childNodeId = path.get(0);
            boolean nodeExists = false;
            for (OverlapNode childNode : this.childNodes) {
                boolean samePath = childNodeId.equals(childNode.getId());
                if (!samePath) continue;
                childNode.addOverlap(path.subList(1, path.size()), columnNumber, attributeKey);
                nodeExists = true;
                break;
            }
            if (!nodeExists) {
                OverlapNode newNode = new OverlapNode(childNodeId, this.dataSetListId, this.overlaps.length);
                this.childNodes.add(newNode);
                newNode.addOverlap(path.subList(1, path.size()), columnNumber, attributeKey);
            }
        }
    }

    public AttributeKey getOverlap(List<UUID> path, int column, UUID attributeId) {
        if (path.isEmpty()) {
            if (this.overlaps[column] != null) {
                return this.overlaps[column].getOverlapByAttributeId(attributeId);
            }
            return null;
        }
        for (OverlapNode childNode : this.childNodes) {
            if (!childNode.getId().equals(path.get(0))) continue;
            return childNode.getOverlap(path.subList(1, path.size()), column, attributeId);
        }
        return null;
    }

    public boolean containsOverlapsInPath(List<UUID> path, int column) {
        if (path.isEmpty()) {
            return this.overlaps[column] != null;
        }
        for (OverlapNode childNode : this.childNodes) {
            if (!childNode.getId().equals(path.get(0))) continue;
            return childNode.containsOverlapsInPath(path.subList(1, path.size()), column);
        }
        return false;
    }

    public UUID getDataSetListId() {
        return this.dataSetListId;
    }

    public UUID getId() {
        return this.id;
    }

    public Overlap[] getOverlaps() {
        return this.overlaps;
    }

    public List<OverlapNode> getChildNodes() {
        return this.childNodes;
    }

    public void setDataSetListId(UUID dataSetListId) {
        this.dataSetListId = dataSetListId;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setOverlaps(Overlap[] overlaps) {
        this.overlaps = overlaps;
    }

    public void setChildNodes(List<OverlapNode> childNodes) {
        this.childNodes = childNodes;
    }
}

