/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.ds;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class DataSetGroup {
    private AttributeTypeName type = AttributeTypeName.DSL;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dsl;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, AbstractParameter> parameters = new LinkedHashMap<String, AbstractParameter>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, DataSetGroup> groups = new LinkedHashMap<String, DataSetGroup>();
    @JsonIgnore
    private List<UUID> currentPath;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private UUID dataSetId;
    @JsonIgnore
    private Long order;

    public DataSetGroup(GroupContext groupContext, int column, boolean evaluate, MacroContext macroContext, DataSetParameterProvider dataSetParameterProvider, ContextType contextType, OverlapNode rootOverlapNode) {
        this.currentPath = groupContext.getCurrentPath();
        this.order = groupContext.getOrder();
        this.dsl = groupContext.getDataSetListName();
        List<DataSetContext> dataSets = groupContext.getDataSets();
        DataSetContext dataSet = this.getDataSetByColumnNumber(dataSets, column);
        if (dataSet != null) {
            this.dataSetId = dataSet.getId();
            if (contextType == ContextType.OBJECT && this.dataSetId == null) {
                return;
            }
            if (contextType == ContextType.OBJECT_EXTENDED) {
                if (this.dataSetId == null && rootOverlapNode.containsOverlapsInPath(this.currentPath, column)) {
                    for (GroupContext childGroup : groupContext.getGroups()) {
                        this.groups.put(childGroup.getName(), new DataSetGroup(childGroup, column, evaluate, macroContext, dataSetParameterProvider, contextType, rootOverlapNode));
                    }
                    this.value = dataSet.getName();
                } else {
                    return;
                }
            }
            List<ParameterContext> parametersContexts = dataSet.getParameters();
            for (ParameterContext parametersContext : parametersContexts) {
                if (contextType == ContextType.OBJECT_EXTENDED && !parametersContext.isOverlap()) continue;
                AbstractParameter resolvedParameter = dataSetParameterProvider.getDataSetParameterResolved(macroContext.getDataSetListContext().getDataSetListId(), parametersContext.getParameterId(), parametersContext.getType(), evaluate, macroContext, new ParameterPositionContext(this.currentPath, column, dataSet.getId(), parametersContext.getOrder(), groupContext.getDataSetListId()));
                if (contextType == ContextType.NO_NULL_VALUES && resolvedParameter.isNullValue()) continue;
                this.parameters.put(parametersContext.getName(), resolvedParameter);
            }
            for (GroupContext childGroup : groupContext.getGroups()) {
                DataSetGroup dataSetGroup = new DataSetGroup(childGroup, column, evaluate, macroContext, dataSetParameterProvider, contextType, rootOverlapNode);
                if (contextType == ContextType.NO_NULL_VALUES && dataSetGroup.getParameters().isEmpty() && dataSetGroup.getGroups().isEmpty()) continue;
                this.groups.put(childGroup.getName(), dataSetGroup);
            }
            this.value = dataSet.getName();
        }
    }

    private DataSetContext getDataSetByColumnNumber(List<DataSetContext> dataSets, int column) {
        for (DataSetContext dataSet : dataSets) {
            if (dataSet.getColumnNumber() != column) continue;
            return dataSet;
        }
        return null;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDsl() {
        return this.dsl;
    }

    public Map<String, AbstractParameter> getParameters() {
        return this.parameters;
    }

    public Map<String, DataSetGroup> getGroups() {
        return this.groups;
    }

    public List<UUID> getCurrentPath() {
        return this.currentPath;
    }

    public UUID getDataSetId() {
        return this.dataSetId;
    }

    public void setType(AttributeTypeName type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    public void setParameters(Map<String, AbstractParameter> parameters) {
        this.parameters = parameters;
    }

    public void setGroups(Map<String, DataSetGroup> groups) {
        this.groups = groups;
    }

    @JsonIgnore
    public void setCurrentPath(List<UUID> currentPath) {
        this.currentPath = currentPath;
    }

    public void setDataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
    }

    @JsonIgnore
    public void setOrder(Long order) {
        this.order = order;
    }

    public Long getOrder() {
        return this.order;
    }
}

