/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.mysema.commons.lang.Pair;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.service.direct.TestPlanService;
import org.qubership.atp.dataset.service.rest.View;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testplan"})
public class TestPlanController {
    private final TestPlanService testPlanService;

    @Autowired
    public TestPlanController(TestPlanService testPlanService) {
        this.testPlanService = testPlanService;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#vaId,'CREATE')")
    @PutMapping(value={"/va/{vaId}"})
    @AuditAction(auditAction="Creates new Test Plan with name: {{#name}} in project: {{#vaId}}")
    @Operation(summary="Creates new Test Plan with name provided.")
    public ResponseEntity<UUID> create(@PathVariable(value="vaId") UUID vaId, @RequestParam(value="name") String name, HttpServletRequest request) {
        Pair<TestPlan, Boolean> result = this.testPlanService.create(vaId, name);
        UUID testPlanId = ((TestPlan)result.getFirst()).getId();
        boolean created = (Boolean)result.getSecond();
        String url = request.getRequestURL().append("/").append(testPlanId.toString()).toString();
        URI uri = URI.create(url);
        return created ? ResponseEntity.created((URI)uri).body((Object)testPlanId) : ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).location(uri)).body((Object)testPlanId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#vaId,'DELETE')")
    @DeleteMapping(value={"/va/{vaId}"})
    @AuditAction(auditAction="Delete Test Plan with name: {{#name}} in project: {{#vaId}}")
    @Operation(summary="Deletes Test Plan with provided name.")
    public ResponseEntity<Void> delete(@PathVariable(value="vaId") UUID vaId, @RequestParam(value="name") String name) {
        boolean deleted = this.testPlanService.delete(vaId, name);
        return deleted ? ResponseEntity.noContent().build() : ResponseEntity.status((int)HttpStatus.NOT_MODIFIED.value()).build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#visibilityArea,'READ')")
    @GetMapping(value={"/va/{vaId}"})
    @AuditAction(auditAction="Get Test Plan for project: {{#vaId}}")
    @Operation(summary="Returns all test plans for selected visibility area.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TestPlan.class)))})})
    public List<TestPlan> getTestPlans(@PathVariable(value="vaId") UUID visibilityArea) {
        return this.testPlanService.getAll(visibilityArea);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/{testPlanId}/dsl"})
    @AuditAction(auditAction="Get dataSet Lists for Test Plan: {{#testPlanId}}")
    @Operation(summary="Returns dataSetLists with selected Test Plan")
    @JsonView(value={View.IdNameLabelsTestPlan.class})
    public List<DataSetList> getDataSetListsUnderTestPlan(@PathVariable(value="testPlanId") UUID testPlanId) {
        return this.testPlanService.getChildren(testPlanId);
    }
}

