/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.domain;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javers.core.metamodel.annotation.Entity;
import org.javers.core.metamodel.annotation.Id;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.versioning.model.domain.AttributeKeySnapshot;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetSnapshot;

@Entity
@TypeName(value="DataSetListSnapshot")
public class DataSetListSnapshot {
    @Id
    private final UUID id;
    private final List<DataSetSnapshot> dataSets = new LinkedList<DataSetSnapshot>();
    private final List<AttributeSnapshot> attributes = new LinkedList<AttributeSnapshot>();
    private final List<AttributeKeySnapshot> overlaps = new LinkedList<AttributeKeySnapshot>();
    private final String name;
    private final UUID visibilityAreaId;

    public DataSetListSnapshot(DataSetList model) {
        this.id = model.getId();
        this.name = model.getName();
        this.visibilityAreaId = model.getVisibilityArea().getId();
        for (DataSet dataSet : model.getDataSets()) {
            this.dataSets.add(new DataSetSnapshot(dataSet));
        }
        for (Attribute attribute : model.getAttributes()) {
            this.attributes.add(new AttributeSnapshot(attribute));
        }
        for (Map.Entry entry : model.getOverLapParametersMapping().entrySet()) {
            this.overlaps.add(new AttributeKeySnapshot((AttributeKey)entry.getKey(), (Parameter)entry.getValue()));
        }
    }

    public Set<UUID> getAttributeIds() {
        return this.getAttributes().stream().map(AttributeSnapshot::getId).collect(Collectors.toSet());
    }

    public Set<UUID> getDataSetsIds() {
        return this.getDataSets().stream().map(DataSetSnapshot::getId).collect(Collectors.toSet());
    }

    public Set<UUID> getOverlapsIds() {
        return this.getOverlaps().stream().map(AttributeKeySnapshot::getId).collect(Collectors.toSet());
    }

    public DataSetSnapshot getDataSetById(UUID dataSetId) {
        for (DataSetSnapshot dataSet : this.getDataSets()) {
            if (!dataSet.getId().equals(dataSetId)) continue;
            return dataSet;
        }
        return null;
    }

    public AttributeSnapshot getAttributeById(UUID attributeId) {
        for (AttributeSnapshot attributeSnapshot : this.getAttributes()) {
            if (!attributeSnapshot.getId().equals(attributeId)) continue;
            return attributeSnapshot;
        }
        return null;
    }

    public AttributeKeySnapshot getOverlapById(UUID overlapId) {
        for (AttributeKeySnapshot overlap : this.getOverlaps()) {
            if (!overlap.getId().equals(overlapId)) continue;
            return overlap;
        }
        return null;
    }

    public UUID getId() {
        return this.id;
    }

    public List<DataSetSnapshot> getDataSets() {
        return this.dataSets;
    }

    public List<AttributeSnapshot> getAttributes() {
        return this.attributes;
    }

    public List<AttributeKeySnapshot> getOverlaps() {
        return this.overlaps;
    }

    public String getName() {
        return this.name;
    }

    public UUID getVisibilityAreaId() {
        return this.visibilityAreaId;
    }

    public String toString() {
        return "DataSetListSnapshot(id=" + this.getId() + ", dataSets=" + this.getDataSets() + ", attributes=" + this.getAttributes() + ", overlaps=" + this.getOverlaps() + ", name=" + this.getName() + ", visibilityAreaId=" + this.getVisibilityAreaId() + ")";
    }
}

