/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import org.javers.core.Javers;
import org.javers.core.diff.Diff;
import org.javers.shadow.Shadow;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.service.ChangeProcessorsChain;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class JaversHistoryCacheableService {
    private static final Logger log = LoggerFactory.getLogger(JaversHistoryCacheableService.class);
    private final Javers javers;
    private final ChangeProcessorsChain changeProcessorsChain;

    @Autowired
    public JaversHistoryCacheableService(Javers javers, ChangeProcessorsChain changeProcessorsChain) {
        this.javers = javers;
        this.changeProcessorsChain = changeProcessorsChain;
    }

    @Cacheable(value={"JAVERS_DIFF_CACHE_OS"}, key="#oldShadow.getCommitId() + '_' + #actualShadow.getCommitId()")
    public HistoryItemDto compareTwoShadows(Shadow<DataSetListSnapshot> actualShadow, Shadow<DataSetListSnapshot> oldShadow) {
        DataSetListComparable actualEntity = this.convertToComparable(actualShadow);
        DataSetListComparable oldEntity = this.convertToComparable(oldShadow);
        Diff diff = this.javers.compare((Object)oldEntity, (Object)actualEntity);
        HistoryItemDto historyItem = this.changeProcessorsChain.proceed(diff, oldEntity, actualEntity);
        if (historyItem == null) {
            log.trace("Diff wasn't processed by any ChangeProcessor.");
            historyItem = new HistoryItemDto();
        }
        return historyItem;
    }

    private DataSetListComparable convertToComparable(Shadow<DataSetListSnapshot> shadow) {
        DataSetListSnapshot snapshot = (DataSetListSnapshot)shadow.get();
        return new DataSetListComparable(snapshot);
    }
}

