/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.mdc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class MdcUtils {
    public static boolean put(String key, UUID value) {
        if (value != null) {
            return MdcUtils.put(key, value.toString());
        }
        return false;
    }

    public static boolean put(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            MDC.put((String)key, (String)value);
            return true;
        }
        return false;
    }

    public static String convertIdNameToHeader(String idName) {
        return "X-" + Arrays.stream(idName.split("(?=\\p{Upper})")).map(org.springframework.util.StringUtils::capitalize).collect(Collectors.joining("-"));
    }

    public static String getHeaderFromRequest(HttpServletRequest request, String headerName) {
        if (request != null && request.getHeaderNames() != null) {
            for (String originalHeaderName : Collections.list(request.getHeaderNames())) {
                if (!originalHeaderName.equalsIgnoreCase(headerName)) continue;
                return request.getHeader(originalHeaderName);
            }
        }
        return null;
    }

    public static List<String> convertIdNamesToList(String businessIdsString) {
        return StringUtils.isNotBlank((CharSequence)businessIdsString) ? Arrays.stream(businessIdsString.split(",")).map(String::trim).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static void setContextMap(Map<String, String> mdcMap) {
        MDC.setContextMap((Map)(CollectionUtils.isEmpty(mdcMap) ? new HashMap() : mdcMap));
    }
}

