/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.adapter.filter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.common.logging.adapter.AtpHttpResponse;
import org.qubership.atp.common.logging.utils.Util;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ContentCachingHttpResponse
implements AtpHttpResponse {
    private final ContentCachingResponseWrapper response;
    private final HttpStatus status;

    public ContentCachingHttpResponse(ContentCachingResponseWrapper response) {
        this.response = response;
        this.status = HttpStatus.valueOf((int)response.getStatus());
    }

    @Override
    public HttpHeaders getHeaders() {
        return Util.getHeaders((HttpServletResponse)this.response);
    }

    @Override
    public HttpStatus getStatusCode() {
        return this.status;
    }

    @Override
    public int getStatusCodeValue() {
        return this.status.value();
    }

    @Override
    public String getStatusCodeReason() {
        return this.status.getReasonPhrase();
    }

    @Override
    public String getBody() throws IOException {
        return StreamUtils.copyToString((InputStream)this.response.getContentInputStream(), (Charset)Charset.defaultCharset());
    }

    public ContentCachingHttpResponse(ContentCachingResponseWrapper response, HttpStatus status) {
        this.response = response;
        this.status = status;
    }
}

