/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.interceptor;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.qubership.atp.common.logging.adapter.resttemplate.RestTemplateHttpRequest;
import org.qubership.atp.common.logging.adapter.resttemplate.RestTemplateHttpResponse;
import org.qubership.atp.common.logging.config.LoggingProperties;
import org.qubership.atp.common.logging.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateLogInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateLogInterceptor.class);
    private final LoggingProperties loggingProperties;

    @Nonnull
    public ClientHttpResponse intercept(@Nonnull HttpRequest request, @Nonnull byte[] bytes, @Nonnull ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        this.logRequest(request, bytes);
        ClientHttpResponse response = clientHttpRequestExecution.execute(request, bytes);
        this.logResponse(response);
        return response;
    }

    private void logRequest(HttpRequest httpRequest, byte[] body) {
        RestTemplateHttpRequest request = new RestTemplateHttpRequest(httpRequest, body);
        Boolean isLoggedHeaders = this.loggingProperties.logRestTemplateHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreRestTemplateHeaderPatterns();
        List<String> logs = Util.getLogRequestData(request, isLoggedHeaders, ignoreHeadersPattern);
        Util.logMessage(log, String.join((CharSequence)"\n", logs));
    }

    private void logResponse(ClientHttpResponse httpResponse) throws IOException {
        RestTemplateHttpResponse response = new RestTemplateHttpResponse(httpResponse);
        Boolean isLoggedHeaders = this.loggingProperties.logRestTemplateHeaders();
        List<Pattern> ignoreHeadersPattern = this.loggingProperties.getIgnoreRestTemplateHeaderPatterns();
        String body = response.getBody();
        List<String> logs = Util.getLogResponseData(response, body, isLoggedHeaders, ignoreHeadersPattern);
        Util.logMessage(log, String.join((CharSequence)"\n", logs));
    }

    public RestTemplateLogInterceptor(LoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }
}

