/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.utils;

import org.apache.logging.log4j.util.Strings;

public enum ContentType {
    APPLICATION_JSON("application/json", true),
    APPLICATION_XML("application/xml", true),
    TEXT_CSV("text/csv", true),
    TEXT_XML("text/xml", true),
    TEXT_HTML("text/html", true),
    TEXT_PAIN("text/plain", true),
    UNDEFINED("undefined", false);

    private String mimeType;
    private boolean loggingAllowed;

    private ContentType(String mimeType, boolean loggingAllowed) {
        this.mimeType = mimeType;
        this.loggingAllowed = loggingAllowed;
    }

    public static ContentType getContentType(String value) {
        for (ContentType type : ContentType.values()) {
            if (!type.mimeType.equals(value) && (Strings.isEmpty((CharSequence)value) || !type.mimeType.matches(".*?\\b" + value + "\\b.*?") && !value.matches(".*?\\b" + type.mimeType + "\\b.*?"))) continue;
            return type;
        }
        return UNDEFINED;
    }

    public boolean isLoggingAllowed() {
        return this.loggingAllowed;
    }
}

